/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.xml;

import com.aliasi.util.Strings;
import com.aliasi.xml.SAXFilterHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GroupCharactersFilter
extends SAXFilterHandler {
    private final boolean mRemoveWhitespace;
    private StringBuffer mCharAccumulator;

    public GroupCharactersFilter(DefaultHandler handler) {
        this(handler, false);
    }

    public GroupCharactersFilter(DefaultHandler handler, boolean removeWhitespace) {
        super(handler);
        this.mRemoveWhitespace = removeWhitespace;
    }

    public void startDocument() throws SAXException {
        this.mCharAccumulator = new StringBuffer();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.checkCharacters();
        super.endDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.checkCharacters();
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkCharacters();
        super.endElement(namespaceURI, localName, qName);
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        this.mCharAccumulator.append(ch, start, length);
    }

    private void checkCharacters() throws SAXException {
        if (this.mCharAccumulator.length() == 0) {
            return;
        }
        if (this.mRemoveWhitespace && Strings.allWhitespace(this.mCharAccumulator)) {
            this.mCharAccumulator = new StringBuffer();
            return;
        }
        super.characters(this.mCharAccumulator.toString().toCharArray(), 0, this.mCharAccumulator.length());
        this.mCharAccumulator = new StringBuffer();
    }
}

