/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.io.FileExtensionFilter;
import java.io.CharArrayReader;
import java.io.FileFilter;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XML {
    public static final String XML_SUFFIX = "xml";
    public static final FileFilter XML_FILE_FILTER = new FileExtensionFilter("xml", true);
    public static final FileFilter XML_FILE_ONLY_FILTER = new FileExtensionFilter("xml", false);
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String XERCES_BUFFER_SIZE_PROPERTY = "http://apache.org/xml/properties/input-buffer-size";

    private XML() {
    }

    public static String escape(String in) {
        StringBuffer sb = new StringBuffer();
        XML.escape(in, sb);
        return sb.toString();
    }

    public static void escape(String in, StringBuffer sb) {
        for (int i = 0; i < in.length(); ++i) {
            XML.escape(in.charAt(i), sb);
        }
    }

    public static void escape(char c, StringBuffer sb) {
        switch (c) {
            case '<': {
                XML.escapeEntity("lt", sb);
                return;
            }
            case '>': {
                XML.escapeEntity("gt", sb);
                return;
            }
            case '&': {
                XML.escapeEntity("amp", sb);
                return;
            }
            case '\"': {
                XML.escapeEntity("quot", sb);
                return;
            }
        }
        sb.append(c);
    }

    public static void escapeEntity(String xmlEntity, StringBuffer sb) {
        sb.append('&');
        sb.append(xmlEntity);
        sb.append(';');
    }

    public static void handle(String document, DefaultHandler handler) throws IOException, SAXException {
        CharArrayReader reader = new CharArrayReader(document.toCharArray());
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(handler);
        InputSource in = new InputSource(reader);
        xmlReader.parse(in);
    }
}

