/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tuple<E>
extends AbstractList<E> {
    private int mHashCode = 0;

    private Tuple() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract E get(int var1);

    @Override
    public int hashCode() {
        if (this.mHashCode == 0) {
            this.mHashCode = super.hashCode();
        }
        return this.mHashCode;
    }

    public static <E> Tuple<E> create() {
        return new EmptyTuple();
    }

    public static <E> Tuple<E> create(E obj) {
        return new SingletonTuple(obj);
    }

    public static <E> Tuple<E> create(E[] objs) {
        switch (objs.length) {
            case 0: {
                return new EmptyTuple();
            }
            case 1: {
                return new SingletonTuple(objs[0]);
            }
            case 2: {
                return new PairTuple(objs[0], objs[1]);
            }
        }
        return new ArrayTuple(objs);
    }

    public static <E> Tuple<E> create(E o1, E o2) {
        return new PairTuple(o1, o2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayTuple<E>
    extends Tuple<E> {
        private final E[] mObjs;

        private ArrayTuple(E[] objs) {
            this.mObjs = objs;
        }

        @Override
        public E get(int index) {
            return this.mObjs[index];
        }

        @Override
        public int size() {
            return this.mObjs.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairTuple<E>
    extends Tuple<E> {
        private final E mObject0;
        private final E mObject1;

        private PairTuple(E object0, E object1) {
            this.mObject0 = object0;
            this.mObject1 = object1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public E get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index must be > 0, was=" + index);
            }
            if (index > 1) {
                throw new IndexOutOfBoundsException("Index must be < 2, was=" + index);
            }
            return index == 0 ? this.mObject0 : this.mObject1;
        }

        public boolean equals(Tuple that) {
            return that != null && that.size() == 2 && this.mObject0.equals(that.get(0)) && this.mObject1.equals(that.get(1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonTuple<E>
    extends Tuple<E> {
        private final E mObject;

        private SingletonTuple(E object) {
            this.mObject = object;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public E get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index must be > 0, was=" + index);
            }
            if (index > 0) {
                throw new IndexOutOfBoundsException("Index must be < 1, was=" + index);
            }
            return this.mObject;
        }

        public boolean equals(Tuple that) {
            return that != null && that.size() == 1 && this.mObject.equals(that.get(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyTuple<E>
    extends Tuple<E> {
        private EmptyTuple() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public E get(int index) {
            String msg = "No elements in empty tuple.";
            throw new IndexOutOfBoundsException(msg);
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof Tuple && ((Tuple)that).size() == 0;
        }
    }
}

