/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Math;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;

public class Strings {
    public static String UTF8 = "UTF-8";
    public static char NBSP_CHAR = (char)160;
    public static char NEWLINE_CHAR = (char)10;
    public static char DEFAULT_SEPARATOR_CHAR = (char)32;
    public static String DEFAULT_SEPARATOR_STRING = String.valueOf(DEFAULT_SEPARATOR_CHAR);
    public static final String SINGLE_SPACE_STRING = " ";
    public static final String EMPTY_STRING = "";
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];

    private Strings() {
    }

    public static String save(String s) {
        return new String(s.toCharArray());
    }

    public static String reverse(CharSequence cs) {
        StringBuffer sb = new StringBuffer(cs.length());
        int i = cs.length();
        while (--i >= 0) {
            sb.append(cs.charAt(i));
        }
        return sb.toString();
    }

    public static boolean containsChar(String s, char c) {
        return s.indexOf(c) >= 0;
    }

    public static boolean allWhitespace(StringBuffer sb) {
        return Strings.allWhitespace(sb.toString());
    }

    public static boolean allWhitespace(String s) {
        return Strings.allWhitespace(s.toCharArray(), 0, s.length());
    }

    public static boolean allWhitespace(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            if (Strings.isWhitespace(ch[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || c == NBSP_CHAR;
    }

    public static void normalizeWhitespace(CharSequence cs, StringBuffer sb) {
        int length;
        int i = 0;
        for (length = cs.length(); length > 0 && Strings.isWhitespace(cs.charAt(length - 1)); --length) {
        }
        while (i < length && Strings.isWhitespace(cs.charAt(i))) {
            ++i;
        }
        boolean inWhiteSpace = false;
        while (i < length) {
            char nextChar = cs.charAt(i);
            if (Strings.isWhitespace(nextChar)) {
                if (!inWhiteSpace) {
                    sb.append(' ');
                    inWhiteSpace = true;
                }
            } else {
                inWhiteSpace = false;
                sb.append(nextChar);
            }
            ++i;
        }
    }

    public static String normalizeWhitespace(CharSequence cs) {
        StringBuffer sb = new StringBuffer();
        Strings.normalizeWhitespace(cs, sb);
        return sb.toString();
    }

    public static boolean allDigits(String s) {
        return Strings.allDigits(s.toCharArray(), 0, s.length());
    }

    public static boolean allDigits(char[] cs, int start, int length) {
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(cs[i + start])) continue;
            return false;
        }
        return true;
    }

    public static boolean isPunctuation(char c) {
        return c == ',' || c == '.' || c == '!' || c == '?' || c == ':' || c == ';';
    }

    public static String power(String s, int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String concatenate(Object[] xs) {
        return Strings.concatenate(xs, DEFAULT_SEPARATOR_STRING);
    }

    public static String concatenate(Object[] xs, String spacer) {
        return Strings.concatenate(xs, 0, spacer);
    }

    public static String concatenate(Object[] xs, int start, String spacer) {
        return Strings.concatenate(xs, start, xs.length, spacer);
    }

    public static String concatenate(Object[] xs, int start, int end) {
        return Strings.concatenate(xs, start, end, DEFAULT_SEPARATOR_STRING);
    }

    public static String concatenate(Object[] xs, int start, int end, String spacer) {
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < end; ++i) {
            if (i > start) {
                sb.append(spacer);
            }
            sb.append(xs[i]);
        }
        sb.setLength(sb.length());
        return sb.toString();
    }

    public static void indent(StringBuffer sb, int length) {
        sb.append(NEWLINE_CHAR);
        Strings.padding(sb, length);
    }

    public static String fit(String in, int length) {
        return in.length() > length ? in.substring(0, length) : in + Strings.padding(length - in.length());
    }

    public static String padding(int length) {
        StringBuffer sb = new StringBuffer();
        Strings.padding(sb, length);
        return sb.toString();
    }

    public static void padding(StringBuffer sb, int length) {
        for (int i = 0; i < length; ++i) {
            sb.append(DEFAULT_SEPARATOR_CHAR);
        }
    }

    public static String functionArgs(String functionName, Object[] args) {
        return functionName + Strings.functionArgsList(args);
    }

    public static String functionArgsList(Object[] args) {
        return "(" + Strings.concatenate(args, ",") + ")";
    }

    public static boolean allLowerCase(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLowerCase(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allLowerCase(CharSequence token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLowerCase(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allUpperCase(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isUpperCase(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allLetters(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allPunctuation(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (Strings.isPunctuation(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allPunctuation(String token) {
        int i = token.length();
        while (--i >= 0) {
            if (Strings.isPunctuation(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] split(String s, char c) {
        char[] cs = s.toCharArray();
        int tokCount = 1;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != c) continue;
            ++tokCount;
        }
        String[] result = new String[tokCount];
        int tokIndex = 0;
        int start = 0;
        for (int end = 0; end < cs.length; ++end) {
            if (cs[end] != c) continue;
            result[tokIndex] = new String(cs, start, end - start);
            ++tokIndex;
            start = end + 1;
        }
        result[tokIndex] = new String(cs, start, cs.length - start);
        return result;
    }

    public static boolean allSymbols(char[] cs) {
        for (int i = 0; i < cs.length; ++i) {
            if (!Character.isLetter(cs[i]) && !Character.isDigit(cs[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsDigits(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLetter(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isLetter(chars[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean capitalized(char[] chars) {
        if (chars.length == 0) {
            return false;
        }
        if (!Character.isUpperCase(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isLowerCase(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static String titleCase(String word) {
        if (word.length() < 1) {
            return word;
        }
        if (!Character.isLetter(word.charAt(0))) {
            return word;
        }
        return Character.toUpperCase(word.charAt(0)) + word.substring(1);
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Strings.byteToHex(bytes[i]));
        }
        return sb.toString();
    }

    public static String byteToHex(byte b) {
        String result = Integer.toHexString(Math.byteAsUnsigned(b));
        switch (result.length()) {
            case 0: {
                return "00";
            }
            case 1: {
                return "0" + result;
            }
            case 2: {
                return result;
            }
        }
        String msg = "byteToHex(" + b + ")=" + result;
        throw new IllegalArgumentException(msg);
    }

    public static void writeArrayTo(DataOutput dataOut, String[] strings) throws IOException {
        int len = strings.length;
        dataOut.writeInt(len);
        for (int i = 0; i < len; ++i) {
            dataOut.writeUTF(strings[i]);
        }
    }

    public static String[] readArrayFrom(DataInput dataIn) throws IOException {
        int len = dataIn.readInt();
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            result[i] = dataIn.readUTF();
        }
        return result;
    }

    public static String decimalFormat(double x, String pattern, int length) {
        if (length < 0) {
            String msg = "Length must be positive. Found length=" + length;
            throw new IllegalArgumentException(msg);
        }
        DecimalFormat formatter = new DecimalFormat(pattern);
        try {
            String result = formatter.format(x);
            if (result.length() > length) {
                throw new IllegalArgumentException(EMPTY_STRING);
            }
            if (result.length() == length) {
                return result;
            }
            StringBuffer sb = new StringBuffer(length);
            int i = length - result.length();
            while (--i >= 0) {
                sb.append(' ');
            }
            sb.append(result);
            return sb.toString();
        }
        catch (IllegalArgumentException e) {
            char[] cs = new char[length];
            Arrays.fill(cs, '?');
            return new String(cs);
        }
    }

    public static void checkArgsStartEnd(char[] cs, int start, int end) {
        if (end < start) {
            String msg = "End must be >= start. Found start=" + start + " end=" + end;
            throw new IndexOutOfBoundsException(msg);
        }
        if (start >= 0 && end <= cs.length) {
            return;
        }
        if (start < 0 || start >= cs.length) {
            String msg = "Start must be greater than 0 and less than length of array. Found start=" + start + " Array length=" + cs.length;
            throw new IndexOutOfBoundsException(msg);
        }
        if (end < 0 || end > cs.length) {
            String msg = "End must be between 0 and  the length of the array. Found end=" + end + " Array length=" + cs.length;
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public static char[] toCharArray(CharSequence cSeq) {
        char[] cs = new char[cSeq.length()];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = cSeq.charAt(i);
        }
        return cs;
    }

    public static String msToString(long ms) {
        String secsString;
        String minsString;
        long totalSecs = ms / 1000L;
        long hours = totalSecs / 3600L;
        long mins = totalSecs / 60L % 60L;
        long secs = totalSecs % 60L;
        String string = mins == 0L ? "00" : (minsString = mins < 10L ? "0" + mins : EMPTY_STRING + mins);
        String string2 = secs == 0L ? "00" : (secsString = secs < 10L ? "0" + secs : EMPTY_STRING + secs);
        if (hours > 0L) {
            return hours + ":" + minsString + ":" + secsString;
        }
        if (mins > 0L) {
            return mins + ":" + secsString;
        }
        return ":" + secsString;
    }

    public static boolean equalCharSequence(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        int len = cs1.length();
        if (len != cs2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(CharSequence cSeq) {
        if (cSeq instanceof String) {
            return cSeq.hashCode();
        }
        int h = 0;
        for (int i = 0; i < cSeq.length(); ++i) {
            h = 31 * h + cSeq.charAt(i);
        }
        return h;
    }

    public static char deAccentLatin1(char c) {
        switch (c) {
            case '\u00c0': {
                return 'A';
            }
            case '\u00c1': {
                return 'A';
            }
            case '\u00c2': {
                return 'A';
            }
            case '\u00c3': {
                return 'A';
            }
            case '\u00c4': {
                return 'A';
            }
            case '\u00c5': {
                return 'A';
            }
            case '\u00c6': {
                return 'A';
            }
            case '\u00c7': {
                return 'C';
            }
            case '\u00c8': {
                return 'E';
            }
            case '\u00c9': {
                return 'E';
            }
            case '\u00ca': {
                return 'E';
            }
            case '\u00cb': {
                return 'E';
            }
            case '\u00cc': {
                return 'I';
            }
            case '\u00cd': {
                return 'I';
            }
            case '\u00ce': {
                return 'I';
            }
            case '\u00cf': {
                return 'I';
            }
            case '\u00d0': {
                return 'D';
            }
            case '\u00d1': {
                return 'N';
            }
            case '\u00d2': {
                return 'O';
            }
            case '\u00d3': {
                return 'O';
            }
            case '\u00d4': {
                return 'O';
            }
            case '\u00d5': {
                return 'O';
            }
            case '\u00d6': {
                return 'O';
            }
            case '\u00d8': {
                return 'O';
            }
            case '\u00d9': {
                return 'U';
            }
            case '\u00da': {
                return 'U';
            }
            case '\u00db': {
                return 'U';
            }
            case '\u00dc': {
                return 'U';
            }
            case '\u00dd': {
                return 'Y';
            }
            case '\u00de': {
                return 'P';
            }
            case '\u00df': {
                return 's';
            }
            case '\u00e0': {
                return 'a';
            }
            case '\u00e1': {
                return 'a';
            }
            case '\u00e2': {
                return 'a';
            }
            case '\u00e3': {
                return 'a';
            }
            case '\u00e4': {
                return 'a';
            }
            case '\u00e5': {
                return 'a';
            }
            case '\u00e6': {
                return 'a';
            }
            case '\u00e7': {
                return 'c';
            }
            case '\u00e8': {
                return 'e';
            }
            case '\u00e9': {
                return 'e';
            }
            case '\u00ea': {
                return 'e';
            }
            case '\u00eb': {
                return 'e';
            }
            case '\u00ec': {
                return 'i';
            }
            case '\u00ed': {
                return 'i';
            }
            case '\u00ee': {
                return 'i';
            }
            case '\u00ef': {
                return 'i';
            }
            case '\u00f0': {
                return 'd';
            }
            case '\u00f1': {
                return 'n';
            }
            case '\u00f2': {
                return 'o';
            }
            case '\u00f3': {
                return 'o';
            }
            case '\u00f4': {
                return 'o';
            }
            case '\u00f5': {
                return 'o';
            }
            case '\u00f6': {
                return 'o';
            }
            case '\u00f8': {
                return 'o';
            }
            case '\u00f9': {
                return 'u';
            }
            case '\u00fa': {
                return 'u';
            }
            case '\u00fb': {
                return 'u';
            }
            case '\u00fc': {
                return 'u';
            }
            case '\u00fd': {
                return 'y';
            }
            case '\u00fe': {
                return 'p';
            }
            case '\u00ff': {
                return 'y';
            }
        }
        return c;
    }

    public static String deAccentLatin1(CharSequence cSeq) {
        char[] cs = new char[cSeq.length()];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = Strings.deAccentLatin1(cSeq.charAt(i));
        }
        return new String(cs);
    }
}

