/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.xml.sax.InputSource;

public class Streams {
    private static final int BYTE_COPY_BUFFER_SIZE = 8192;
    private static final int CHAR_COPY_BUFFER_SIZE = 4096;

    private Streams() {
    }

    public static String getDefaultJavaCharset() {
        byte[] bytes = new byte[]{};
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        InputStreamReader defaultReader = new InputStreamReader(bytesIn);
        return defaultReader.getEncoding();
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        Streams.copy(reader, writer);
        return writer.toCharArray();
    }

    public static char[] toCharArray(InputStream in, String charset) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        InputStreamReader reader = new InputStreamReader(in, charset);
        Streams.copy(reader, writer);
        return writer.toCharArray();
    }

    public static char[] toCharArray(InputSource in) throws IOException {
        Reader reader = null;
        InputStream inStr = null;
        reader = in.getCharacterStream();
        if (reader == null) {
            String charset;
            inStr = in.getByteStream();
            if (inStr == null) {
                inStr = new URL(in.getSystemId()).openStream();
            }
            reader = (charset = in.getEncoding()) == null ? new InputStreamReader(inStr) : new InputStreamReader(inStr, charset);
        }
        return Streams.toCharArray(reader);
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int numChars;
        char[] buffer = new char[4096];
        while ((numChars = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, numChars);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int numBytes;
        byte[] buffer = new byte[8192];
        while ((numBytes = in.read(buffer)) > 0) {
            out.write(buffer, 0, numBytes);
        }
    }

    public static void closeInputStream(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeOutputStream(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeReader(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeWriter(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

