/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Collections;
import com.aliasi.util.Iterators;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SmallSet<E>
extends AbstractSet<E> {
    public abstract SmallSet<E> union(SmallSet<? extends E> var1);

    public static <F> SmallSet<F> create() {
        return new SmallEmptySet();
    }

    public static <F> SmallSet<F> create(F member) {
        return new SingletonSet<F>(member);
    }

    public static <F> SmallSet<F> create(F member1, F member2) {
        if (member1.equals(member2)) {
            return SmallSet.create(member1);
        }
        return new PairSet<F>(member1, member2);
    }

    public static <F> SmallSet<F> create(F[] members) {
        switch (members.length) {
            case 0: {
                return SmallSet.create();
            }
            case 1: {
                return SmallSet.create(members[0]);
            }
            case 2: {
                return SmallSet.create(members[0], members[1]);
            }
        }
        HashSet set = new HashSet();
        Collections.addAll(set, members);
        return SmallSet.create(set);
    }

    public static <F> SmallSet<F> create(Set<? extends F> members) {
        switch (members.size()) {
            case 0: {
                return SmallSet.create();
            }
            case 1: {
                return SmallSet.create(members.iterator().next());
            }
            case 2: {
                Iterator<F> it = members.iterator();
                F obj1 = it.next();
                F obj2 = it.next();
                return SmallSet.create(obj1, obj2);
            }
        }
        return new ListSet<F>(members);
    }

    public static <F> SmallSet<F> create(F member, Set<? extends F> set) {
        switch (set.size()) {
            case 0: {
                return SmallSet.create(member);
            }
            case 1: {
                return SmallSet.create(member, set.iterator().next());
            }
        }
        return set.contains(member) ? SmallSet.create(set) : new ListSet<F>(member, set);
    }

    public static <F> SmallSet<F> create(Set<? extends F> set1, Set<? extends F> set2) {
        HashSet<F> union = new HashSet<F>(set1.size() + set2.size());
        union.addAll(set1);
        union.addAll(set2);
        return SmallSet.create(union);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListSet<F>
    extends SmallSet<F> {
        private final F[] mMembers;

        ListSet(Set<? extends F> set) {
            this.mMembers = new Object[set.size()];
            set.toArray(this.mMembers);
        }

        ListSet(F x, Set<? extends F> set) {
            this.mMembers = new Object[set.size() + 1];
            set.toArray(this.mMembers);
            this.mMembers[this.mMembers.length - 1] = x;
        }

        @Override
        public SmallSet<F> union(SmallSet<? extends F> that) {
            switch (that.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    Object next = that.iterator().next();
                    return this.contains(next) ? this : new ListSet(next, this);
                }
            }
            HashSet<F> union = new HashSet<F>(this.size() + that.size());
            for (F member : this.mMembers) {
                union.add(member);
            }
            union.addAll(that);
            return new ListSet(union);
        }

        @Override
        public Iterator<F> iterator() {
            return new Iterators.Array<F>(this.mMembers);
        }

        @Override
        public int size() {
            return this.mMembers.length;
        }

        @Override
        public boolean contains(Object obj) {
            for (int i = 0; i < this.mMembers.length; ++i) {
                if (!obj.equals(this.mMembers[i])) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairSet<F>
    extends SmallSet<F> {
        private final F mMember1;
        private final F mMember2;

        public PairSet(F member1, F member2) {
            this.mMember1 = member1;
            this.mMember2 = member2;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean contains(Object obj) {
            return obj.equals(this.mMember1) || obj.equals(this.mMember2);
        }

        @Override
        public Iterator<F> iterator() {
            return new Iterators.Pair<F>(this.mMember1, this.mMember2);
        }

        @Override
        public SmallSet<F> union(SmallSet<? extends F> that) {
            switch (that.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    Object member = that.iterator().next();
                    if (!this.contains(member)) break;
                    return this;
                }
            }
            return SmallSet.create(this, that);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonSet<F>
    extends SmallSet<F> {
        private final F mMember;

        public SingletonSet(F member) {
            this.mMember = member;
        }

        @Override
        public Iterator<F> iterator() {
            return new Iterators.Singleton<F>(this.mMember);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object obj) {
            return this.mMember.equals(obj);
        }

        @Override
        public SmallSet<F> union(SmallSet<? extends F> that) {
            switch (that.size()) {
                case 0: {
                    return this;
                }
                case 1: {
                    return SmallSet.create(this.mMember, that.iterator().next());
                }
                case 2: {
                    return SmallSet.create(this.mMember, that);
                }
            }
            return SmallSet.create(this, that);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SmallEmptySet<F>
    extends SmallSet<F> {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<F> iterator() {
            return new Iterators.Empty();
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public SmallSet<F> union(SmallSet<? extends F> that) {
            return that;
        }
    }
}

