/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.util.HashMap;
import java.util.Map;

public class Sgml {
    static final Map<String, Character> SGML_MAP = new HashMap<String, Character>(1500);

    public static Character entityToCharacter(String entity) {
        return SGML_MAP.get(entity);
    }

    public static String replaceEntities(String in, String unknownReplacement) {
        int ampIndex = in.indexOf(38);
        if (ampIndex < 0) {
            return in;
        }
        int semicolonIndex = in.indexOf(59, ampIndex + 1);
        if (semicolonIndex < 0) {
            return in;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        do {
            sb.append(in.substring(start, ampIndex));
            String entity = in.substring(ampIndex + 1, semicolonIndex);
            Character replacement = SGML_MAP.get(entity);
            sb.append(replacement != null ? replacement : unknownReplacement);
            start = semicolonIndex + 1;
            ampIndex = in.indexOf(38, start);
            if (ampIndex >= 0) continue;
            return sb + in.substring(start);
        } while ((semicolonIndex = in.indexOf(59, ampIndex + 1)) >= 0);
        return sb + in.substring(start);
    }

    public static String replaceEntities(String in) {
        return Sgml.replaceEntities(in, "?");
    }

    static {
        SGML_MAP.put("Aacgr", Character.valueOf('\u0386'));
        SGML_MAP.put("aacgr", Character.valueOf('\u03ac'));
        SGML_MAP.put("Aacute", Character.valueOf('\u00c1'));
        SGML_MAP.put("aacute", Character.valueOf('\u00e1'));
        SGML_MAP.put("Abreve", Character.valueOf('\u0102'));
        SGML_MAP.put("abreve", Character.valueOf('\u0103'));
        SGML_MAP.put("Acirc", Character.valueOf('\u00c2'));
        SGML_MAP.put("acirc", Character.valueOf('\u00e2'));
        SGML_MAP.put("acute", Character.valueOf('\u00b4'));
        SGML_MAP.put("Acy", Character.valueOf('\u0410'));
        SGML_MAP.put("acy", Character.valueOf('\u0430'));
        SGML_MAP.put("AElig", Character.valueOf('\u00c6'));
        SGML_MAP.put("aelig", Character.valueOf('\u00e6'));
        SGML_MAP.put("Agr", Character.valueOf('\u0391'));
        SGML_MAP.put("agr", Character.valueOf('\u03b1'));
        SGML_MAP.put("Agrave", Character.valueOf('\u00c0'));
        SGML_MAP.put("agrave", Character.valueOf('\u00e0'));
        SGML_MAP.put("alefsym", Character.valueOf('\u2135'));
        SGML_MAP.put("aleph", Character.valueOf('\u2135'));
        SGML_MAP.put("Alpha", Character.valueOf('\u0391'));
        SGML_MAP.put("alpha", Character.valueOf('\u03b1'));
        SGML_MAP.put("Amacr", Character.valueOf('\u0100'));
        SGML_MAP.put("amacr", Character.valueOf('\u0101'));
        SGML_MAP.put("amalg", Character.valueOf('\u2210'));
        SGML_MAP.put("amp", Character.valueOf('&'));
        SGML_MAP.put("and", Character.valueOf('\u2227'));
        SGML_MAP.put("ang", Character.valueOf('\u2220'));
        SGML_MAP.put("ang90", Character.valueOf('\u221f'));
        SGML_MAP.put("angmsd", Character.valueOf('\u2221'));
        SGML_MAP.put("angsph", Character.valueOf('\u2222'));
        SGML_MAP.put("angst", Character.valueOf('\u212b'));
        SGML_MAP.put("Aogon", Character.valueOf('\u0104'));
        SGML_MAP.put("aogon", Character.valueOf('\u0105'));
        SGML_MAP.put("ap", Character.valueOf('\u2248'));
        SGML_MAP.put("ape", Character.valueOf('\u224a'));
        SGML_MAP.put("apos", Character.valueOf('\u02bc'));
        SGML_MAP.put("Aring", Character.valueOf('\u00c5'));
        SGML_MAP.put("aring", Character.valueOf('\u00e5'));
        SGML_MAP.put("ast", Character.valueOf('*'));
        SGML_MAP.put("asymp", Character.valueOf('\u2248'));
        SGML_MAP.put("Atilde", Character.valueOf('\u00c3'));
        SGML_MAP.put("atilde", Character.valueOf('\u00e3'));
        SGML_MAP.put("Auml", Character.valueOf('\u00c4'));
        SGML_MAP.put("auml", Character.valueOf('\u00e4'));
        SGML_MAP.put("b.alpha", Character.valueOf('\u03b1'));
        SGML_MAP.put("barwed", Character.valueOf('\u22bc'));
        SGML_MAP.put("Barwed", Character.valueOf('\u2306'));
        SGML_MAP.put("b.beta", Character.valueOf('\u03b2'));
        SGML_MAP.put("b.chi", Character.valueOf('\u03c7'));
        SGML_MAP.put("bcong", Character.valueOf('\u224c'));
        SGML_MAP.put("Bcy", Character.valueOf('\u0411'));
        SGML_MAP.put("bcy", Character.valueOf('\u0431'));
        SGML_MAP.put("b.Delta", Character.valueOf('\u0394'));
        SGML_MAP.put("b.delta", Character.valueOf('\u03b4'));
        SGML_MAP.put("bdquo", Character.valueOf('\u201e'));
        SGML_MAP.put("becaus", Character.valueOf('\u2235'));
        SGML_MAP.put("bepsi", Character.valueOf('\u220d'));
        SGML_MAP.put("b.epsi", Character.valueOf('\u03b5'));
        SGML_MAP.put("b.epsis", Character.valueOf('\u03b5'));
        SGML_MAP.put("b.epsiv", Character.valueOf('\u03b5'));
        SGML_MAP.put("bernou", Character.valueOf('\u212c'));
        SGML_MAP.put("Beta", Character.valueOf('\u0392'));
        SGML_MAP.put("beta", Character.valueOf('\u03b2'));
        SGML_MAP.put("b.eta", Character.valueOf('\u03b7'));
        SGML_MAP.put("beth", Character.valueOf('\u2136'));
        SGML_MAP.put("b.Gamma", Character.valueOf('\u0393'));
        SGML_MAP.put("b.gamma", Character.valueOf('\u03b3'));
        SGML_MAP.put("b.gammad", Character.valueOf('\u03dc'));
        SGML_MAP.put("Bgr", Character.valueOf('\u0392'));
        SGML_MAP.put("bgr", Character.valueOf('\u03b2'));
        SGML_MAP.put("b.iota", Character.valueOf('\u03b9'));
        SGML_MAP.put("b.kappa", Character.valueOf('\u03ba'));
        SGML_MAP.put("b.kappav", Character.valueOf('\u03f0'));
        SGML_MAP.put("b.Lambda", Character.valueOf('\u039b'));
        SGML_MAP.put("b.lambda", Character.valueOf('\u03bb'));
        SGML_MAP.put("blank", Character.valueOf('\u2423'));
        SGML_MAP.put("blk12", Character.valueOf('\u2592'));
        SGML_MAP.put("blk14", Character.valueOf('\u2591'));
        SGML_MAP.put("blk34", Character.valueOf('\u2593'));
        SGML_MAP.put("block", Character.valueOf('\u2588'));
        SGML_MAP.put("b.mu", Character.valueOf('\u03bc'));
        SGML_MAP.put("b.nu", Character.valueOf('\u03bd'));
        SGML_MAP.put("b.Omega", Character.valueOf('\u03a9'));
        SGML_MAP.put("b.omega", Character.valueOf('\u03ce'));
        SGML_MAP.put("bottom", Character.valueOf('\u22a5'));
        SGML_MAP.put("bowtie", Character.valueOf('\u22c8'));
        SGML_MAP.put("boxdl", Character.valueOf('\u2510'));
        SGML_MAP.put("boxdL", Character.valueOf('\u2555'));
        SGML_MAP.put("boxDl", Character.valueOf('\u2556'));
        SGML_MAP.put("boxDL", Character.valueOf('\u2557'));
        SGML_MAP.put("boxdr", Character.valueOf('\u250c'));
        SGML_MAP.put("boxdR", Character.valueOf('\u2552'));
        SGML_MAP.put("boxDr", Character.valueOf('\u2553'));
        SGML_MAP.put("boxDR", Character.valueOf('\u2554'));
        SGML_MAP.put("boxh", Character.valueOf('\u2500'));
        SGML_MAP.put("boxH", Character.valueOf('\u2550'));
        SGML_MAP.put("boxhd", Character.valueOf('\u252c'));
        SGML_MAP.put("boxHd", Character.valueOf('\u2564'));
        SGML_MAP.put("boxhD", Character.valueOf('\u2565'));
        SGML_MAP.put("boxHD", Character.valueOf('\u2566'));
        SGML_MAP.put("boxhu", Character.valueOf('\u2534'));
        SGML_MAP.put("boxHu", Character.valueOf('\u2567'));
        SGML_MAP.put("boxhU", Character.valueOf('\u2568'));
        SGML_MAP.put("boxHU", Character.valueOf('\u2569'));
        SGML_MAP.put("boxul", Character.valueOf('\u2518'));
        SGML_MAP.put("boxuL", Character.valueOf('\u255b'));
        SGML_MAP.put("boxUl", Character.valueOf('\u255c'));
        SGML_MAP.put("boxUL", Character.valueOf('\u255d'));
        SGML_MAP.put("boxur", Character.valueOf('\u2514'));
        SGML_MAP.put("boxuR", Character.valueOf('\u2558'));
        SGML_MAP.put("boxUr", Character.valueOf('\u2559'));
        SGML_MAP.put("boxUR", Character.valueOf('\u255a'));
        SGML_MAP.put("boxv", Character.valueOf('\u2502'));
        SGML_MAP.put("boxV", Character.valueOf('\u2551'));
        SGML_MAP.put("boxvh", Character.valueOf('\u253c'));
        SGML_MAP.put("boxvH", Character.valueOf('\u256a'));
        SGML_MAP.put("boxVh", Character.valueOf('\u256b'));
        SGML_MAP.put("boxVH", Character.valueOf('\u256c'));
        SGML_MAP.put("boxvl", Character.valueOf('\u2524'));
        SGML_MAP.put("boxvL", Character.valueOf('\u2561'));
        SGML_MAP.put("boxVl", Character.valueOf('\u2562'));
        SGML_MAP.put("boxVL", Character.valueOf('\u2563'));
        SGML_MAP.put("boxvr", Character.valueOf('\u251c'));
        SGML_MAP.put("boxvR", Character.valueOf('\u255e'));
        SGML_MAP.put("boxVr", Character.valueOf('\u255f'));
        SGML_MAP.put("boxVR", Character.valueOf('\u2560'));
        SGML_MAP.put("b.Phi", Character.valueOf('\u03a6'));
        SGML_MAP.put("b.phis", Character.valueOf('\u03c6'));
        SGML_MAP.put("b.phiv", Character.valueOf('\u03d5'));
        SGML_MAP.put("b.Pi", Character.valueOf('\u03a0'));
        SGML_MAP.put("b.pi", Character.valueOf('\u03c0'));
        SGML_MAP.put("b.piv", Character.valueOf('\u03d6'));
        SGML_MAP.put("bprime", Character.valueOf('\u2035'));
        SGML_MAP.put("b.Psi", Character.valueOf('\u03a8'));
        SGML_MAP.put("b.psi", Character.valueOf('\u03c8'));
        SGML_MAP.put("breve", Character.valueOf('\u02d8'));
        SGML_MAP.put("b.rho", Character.valueOf('\u03c1'));
        SGML_MAP.put("b.rhov", Character.valueOf('\u03f1'));
        SGML_MAP.put("brvbar", Character.valueOf('\u00a6'));
        SGML_MAP.put("b.Sigma", Character.valueOf('\u03a3'));
        SGML_MAP.put("b.sigma", Character.valueOf('\u03c3'));
        SGML_MAP.put("b.sigmav", Character.valueOf('\u03c2'));
        SGML_MAP.put("bsim", Character.valueOf('\u223d'));
        SGML_MAP.put("bsime", Character.valueOf('\u22cd'));
        SGML_MAP.put("b.tau", Character.valueOf('\u03c4'));
        SGML_MAP.put("b.Theta", Character.valueOf('\u0398'));
        SGML_MAP.put("b.thetas", Character.valueOf('\u03b8'));
        SGML_MAP.put("b.thetav", Character.valueOf('\u03d1'));
        SGML_MAP.put("bull", Character.valueOf('\u2022'));
        SGML_MAP.put("bump", Character.valueOf('\u224e'));
        SGML_MAP.put("bumpe", Character.valueOf('\u224f'));
        SGML_MAP.put("b.Upsi", Character.valueOf('\u03a5'));
        SGML_MAP.put("b.upsi", Character.valueOf('\u03c5'));
        SGML_MAP.put("b.Xi", Character.valueOf('\u039e'));
        SGML_MAP.put("b.xi", Character.valueOf('\u03be'));
        SGML_MAP.put("b.zeta", Character.valueOf('\u03b6'));
        SGML_MAP.put("Cacute", Character.valueOf('\u0106'));
        SGML_MAP.put("cacute", Character.valueOf('\u0107'));
        SGML_MAP.put("Cap", Character.valueOf('\u22d2'));
        SGML_MAP.put("cap", Character.valueOf('\u2229'));
        SGML_MAP.put("caret", Character.valueOf('\u2041'));
        SGML_MAP.put("caron", Character.valueOf('\u02c7'));
        SGML_MAP.put("Ccaron", Character.valueOf('\u010c'));
        SGML_MAP.put("ccaron", Character.valueOf('\u010d'));
        SGML_MAP.put("Ccedil", Character.valueOf('\u00c7'));
        SGML_MAP.put("ccedil", Character.valueOf('\u00e7'));
        SGML_MAP.put("Ccirc", Character.valueOf('\u0108'));
        SGML_MAP.put("ccirc", Character.valueOf('\u0109'));
        SGML_MAP.put("Cdot", Character.valueOf('\u010a'));
        SGML_MAP.put("cdot", Character.valueOf('\u010b'));
        SGML_MAP.put("cedil", Character.valueOf('\u00b8'));
        SGML_MAP.put("cent", Character.valueOf('\u00a2'));
        SGML_MAP.put("CHcy", Character.valueOf('\u0427'));
        SGML_MAP.put("chcy", Character.valueOf('\u0447'));
        SGML_MAP.put("check", Character.valueOf('\u2713'));
        SGML_MAP.put("Chi", Character.valueOf('\u03a7'));
        SGML_MAP.put("chi", Character.valueOf('\u03c7'));
        SGML_MAP.put("cir", Character.valueOf('\u25cb'));
        SGML_MAP.put("circ", Character.valueOf('\u02c6'));
        SGML_MAP.put("cire", Character.valueOf('\u2257'));
        SGML_MAP.put("clubs", Character.valueOf('\u2663'));
        SGML_MAP.put("colon", Character.valueOf(':'));
        SGML_MAP.put("colone", Character.valueOf('\u2254'));
        SGML_MAP.put("comma", Character.valueOf(','));
        SGML_MAP.put("commat", Character.valueOf('@'));
        SGML_MAP.put("comp", Character.valueOf('\u2201'));
        SGML_MAP.put("compfn", Character.valueOf('\u2218'));
        SGML_MAP.put("cong", Character.valueOf('\u2245'));
        SGML_MAP.put("conint", Character.valueOf('\u222e'));
        SGML_MAP.put("coprod", Character.valueOf('\u2210'));
        SGML_MAP.put("copy", Character.valueOf('\u00a9'));
        SGML_MAP.put("copysr", Character.valueOf('\u2117'));
        SGML_MAP.put("crarr", Character.valueOf('\u21b5'));
        SGML_MAP.put("cross", Character.valueOf('\u2717'));
        SGML_MAP.put("cuepr", Character.valueOf('\u22de'));
        SGML_MAP.put("cuesc", Character.valueOf('\u22df'));
        SGML_MAP.put("cularr", Character.valueOf('\u21b6'));
        SGML_MAP.put("Cup", Character.valueOf('\u22d3'));
        SGML_MAP.put("cup", Character.valueOf('\u222a'));
        SGML_MAP.put("cupre", Character.valueOf('\u227c'));
        SGML_MAP.put("curarr", Character.valueOf('\u21b7'));
        SGML_MAP.put("curren", Character.valueOf('\u00a4'));
        SGML_MAP.put("cuvee", Character.valueOf('\u22ce'));
        SGML_MAP.put("cuwed", Character.valueOf('\u22cf'));
        SGML_MAP.put("dagger", Character.valueOf('\u2020'));
        SGML_MAP.put("Dagger", Character.valueOf('\u2021'));
        SGML_MAP.put("daleth", Character.valueOf('\u2138'));
        SGML_MAP.put("dArr", Character.valueOf('\u21d3'));
        SGML_MAP.put("darr", Character.valueOf('\u2193'));
        SGML_MAP.put("darr2", Character.valueOf('\u21ca'));
        SGML_MAP.put("dash", Character.valueOf('\u2010'));
        SGML_MAP.put("dashv", Character.valueOf('\u22a3'));
        SGML_MAP.put("dblac", Character.valueOf('\u02dd'));
        SGML_MAP.put("Dcaron", Character.valueOf('\u010e'));
        SGML_MAP.put("dcaron", Character.valueOf('\u010f'));
        SGML_MAP.put("Dcy", Character.valueOf('\u0414'));
        SGML_MAP.put("dcy", Character.valueOf('\u0434'));
        SGML_MAP.put("deg", Character.valueOf('\u00b0'));
        SGML_MAP.put("Delta", Character.valueOf('\u0394'));
        SGML_MAP.put("delta", Character.valueOf('\u03b4'));
        SGML_MAP.put("Dgr", Character.valueOf('\u0394'));
        SGML_MAP.put("dgr", Character.valueOf('\u03b4'));
        SGML_MAP.put("dharl", Character.valueOf('\u21c3'));
        SGML_MAP.put("dharr", Character.valueOf('\u21c2'));
        SGML_MAP.put("diam", Character.valueOf('\u22c4'));
        SGML_MAP.put("diams", Character.valueOf('\u2666'));
        SGML_MAP.put("die", Character.valueOf('\u00a8'));
        SGML_MAP.put("divide", Character.valueOf('\u00f7'));
        SGML_MAP.put("divonx", Character.valueOf('\u22c7'));
        SGML_MAP.put("DJcy", Character.valueOf('\u0402'));
        SGML_MAP.put("djcy", Character.valueOf('\u0452'));
        SGML_MAP.put("dlarr", Character.valueOf('\u2199'));
        SGML_MAP.put("dlcorn", Character.valueOf('\u231e'));
        SGML_MAP.put("dlcrop", Character.valueOf('\u230d'));
        SGML_MAP.put("dollar", Character.valueOf('$'));
        SGML_MAP.put("dot", Character.valueOf('\u02d9'));
        SGML_MAP.put("Dot", Character.valueOf('\u00a8'));
        SGML_MAP.put("DotDot", Character.valueOf('\u20dc'));
        SGML_MAP.put("drarr", Character.valueOf('\u2198'));
        SGML_MAP.put("drcorn", Character.valueOf('\u231f'));
        SGML_MAP.put("drcrop", Character.valueOf('\u230c'));
        SGML_MAP.put("DScy", Character.valueOf('\u0405'));
        SGML_MAP.put("dscy", Character.valueOf('\u0455'));
        SGML_MAP.put("Dstrok", Character.valueOf('\u0110'));
        SGML_MAP.put("dstrok", Character.valueOf('\u0111'));
        SGML_MAP.put("dtri", Character.valueOf('\u25bf'));
        SGML_MAP.put("dtrif", Character.valueOf('\u25be'));
        SGML_MAP.put("DZcy", Character.valueOf('\u040f'));
        SGML_MAP.put("dzcy", Character.valueOf('\u045f'));
        SGML_MAP.put("Eacgr", Character.valueOf('\u0388'));
        SGML_MAP.put("eacgr", Character.valueOf('\u03ad'));
        SGML_MAP.put("Eacute", Character.valueOf('\u00c9'));
        SGML_MAP.put("eacute", Character.valueOf('\u00e9'));
        SGML_MAP.put("Ecaron", Character.valueOf('\u011a'));
        SGML_MAP.put("ecaron", Character.valueOf('\u011b'));
        SGML_MAP.put("ecir", Character.valueOf('\u2256'));
        SGML_MAP.put("Ecirc", Character.valueOf('\u00ca'));
        SGML_MAP.put("ecirc", Character.valueOf('\u00ea'));
        SGML_MAP.put("ecolon", Character.valueOf('\u2255'));
        SGML_MAP.put("Ecy", Character.valueOf('\u042d'));
        SGML_MAP.put("ecy", Character.valueOf('\u044d'));
        SGML_MAP.put("eDot", Character.valueOf('\u2251'));
        SGML_MAP.put("Edot", Character.valueOf('\u0116'));
        SGML_MAP.put("edot", Character.valueOf('\u0117'));
        SGML_MAP.put("EEacgr", Character.valueOf('\u0389'));
        SGML_MAP.put("eeacgr", Character.valueOf('\u03ae'));
        SGML_MAP.put("EEgr", Character.valueOf('\u0397'));
        SGML_MAP.put("eegr", Character.valueOf('\u03b7'));
        SGML_MAP.put("efDot", Character.valueOf('\u2252'));
        SGML_MAP.put("Egr", Character.valueOf('\u0395'));
        SGML_MAP.put("egr", Character.valueOf('\u03b5'));
        SGML_MAP.put("Egrave", Character.valueOf('\u00c8'));
        SGML_MAP.put("egrave", Character.valueOf('\u00e8'));
        SGML_MAP.put("egs", Character.valueOf('\u22dd'));
        SGML_MAP.put("ell", Character.valueOf('\u2113'));
        SGML_MAP.put("els", Character.valueOf('\u22dc'));
        SGML_MAP.put("Emacr", Character.valueOf('\u0112'));
        SGML_MAP.put("emacr", Character.valueOf('\u0113'));
        SGML_MAP.put("empty", Character.valueOf('\u2205'));
        SGML_MAP.put("emsp", Character.valueOf('\u2003'));
        SGML_MAP.put("emsp13", Character.valueOf('\u2004'));
        SGML_MAP.put("emsp14", Character.valueOf('\u2005'));
        SGML_MAP.put("ENG", Character.valueOf('\u014a'));
        SGML_MAP.put("eng", Character.valueOf('\u014b'));
        SGML_MAP.put("ensp", Character.valueOf('\u2002'));
        SGML_MAP.put("Eogon", Character.valueOf('\u0118'));
        SGML_MAP.put("eogon", Character.valueOf('\u0119'));
        SGML_MAP.put("epsi", Character.valueOf('\u03b5'));
        SGML_MAP.put("Epsilon", Character.valueOf('\u0395'));
        SGML_MAP.put("epsilon", Character.valueOf('\u03b5'));
        SGML_MAP.put("epsis", Character.valueOf('\u220a'));
        SGML_MAP.put("equals", Character.valueOf('='));
        SGML_MAP.put("equiv", Character.valueOf('\u2261'));
        SGML_MAP.put("erDot", Character.valueOf('\u2253'));
        SGML_MAP.put("esdot", Character.valueOf('\u2250'));
        SGML_MAP.put("Eta", Character.valueOf('\u0397'));
        SGML_MAP.put("eta", Character.valueOf('\u03b7'));
        SGML_MAP.put("ETH", Character.valueOf('\u00d0'));
        SGML_MAP.put("eth", Character.valueOf('\u00f0'));
        SGML_MAP.put("Euml", Character.valueOf('\u00cb'));
        SGML_MAP.put("euml", Character.valueOf('\u00eb'));
        SGML_MAP.put("excl", Character.valueOf('!'));
        SGML_MAP.put("exist", Character.valueOf('\u2203'));
        SGML_MAP.put("Fcy", Character.valueOf('\u0424'));
        SGML_MAP.put("fcy", Character.valueOf('\u0444'));
        SGML_MAP.put("female", Character.valueOf('\u2640'));
        SGML_MAP.put("ffilig", Character.valueOf('\ufb03'));
        SGML_MAP.put("fflig", Character.valueOf('\ufb00'));
        SGML_MAP.put("ffllig", Character.valueOf('\ufb04'));
        SGML_MAP.put("filig", Character.valueOf('\ufb01'));
        SGML_MAP.put("flat", Character.valueOf('\u266d'));
        SGML_MAP.put("fllig", Character.valueOf('\ufb02'));
        SGML_MAP.put("fnof", Character.valueOf('\u0192'));
        SGML_MAP.put("forall", Character.valueOf('\u2200'));
        SGML_MAP.put("fork", Character.valueOf('\u22d4'));
        SGML_MAP.put("frac12", Character.valueOf('\u00bd'));
        SGML_MAP.put("frac13", Character.valueOf('\u2153'));
        SGML_MAP.put("frac14", Character.valueOf('\u00bc'));
        SGML_MAP.put("frac15", Character.valueOf('\u2155'));
        SGML_MAP.put("frac16", Character.valueOf('\u2159'));
        SGML_MAP.put("frac18", Character.valueOf('\u215b'));
        SGML_MAP.put("frac23", Character.valueOf('\u2154'));
        SGML_MAP.put("frac25", Character.valueOf('\u2156'));
        SGML_MAP.put("frac34", Character.valueOf('\u00be'));
        SGML_MAP.put("frac35", Character.valueOf('\u2157'));
        SGML_MAP.put("frac38", Character.valueOf('\u215c'));
        SGML_MAP.put("frac45", Character.valueOf('\u2158'));
        SGML_MAP.put("frac56", Character.valueOf('\u215a'));
        SGML_MAP.put("frac58", Character.valueOf('\u215d'));
        SGML_MAP.put("frac78", Character.valueOf('\u215e'));
        SGML_MAP.put("frasl", Character.valueOf('\u2044'));
        SGML_MAP.put("frown", Character.valueOf('\u2322'));
        SGML_MAP.put("gacute", Character.valueOf('\u01f5'));
        SGML_MAP.put("Gamma", Character.valueOf('\u0393'));
        SGML_MAP.put("gamma", Character.valueOf('\u03b3'));
        SGML_MAP.put("gammad", Character.valueOf('\u03dc'));
        SGML_MAP.put("Gbreve", Character.valueOf('\u011e'));
        SGML_MAP.put("gbreve", Character.valueOf('\u011f'));
        SGML_MAP.put("Gcedil", Character.valueOf('\u0122'));
        SGML_MAP.put("gcedil", Character.valueOf('\u0123'));
        SGML_MAP.put("Gcirc", Character.valueOf('\u011c'));
        SGML_MAP.put("gcirc", Character.valueOf('\u011d'));
        SGML_MAP.put("Gcy", Character.valueOf('\u0413'));
        SGML_MAP.put("gcy", Character.valueOf('\u0433'));
        SGML_MAP.put("Gdot", Character.valueOf('\u0120'));
        SGML_MAP.put("gdot", Character.valueOf('\u0121'));
        SGML_MAP.put("gE", Character.valueOf('\u2267'));
        SGML_MAP.put("ge", Character.valueOf('\u2265'));
        SGML_MAP.put("gel", Character.valueOf('\u22db'));
        SGML_MAP.put("ges", Character.valueOf('\u2265'));
        SGML_MAP.put("Gg", Character.valueOf('\u22d9'));
        SGML_MAP.put("Ggr", Character.valueOf('\u0393'));
        SGML_MAP.put("ggr", Character.valueOf('\u03b3'));
        SGML_MAP.put("gimel", Character.valueOf('\u2137'));
        SGML_MAP.put("GJcy", Character.valueOf('\u0403'));
        SGML_MAP.put("gjcy", Character.valueOf('\u0453'));
        SGML_MAP.put("gl", Character.valueOf('\u2277'));
        SGML_MAP.put("gne", Character.valueOf('\u2269'));
        SGML_MAP.put("gnE", Character.valueOf('\u2269'));
        SGML_MAP.put("gnsim", Character.valueOf('\u22e7'));
        SGML_MAP.put("grave", Character.valueOf('`'));
        SGML_MAP.put("gsdot", Character.valueOf('\u22d7'));
        SGML_MAP.put("gsim", Character.valueOf('\u2273'));
        SGML_MAP.put("Gt", Character.valueOf('\u226b'));
        SGML_MAP.put("gt", Character.valueOf('>'));
        SGML_MAP.put("gvnE", Character.valueOf('\u2269'));
        SGML_MAP.put("hairsp", Character.valueOf('\u200a'));
        SGML_MAP.put("half", Character.valueOf('\u00bd'));
        SGML_MAP.put("hamilt", Character.valueOf('\u210b'));
        SGML_MAP.put("HARDcy", Character.valueOf('\u042a'));
        SGML_MAP.put("hardcy", Character.valueOf('\u044a'));
        SGML_MAP.put("harr", Character.valueOf('\u2194'));
        SGML_MAP.put("hArr", Character.valueOf('\u21d4'));
        SGML_MAP.put("harrw", Character.valueOf('\u21ad'));
        SGML_MAP.put("Hcirc", Character.valueOf('\u0124'));
        SGML_MAP.put("hcirc", Character.valueOf('\u0125'));
        SGML_MAP.put("hearts", Character.valueOf('\u2665'));
        SGML_MAP.put("hellip", Character.valueOf('\u2026'));
        SGML_MAP.put("horbar", Character.valueOf('\u2015'));
        SGML_MAP.put("Hstrok", Character.valueOf('\u0126'));
        SGML_MAP.put("hstrok", Character.valueOf('\u0127'));
        SGML_MAP.put("hybull", Character.valueOf('\u2043'));
        SGML_MAP.put("hyphen", Character.valueOf('-'));
        SGML_MAP.put("Iacgr", Character.valueOf('\u038a'));
        SGML_MAP.put("iacgr", Character.valueOf('\u03af'));
        SGML_MAP.put("Iacute", Character.valueOf('\u00cd'));
        SGML_MAP.put("iacute", Character.valueOf('\u00ed'));
        SGML_MAP.put("Icirc", Character.valueOf('\u00ce'));
        SGML_MAP.put("icirc", Character.valueOf('\u00ee'));
        SGML_MAP.put("Icy", Character.valueOf('\u0418'));
        SGML_MAP.put("icy", Character.valueOf('\u0438'));
        SGML_MAP.put("idiagr", Character.valueOf('\u0390'));
        SGML_MAP.put("Idigr", Character.valueOf('\u03aa'));
        SGML_MAP.put("idigr", Character.valueOf('\u03ca'));
        SGML_MAP.put("Idot", Character.valueOf('\u0130'));
        SGML_MAP.put("IEcy", Character.valueOf('\u0415'));
        SGML_MAP.put("iecy", Character.valueOf('\u0435'));
        SGML_MAP.put("iexcl", Character.valueOf('\u00a1'));
        SGML_MAP.put("iff", Character.valueOf('\u21d4'));
        SGML_MAP.put("Igr", Character.valueOf('\u0399'));
        SGML_MAP.put("igr", Character.valueOf('\u03b9'));
        SGML_MAP.put("Igrave", Character.valueOf('\u00cc'));
        SGML_MAP.put("igrave", Character.valueOf('\u00ec'));
        SGML_MAP.put("IJlig", Character.valueOf('\u0132'));
        SGML_MAP.put("ijlig", Character.valueOf('\u0133'));
        SGML_MAP.put("Imacr", Character.valueOf('\u012a'));
        SGML_MAP.put("imacr", Character.valueOf('\u012b'));
        SGML_MAP.put("image", Character.valueOf('\u2111'));
        SGML_MAP.put("incare", Character.valueOf('\u2105'));
        SGML_MAP.put("infin", Character.valueOf('\u221e'));
        SGML_MAP.put("inodot", Character.valueOf('\u0131'));
        SGML_MAP.put("inodot", Character.valueOf('\u0131'));
        SGML_MAP.put("int", Character.valueOf('\u222b'));
        SGML_MAP.put("intcal", Character.valueOf('\u22ba'));
        SGML_MAP.put("IOcy", Character.valueOf('\u0401'));
        SGML_MAP.put("iocy", Character.valueOf('\u0451'));
        SGML_MAP.put("Iogon", Character.valueOf('\u012e'));
        SGML_MAP.put("iogon", Character.valueOf('\u012f'));
        SGML_MAP.put("Iota", Character.valueOf('\u0399'));
        SGML_MAP.put("iota", Character.valueOf('\u03b9'));
        SGML_MAP.put("iquest", Character.valueOf('\u00bf'));
        SGML_MAP.put("isin", Character.valueOf('\u2208'));
        SGML_MAP.put("Itilde", Character.valueOf('\u0128'));
        SGML_MAP.put("itilde", Character.valueOf('\u0129'));
        SGML_MAP.put("Iukcy", Character.valueOf('\u0406'));
        SGML_MAP.put("iukcy", Character.valueOf('\u0456'));
        SGML_MAP.put("Iuml", Character.valueOf('\u00cf'));
        SGML_MAP.put("iuml", Character.valueOf('\u00ef'));
        SGML_MAP.put("Jcirc", Character.valueOf('\u0134'));
        SGML_MAP.put("jcirc", Character.valueOf('\u0135'));
        SGML_MAP.put("Jcy", Character.valueOf('\u0419'));
        SGML_MAP.put("jcy", Character.valueOf('\u0439'));
        SGML_MAP.put("Jsercy", Character.valueOf('\u0408'));
        SGML_MAP.put("jsercy", Character.valueOf('\u0458'));
        SGML_MAP.put("Jukcy", Character.valueOf('\u0404'));
        SGML_MAP.put("jukcy", Character.valueOf('\u0454'));
        SGML_MAP.put("Kappa", Character.valueOf('\u039a'));
        SGML_MAP.put("kappa", Character.valueOf('\u03ba'));
        SGML_MAP.put("kappav", Character.valueOf('\u03f0'));
        SGML_MAP.put("Kcedil", Character.valueOf('\u0136'));
        SGML_MAP.put("kcedil", Character.valueOf('\u0137'));
        SGML_MAP.put("Kcy", Character.valueOf('\u041a'));
        SGML_MAP.put("kcy", Character.valueOf('\u043a'));
        SGML_MAP.put("Kgr", Character.valueOf('\u039a'));
        SGML_MAP.put("kgr", Character.valueOf('\u03ba'));
        SGML_MAP.put("kgreen", Character.valueOf('\u0138'));
        SGML_MAP.put("KHcy", Character.valueOf('\u0425'));
        SGML_MAP.put("khcy", Character.valueOf('\u0445'));
        SGML_MAP.put("KHgr", Character.valueOf('\u03a7'));
        SGML_MAP.put("khgr", Character.valueOf('\u03c7'));
        SGML_MAP.put("KJcy", Character.valueOf('\u040c'));
        SGML_MAP.put("kjcy", Character.valueOf('\u045c'));
        SGML_MAP.put("lAarr", Character.valueOf('\u21da'));
        SGML_MAP.put("Lacute", Character.valueOf('\u0139'));
        SGML_MAP.put("lacute", Character.valueOf('\u013a'));
        SGML_MAP.put("lagran", Character.valueOf('\u2112'));
        SGML_MAP.put("Lambda", Character.valueOf('\u039b'));
        SGML_MAP.put("lambda", Character.valueOf('\u03bb'));
        SGML_MAP.put("lang", Character.valueOf('\u2329'));
        SGML_MAP.put("laquo", Character.valueOf('\u00ab'));
        SGML_MAP.put("Larr", Character.valueOf('\u219e'));
        SGML_MAP.put("larr", Character.valueOf('\u2190'));
        SGML_MAP.put("lArr", Character.valueOf('\u21d0'));
        SGML_MAP.put("larr2", Character.valueOf('\u21c7'));
        SGML_MAP.put("larrhk", Character.valueOf('\u21a9'));
        SGML_MAP.put("larrlp", Character.valueOf('\u21ab'));
        SGML_MAP.put("larrtl", Character.valueOf('\u21a2'));
        SGML_MAP.put("Lcaron", Character.valueOf('\u013d'));
        SGML_MAP.put("lcaron", Character.valueOf('\u013e'));
        SGML_MAP.put("Lcedil", Character.valueOf('\u013b'));
        SGML_MAP.put("lcedil", Character.valueOf('\u013c'));
        SGML_MAP.put("lceil", Character.valueOf('\u2308'));
        SGML_MAP.put("lcub", Character.valueOf('{'));
        SGML_MAP.put("Lcy", Character.valueOf('\u041b'));
        SGML_MAP.put("lcy", Character.valueOf('\u043b'));
        SGML_MAP.put("ldot", Character.valueOf('\u22d6'));
        SGML_MAP.put("ldquo", Character.valueOf('\u201c'));
        SGML_MAP.put("ldquor", Character.valueOf('\u201e'));
        SGML_MAP.put("lE", Character.valueOf('\u2266'));
        SGML_MAP.put("le", Character.valueOf('\u2264'));
        SGML_MAP.put("leg", Character.valueOf('\u22da'));
        SGML_MAP.put("les", Character.valueOf('\u2264'));
        SGML_MAP.put("lfloor", Character.valueOf('\u230a'));
        SGML_MAP.put("lg", Character.valueOf('\u2276'));
        SGML_MAP.put("Lgr", Character.valueOf('\u039b'));
        SGML_MAP.put("lgr", Character.valueOf('\u03bb'));
        SGML_MAP.put("lhard", Character.valueOf('\u21bd'));
        SGML_MAP.put("lharu", Character.valueOf('\u21bc'));
        SGML_MAP.put("lhblk", Character.valueOf('\u2584'));
        SGML_MAP.put("LJcy", Character.valueOf('\u0409'));
        SGML_MAP.put("ljcy", Character.valueOf('\u0459'));
        SGML_MAP.put("Ll", Character.valueOf('\u22d8'));
        SGML_MAP.put("Lmidot", Character.valueOf('\u013f'));
        SGML_MAP.put("lmidot", Character.valueOf('\u0140'));
        SGML_MAP.put("lnE", Character.valueOf('\u2268'));
        SGML_MAP.put("lne", Character.valueOf('\u2268'));
        SGML_MAP.put("lnsim", Character.valueOf('\u22e6'));
        SGML_MAP.put("lowast", Character.valueOf('\u2217'));
        SGML_MAP.put("lowbar", Character.valueOf('_'));
        SGML_MAP.put("loz", Character.valueOf('\u25ca'));
        SGML_MAP.put("loz", Character.valueOf('\u2727'));
        SGML_MAP.put("lozf", Character.valueOf('\u2726'));
        SGML_MAP.put("lpar", Character.valueOf('('));
        SGML_MAP.put("lrarr2", Character.valueOf('\u21c6'));
        SGML_MAP.put("lrhar2", Character.valueOf('\u21cb'));
        SGML_MAP.put("lrm", Character.valueOf('\u200e'));
        SGML_MAP.put("lsaquo", Character.valueOf('\u2039'));
        SGML_MAP.put("lsh", Character.valueOf('\u21b0'));
        SGML_MAP.put("lsim", Character.valueOf('\u2272'));
        SGML_MAP.put("lsqb", Character.valueOf('['));
        SGML_MAP.put("lsquo", Character.valueOf('\u2018'));
        SGML_MAP.put("lsquor", Character.valueOf('\u201a'));
        SGML_MAP.put("Lstrok", Character.valueOf('\u0141'));
        SGML_MAP.put("lstrok", Character.valueOf('\u0142'));
        SGML_MAP.put("Lt", Character.valueOf('\u226a'));
        SGML_MAP.put("lt", Character.valueOf('<'));
        SGML_MAP.put("lthree", Character.valueOf('\u22cb'));
        SGML_MAP.put("ltimes", Character.valueOf('\u22c9'));
        SGML_MAP.put("ltri", Character.valueOf('\u25c3'));
        SGML_MAP.put("ltrie", Character.valueOf('\u22b4'));
        SGML_MAP.put("ltrif", Character.valueOf('\u25c2'));
        SGML_MAP.put("lvnE", Character.valueOf('\u2268'));
        SGML_MAP.put("macr", Character.valueOf('\u00af'));
        SGML_MAP.put("male", Character.valueOf('\u2642'));
        SGML_MAP.put("malt", Character.valueOf('\u2720'));
        SGML_MAP.put("map", Character.valueOf('\u21a6'));
        SGML_MAP.put("marker", Character.valueOf('\u25ae'));
        SGML_MAP.put("Mcy", Character.valueOf('\u041c'));
        SGML_MAP.put("mcy", Character.valueOf('\u043c'));
        SGML_MAP.put("mdash", Character.valueOf('\u2014'));
        SGML_MAP.put("Mgr", Character.valueOf('\u039c'));
        SGML_MAP.put("mgr", Character.valueOf('\u03bc'));
        SGML_MAP.put("micro", Character.valueOf('\u00b5'));
        SGML_MAP.put("mid", Character.valueOf('\u2223'));
        SGML_MAP.put("middot", Character.valueOf('\u00b7'));
        SGML_MAP.put("minus", Character.valueOf('\u2212'));
        SGML_MAP.put("minusb", Character.valueOf('\u229f'));
        SGML_MAP.put("mldr", Character.valueOf('\u2026'));
        SGML_MAP.put("mnplus", Character.valueOf('\u2213'));
        SGML_MAP.put("models", Character.valueOf('\u22a7'));
        SGML_MAP.put("Mu", Character.valueOf('\u039c'));
        SGML_MAP.put("mu", Character.valueOf('\u03bc'));
        SGML_MAP.put("mumap", Character.valueOf('\u22b8'));
        SGML_MAP.put("nabla", Character.valueOf('\u2207'));
        SGML_MAP.put("Nacute", Character.valueOf('\u0143'));
        SGML_MAP.put("nacute", Character.valueOf('\u0144'));
        SGML_MAP.put("nap", Character.valueOf('\u2249'));
        SGML_MAP.put("napos", Character.valueOf('\u0149'));
        SGML_MAP.put("natur", Character.valueOf('\u266e'));
        SGML_MAP.put("nbsp", Character.valueOf('\u00a0'));
        SGML_MAP.put("Ncaron", Character.valueOf('\u0147'));
        SGML_MAP.put("ncaron", Character.valueOf('\u0148'));
        SGML_MAP.put("Ncedil", Character.valueOf('\u0145'));
        SGML_MAP.put("ncedil", Character.valueOf('\u0146'));
        SGML_MAP.put("ncong", Character.valueOf('\u2247'));
        SGML_MAP.put("Ncy", Character.valueOf('\u041d'));
        SGML_MAP.put("ncy", Character.valueOf('\u043d'));
        SGML_MAP.put("ndash", Character.valueOf('\u2013'));
        SGML_MAP.put("ne", Character.valueOf('\u2260'));
        SGML_MAP.put("nearr", Character.valueOf('\u2197'));
        SGML_MAP.put("nequiv", Character.valueOf('\u2262'));
        SGML_MAP.put("nexist", Character.valueOf('\u2204'));
        SGML_MAP.put("nge", Character.valueOf('\u2271'));
        SGML_MAP.put("nges", Character.valueOf('\u2271'));
        SGML_MAP.put("Ngr", Character.valueOf('\u039d'));
        SGML_MAP.put("ngr", Character.valueOf('\u03bd'));
        SGML_MAP.put("ngt", Character.valueOf('\u226f'));
        SGML_MAP.put("nharr", Character.valueOf('\u21ae'));
        SGML_MAP.put("nhArr", Character.valueOf('\u21ce'));
        SGML_MAP.put("ni", Character.valueOf('\u220b'));
        SGML_MAP.put("NJcy", Character.valueOf('\u040a'));
        SGML_MAP.put("njcy", Character.valueOf('\u045a'));
        SGML_MAP.put("nlarr", Character.valueOf('\u219a'));
        SGML_MAP.put("nlArr", Character.valueOf('\u21cd'));
        SGML_MAP.put("nldr", Character.valueOf('\u2025'));
        SGML_MAP.put("nle", Character.valueOf('\u2270'));
        SGML_MAP.put("nles", Character.valueOf('\u2270'));
        SGML_MAP.put("nlt", Character.valueOf('\u226e'));
        SGML_MAP.put("nltri", Character.valueOf('\u22ea'));
        SGML_MAP.put("nltrie", Character.valueOf('\u22ec'));
        SGML_MAP.put("nmid", Character.valueOf('\u2224'));
        SGML_MAP.put("not", Character.valueOf('\u00ac'));
        SGML_MAP.put("notin", Character.valueOf('\u2209'));
        SGML_MAP.put("npar", Character.valueOf('\u2226'));
        SGML_MAP.put("npr", Character.valueOf('\u2280'));
        SGML_MAP.put("npre", Character.valueOf('\u22e0'));
        SGML_MAP.put("nrarr", Character.valueOf('\u219b'));
        SGML_MAP.put("nrArr", Character.valueOf('\u21cf'));
        SGML_MAP.put("nrtri", Character.valueOf('\u22eb'));
        SGML_MAP.put("nrtrie", Character.valueOf('\u22ed'));
        SGML_MAP.put("nsc", Character.valueOf('\u2281'));
        SGML_MAP.put("nsce", Character.valueOf('\u22e1'));
        SGML_MAP.put("nsim", Character.valueOf('\u2241'));
        SGML_MAP.put("nsime", Character.valueOf('\u2244'));
        SGML_MAP.put("nspar", Character.valueOf('\u2226'));
        SGML_MAP.put("nsub", Character.valueOf('\u2284'));
        SGML_MAP.put("nsubE", Character.valueOf('\u2288'));
        SGML_MAP.put("nsube", Character.valueOf('\u2288'));
        SGML_MAP.put("nsup", Character.valueOf('\u2285'));
        SGML_MAP.put("nsupE", Character.valueOf('\u2289'));
        SGML_MAP.put("nsupe", Character.valueOf('\u2289'));
        SGML_MAP.put("Ntilde", Character.valueOf('\u00d1'));
        SGML_MAP.put("ntilde", Character.valueOf('\u00f1'));
        SGML_MAP.put("Nu", Character.valueOf('\u039d'));
        SGML_MAP.put("nu", Character.valueOf('\u03bd'));
        SGML_MAP.put("num", Character.valueOf('#'));
        SGML_MAP.put("numero", Character.valueOf('\u2116'));
        SGML_MAP.put("numsp", Character.valueOf('\u2007'));
        SGML_MAP.put("nvdash", Character.valueOf('\u22ac'));
        SGML_MAP.put("nvDash", Character.valueOf('\u22ad'));
        SGML_MAP.put("nVdash", Character.valueOf('\u22ae'));
        SGML_MAP.put("nVDash", Character.valueOf('\u22af'));
        SGML_MAP.put("nwarr", Character.valueOf('\u2196'));
        SGML_MAP.put("Oacgr", Character.valueOf('\u038c'));
        SGML_MAP.put("oacgr", Character.valueOf('\u03cc'));
        SGML_MAP.put("Oacute", Character.valueOf('\u00d3'));
        SGML_MAP.put("oacute", Character.valueOf('\u00f3'));
        SGML_MAP.put("oast", Character.valueOf('\u229b'));
        SGML_MAP.put("ocir", Character.valueOf('\u229a'));
        SGML_MAP.put("Ocirc", Character.valueOf('\u00d4'));
        SGML_MAP.put("ocirc", Character.valueOf('\u00f4'));
        SGML_MAP.put("Ocy", Character.valueOf('\u041e'));
        SGML_MAP.put("ocy", Character.valueOf('\u043e'));
        SGML_MAP.put("odash", Character.valueOf('\u229d'));
        SGML_MAP.put("Odblac", Character.valueOf('\u0150'));
        SGML_MAP.put("odblac", Character.valueOf('\u0151'));
        SGML_MAP.put("odot", Character.valueOf('\u2299'));
        SGML_MAP.put("OElig", Character.valueOf('\u0152'));
        SGML_MAP.put("oelig", Character.valueOf('\u0153'));
        SGML_MAP.put("ogon", Character.valueOf('\u02db'));
        SGML_MAP.put("Ogr", Character.valueOf('\u039f'));
        SGML_MAP.put("ogr", Character.valueOf('\u03bf'));
        SGML_MAP.put("Ograve", Character.valueOf('\u00d2'));
        SGML_MAP.put("ograve", Character.valueOf('\u00f2'));
        SGML_MAP.put("OHacgr", Character.valueOf('\u038f'));
        SGML_MAP.put("ohacgr", Character.valueOf('\u03ce'));
        SGML_MAP.put("OHgr", Character.valueOf('\u03a9'));
        SGML_MAP.put("ohgr", Character.valueOf('\u03c9'));
        SGML_MAP.put("ohm", Character.valueOf('\u2126'));
        SGML_MAP.put("olarr", Character.valueOf('\u21ba'));
        SGML_MAP.put("oline", Character.valueOf('\u203e'));
        SGML_MAP.put("Omacr", Character.valueOf('\u014c'));
        SGML_MAP.put("omacr", Character.valueOf('\u014d'));
        SGML_MAP.put("Omega", Character.valueOf('\u03a9'));
        SGML_MAP.put("omega", Character.valueOf('\u03c9'));
        SGML_MAP.put("Omicron", Character.valueOf('\u039f'));
        SGML_MAP.put("omicron", Character.valueOf('\u03bf'));
        SGML_MAP.put("ominus", Character.valueOf('\u2296'));
        SGML_MAP.put("oplus", Character.valueOf('\u2295'));
        SGML_MAP.put("or", Character.valueOf('\u2228'));
        SGML_MAP.put("orarr", Character.valueOf('\u21bb'));
        SGML_MAP.put("order", Character.valueOf('\u2134'));
        SGML_MAP.put("ordf", Character.valueOf('\u00aa'));
        SGML_MAP.put("ordm", Character.valueOf('\u00ba'));
        SGML_MAP.put("oS", Character.valueOf('\u24c8'));
        SGML_MAP.put("Oslash", Character.valueOf('\u00d8'));
        SGML_MAP.put("oslash", Character.valueOf('\u00f8'));
        SGML_MAP.put("osol", Character.valueOf('\u2298'));
        SGML_MAP.put("Otilde", Character.valueOf('\u00d5'));
        SGML_MAP.put("otilde", Character.valueOf('\u00f5'));
        SGML_MAP.put("otimes", Character.valueOf('\u2297'));
        SGML_MAP.put("Ouml", Character.valueOf('\u00d6'));
        SGML_MAP.put("ouml", Character.valueOf('\u00f6'));
        SGML_MAP.put("par", Character.valueOf('\u2225'));
        SGML_MAP.put("para", Character.valueOf('\u00b6'));
        SGML_MAP.put("part", Character.valueOf('\u2202'));
        SGML_MAP.put("Pcy", Character.valueOf('\u041f'));
        SGML_MAP.put("pcy", Character.valueOf('\u043f'));
        SGML_MAP.put("percnt", Character.valueOf('%'));
        SGML_MAP.put("period", Character.valueOf('.'));
        SGML_MAP.put("permil", Character.valueOf('\u2030'));
        SGML_MAP.put("perp", Character.valueOf('\u22a5'));
        SGML_MAP.put("Pgr", Character.valueOf('\u03a0'));
        SGML_MAP.put("pgr", Character.valueOf('\u03c0'));
        SGML_MAP.put("PHgr", Character.valueOf('\u03a6'));
        SGML_MAP.put("phgr", Character.valueOf('\u03c6'));
        SGML_MAP.put("phi", Character.valueOf('\u03c6'));
        SGML_MAP.put("Phi", Character.valueOf('\u03a6'));
        SGML_MAP.put("phis", Character.valueOf('\u03c6'));
        SGML_MAP.put("phiv", Character.valueOf('\u03d5'));
        SGML_MAP.put("phmmat", Character.valueOf('\u2133'));
        SGML_MAP.put("phone", Character.valueOf('\u260e'));
        SGML_MAP.put("Pi", Character.valueOf('\u03a0'));
        SGML_MAP.put("pi", Character.valueOf('\u03c0'));
        SGML_MAP.put("piv", Character.valueOf('\u03d6'));
        SGML_MAP.put("planck", Character.valueOf('\u210f'));
        SGML_MAP.put("plus", Character.valueOf('+'));
        SGML_MAP.put("plusb", Character.valueOf('\u229e'));
        SGML_MAP.put("plusdo", Character.valueOf('\u2214'));
        SGML_MAP.put("plusmn", Character.valueOf('\u00b1'));
        SGML_MAP.put("pound", Character.valueOf('\u00a3'));
        SGML_MAP.put("pr", Character.valueOf('\u227a'));
        SGML_MAP.put("pre", Character.valueOf('\u227c'));
        SGML_MAP.put("prime", Character.valueOf('\u2032'));
        SGML_MAP.put("Prime", Character.valueOf('\u2033'));
        SGML_MAP.put("prnsim", Character.valueOf('\u22e8'));
        SGML_MAP.put("prod", Character.valueOf('\u220f'));
        SGML_MAP.put("prop", Character.valueOf('\u221d'));
        SGML_MAP.put("prsim", Character.valueOf('\u227e'));
        SGML_MAP.put("PSgr", Character.valueOf('\u03a8'));
        SGML_MAP.put("psgr", Character.valueOf('\u03c8'));
        SGML_MAP.put("Psi", Character.valueOf('\u03a8'));
        SGML_MAP.put("psi", Character.valueOf('\u03c8'));
        SGML_MAP.put("puncsp", Character.valueOf('\u2008'));
        SGML_MAP.put("quest", Character.valueOf('?'));
        SGML_MAP.put("quot", Character.valueOf('\"'));
        SGML_MAP.put("rAarr", Character.valueOf('\u21db'));
        SGML_MAP.put("Racute", Character.valueOf('\u0154'));
        SGML_MAP.put("racute", Character.valueOf('\u0155'));
        SGML_MAP.put("radic", Character.valueOf('\u221a'));
        SGML_MAP.put("rang", Character.valueOf('\u232a'));
        SGML_MAP.put("raquo", Character.valueOf('\u00bb'));
        SGML_MAP.put("Rarr", Character.valueOf('\u21a0'));
        SGML_MAP.put("rarr", Character.valueOf('\u2192'));
        SGML_MAP.put("rArr", Character.valueOf('\u21d2'));
        SGML_MAP.put("rarr2", Character.valueOf('\u21c9'));
        SGML_MAP.put("rarrhk", Character.valueOf('\u21aa'));
        SGML_MAP.put("rarrlp", Character.valueOf('\u21ac'));
        SGML_MAP.put("rarrtl", Character.valueOf('\u21a3'));
        SGML_MAP.put("rarrw", Character.valueOf('\u219d'));
        SGML_MAP.put("Rcaron", Character.valueOf('\u0158'));
        SGML_MAP.put("rcaron", Character.valueOf('\u0159'));
        SGML_MAP.put("Rcedil", Character.valueOf('\u0156'));
        SGML_MAP.put("rcedil", Character.valueOf('\u0157'));
        SGML_MAP.put("rceil", Character.valueOf('\u2309'));
        SGML_MAP.put("rcub", Character.valueOf('}'));
        SGML_MAP.put("Rcy", Character.valueOf('\u0420'));
        SGML_MAP.put("rcy", Character.valueOf('\u0440'));
        SGML_MAP.put("rdquo", Character.valueOf('\u201d'));
        SGML_MAP.put("rdquor", Character.valueOf('\u201c'));
        SGML_MAP.put("real", Character.valueOf('\u211c'));
        SGML_MAP.put("rect", Character.valueOf('\u25ad'));
        SGML_MAP.put("reg", Character.valueOf('\u00ae'));
        SGML_MAP.put("rfloor", Character.valueOf('\u230b'));
        SGML_MAP.put("Rgr", Character.valueOf('\u03a1'));
        SGML_MAP.put("rgr", Character.valueOf('\u03c1'));
        SGML_MAP.put("rhard", Character.valueOf('\u21c1'));
        SGML_MAP.put("rharu", Character.valueOf('\u21c0'));
        SGML_MAP.put("Rho", Character.valueOf('\u03a1'));
        SGML_MAP.put("rho", Character.valueOf('\u03c1'));
        SGML_MAP.put("rhov", Character.valueOf('\u03f1'));
        SGML_MAP.put("ring", Character.valueOf('\u02da'));
        SGML_MAP.put("rlarr2", Character.valueOf('\u21c4'));
        SGML_MAP.put("rlhar2", Character.valueOf('\u21cc'));
        SGML_MAP.put("rlm", Character.valueOf('\u200f'));
        SGML_MAP.put("rpar", Character.valueOf(')'));
        SGML_MAP.put("rsaquo", Character.valueOf('\u203a'));
        SGML_MAP.put("rsh", Character.valueOf('\u21b1'));
        SGML_MAP.put("rsqb", Character.valueOf(']'));
        SGML_MAP.put("rsquo", Character.valueOf('\u2019'));
        SGML_MAP.put("rsquor", Character.valueOf('\u2018'));
        SGML_MAP.put("rthree", Character.valueOf('\u22cc'));
        SGML_MAP.put("rtimes", Character.valueOf('\u22ca'));
        SGML_MAP.put("rtri", Character.valueOf('\u25b9'));
        SGML_MAP.put("rtrie", Character.valueOf('\u22b5'));
        SGML_MAP.put("rtrif", Character.valueOf('\u25b8'));
        SGML_MAP.put("rx", Character.valueOf('\u211e'));
        SGML_MAP.put("Sacute", Character.valueOf('\u015a'));
        SGML_MAP.put("sacute", Character.valueOf('\u015b'));
        SGML_MAP.put("samalg", Character.valueOf('\u2210'));
        SGML_MAP.put("sbquo", Character.valueOf('\u201a'));
        SGML_MAP.put("sc", Character.valueOf('\u227b'));
        SGML_MAP.put("Scaron", Character.valueOf('\u0160'));
        SGML_MAP.put("scaron", Character.valueOf('\u0161'));
        SGML_MAP.put("sccue", Character.valueOf('\u227d'));
        SGML_MAP.put("sce", Character.valueOf('\u227d'));
        SGML_MAP.put("Scedil", Character.valueOf('\u015e'));
        SGML_MAP.put("scedil", Character.valueOf('\u015f'));
        SGML_MAP.put("Scirc", Character.valueOf('\u015c'));
        SGML_MAP.put("scirc", Character.valueOf('\u015d'));
        SGML_MAP.put("scnsim", Character.valueOf('\u22e9'));
        SGML_MAP.put("scsim", Character.valueOf('\u227f'));
        SGML_MAP.put("Scy", Character.valueOf('\u0421'));
        SGML_MAP.put("scy", Character.valueOf('\u0441'));
        SGML_MAP.put("sdot", Character.valueOf('\u22c5'));
        SGML_MAP.put("sdotb", Character.valueOf('\u22a1'));
        SGML_MAP.put("sect", Character.valueOf('\u00a7'));
        SGML_MAP.put("semi", Character.valueOf(';'));
        SGML_MAP.put("setmn", Character.valueOf('\u2216'));
        SGML_MAP.put("sext", Character.valueOf('\u2736'));
        SGML_MAP.put("sfgr", Character.valueOf('\u03c2'));
        SGML_MAP.put("sfrown", Character.valueOf('\u2322'));
        SGML_MAP.put("Sgr", Character.valueOf('\u03a3'));
        SGML_MAP.put("sgr", Character.valueOf('\u03c3'));
        SGML_MAP.put("sharp", Character.valueOf('\u266f'));
        SGML_MAP.put("SHCHcy", Character.valueOf('\u0429'));
        SGML_MAP.put("shchcy", Character.valueOf('\u0449'));
        SGML_MAP.put("SHcy", Character.valueOf('\u0428'));
        SGML_MAP.put("shcy", Character.valueOf('\u0448'));
        SGML_MAP.put("shy", Character.valueOf('\u00ad'));
        SGML_MAP.put("Sigma", Character.valueOf('\u03a3'));
        SGML_MAP.put("sigma", Character.valueOf('\u03c3'));
        SGML_MAP.put("sigmaf", Character.valueOf('\u03c2'));
        SGML_MAP.put("sigmav", Character.valueOf('\u03c2'));
        SGML_MAP.put("sim", Character.valueOf('\u223c'));
        SGML_MAP.put("sime", Character.valueOf('\u2243'));
        SGML_MAP.put("smile", Character.valueOf('\u2323'));
        SGML_MAP.put("SOFTcy", Character.valueOf('\u042c'));
        SGML_MAP.put("softcy", Character.valueOf('\u044c'));
        SGML_MAP.put("sol", Character.valueOf('/'));
        SGML_MAP.put("spades", Character.valueOf('\u2660'));
        SGML_MAP.put("spar", Character.valueOf('\u2225'));
        SGML_MAP.put("sqcap", Character.valueOf('\u2293'));
        SGML_MAP.put("sqcup", Character.valueOf('\u2294'));
        SGML_MAP.put("sqsub", Character.valueOf('\u228f'));
        SGML_MAP.put("sqsube", Character.valueOf('\u2291'));
        SGML_MAP.put("sqsup", Character.valueOf('\u2290'));
        SGML_MAP.put("sqsupe", Character.valueOf('\u2292'));
        SGML_MAP.put("squ", Character.valueOf('\u25a1'));
        SGML_MAP.put("square", Character.valueOf('\u25a1'));
        SGML_MAP.put("squf", Character.valueOf('\u25aa'));
        SGML_MAP.put("ssetmn", Character.valueOf('\u2216'));
        SGML_MAP.put("ssmile", Character.valueOf('\u2323'));
        SGML_MAP.put("sstarf", Character.valueOf('\u22c6'));
        SGML_MAP.put("star", Character.valueOf('\u2606'));
        SGML_MAP.put("starf", Character.valueOf('\u2605'));
        SGML_MAP.put("Sub", Character.valueOf('\u22d0'));
        SGML_MAP.put("sub", Character.valueOf('\u2282'));
        SGML_MAP.put("subE", Character.valueOf('\u2286'));
        SGML_MAP.put("sube", Character.valueOf('\u2286'));
        SGML_MAP.put("subnE", Character.valueOf('\u228a'));
        SGML_MAP.put("subne", Character.valueOf('\u228a'));
        SGML_MAP.put("sum", Character.valueOf('\u2211'));
        SGML_MAP.put("sung", Character.valueOf('\u266a'));
        SGML_MAP.put("Sup", Character.valueOf('\u22d1'));
        SGML_MAP.put("sup", Character.valueOf('\u2283'));
        SGML_MAP.put("sup1", Character.valueOf('\u00b9'));
        SGML_MAP.put("sup2", Character.valueOf('\u00b2'));
        SGML_MAP.put("sup3", Character.valueOf('\u00b3'));
        SGML_MAP.put("supE", Character.valueOf('\u2287'));
        SGML_MAP.put("supe", Character.valueOf('\u2287'));
        SGML_MAP.put("supnE", Character.valueOf('\u228b'));
        SGML_MAP.put("supne", Character.valueOf('\u228b'));
        SGML_MAP.put("szlig", Character.valueOf('\u00df'));
        SGML_MAP.put("target", Character.valueOf('\u2316'));
        SGML_MAP.put("Tau", Character.valueOf('\u03a4'));
        SGML_MAP.put("tau", Character.valueOf('\u03c4'));
        SGML_MAP.put("Tcaron", Character.valueOf('\u0164'));
        SGML_MAP.put("tcaron", Character.valueOf('\u0165'));
        SGML_MAP.put("Tcedil", Character.valueOf('\u0162'));
        SGML_MAP.put("tcedil", Character.valueOf('\u0163'));
        SGML_MAP.put("Tcy", Character.valueOf('\u0422'));
        SGML_MAP.put("tcy", Character.valueOf('\u0442'));
        SGML_MAP.put("tdot", Character.valueOf('\u20db'));
        SGML_MAP.put("telrec", Character.valueOf('\u2315'));
        SGML_MAP.put("Tgr", Character.valueOf('\u03a4'));
        SGML_MAP.put("tgr", Character.valueOf('\u03c4'));
        SGML_MAP.put("there4", Character.valueOf('\u2234'));
        SGML_MAP.put("theta", Character.valueOf('\u03b8'));
        SGML_MAP.put("Theta", Character.valueOf('\u0398'));
        SGML_MAP.put("thetas", Character.valueOf('\u03b8'));
        SGML_MAP.put("thetasym", Character.valueOf('\u03d1'));
        SGML_MAP.put("thetav", Character.valueOf('\u03d1'));
        SGML_MAP.put("THgr", Character.valueOf('\u0398'));
        SGML_MAP.put("thgr", Character.valueOf('\u03b8'));
        SGML_MAP.put("thinsp", Character.valueOf('\u2009'));
        SGML_MAP.put("thkap", Character.valueOf('\u2248'));
        SGML_MAP.put("thksim", Character.valueOf('\u223c'));
        SGML_MAP.put("THORN", Character.valueOf('\u00de'));
        SGML_MAP.put("thorn", Character.valueOf('\u00fe'));
        SGML_MAP.put("tilde", Character.valueOf('\u02dc'));
        SGML_MAP.put("times", Character.valueOf('\u00d7'));
        SGML_MAP.put("timesb", Character.valueOf('\u22a0'));
        SGML_MAP.put("top", Character.valueOf('\u22a4'));
        SGML_MAP.put("tprime", Character.valueOf('\u2034'));
        SGML_MAP.put("trade", Character.valueOf('\u2122'));
        SGML_MAP.put("trie", Character.valueOf('\u225c'));
        SGML_MAP.put("TScy", Character.valueOf('\u0426'));
        SGML_MAP.put("tscy", Character.valueOf('\u0446'));
        SGML_MAP.put("TSHcy", Character.valueOf('\u040b'));
        SGML_MAP.put("tshcy", Character.valueOf('\u045b'));
        SGML_MAP.put("Tstrok", Character.valueOf('\u0166'));
        SGML_MAP.put("tstrok", Character.valueOf('\u0167'));
        SGML_MAP.put("twixt", Character.valueOf('\u226c'));
        SGML_MAP.put("Uacgr", Character.valueOf('\u038e'));
        SGML_MAP.put("uacgr", Character.valueOf('\u03cd'));
        SGML_MAP.put("Uacute", Character.valueOf('\u00da'));
        SGML_MAP.put("uacute", Character.valueOf('\u00fa'));
        SGML_MAP.put("uArr", Character.valueOf('\u21d1'));
        SGML_MAP.put("uarr", Character.valueOf('\u2191'));
        SGML_MAP.put("uarr2", Character.valueOf('\u21c8'));
        SGML_MAP.put("Ubrcy", Character.valueOf('\u040e'));
        SGML_MAP.put("ubrcy", Character.valueOf('\u045e'));
        SGML_MAP.put("Ubreve", Character.valueOf('\u016c'));
        SGML_MAP.put("ubreve", Character.valueOf('\u016d'));
        SGML_MAP.put("Ucirc", Character.valueOf('\u00db'));
        SGML_MAP.put("ucirc", Character.valueOf('\u00fb'));
        SGML_MAP.put("Ucy", Character.valueOf('\u0423'));
        SGML_MAP.put("ucy", Character.valueOf('\u0443'));
        SGML_MAP.put("Udblac", Character.valueOf('\u0170'));
        SGML_MAP.put("udblac", Character.valueOf('\u0171'));
        SGML_MAP.put("udiagr", Character.valueOf('\u03b0'));
        SGML_MAP.put("Udigr", Character.valueOf('\u03ab'));
        SGML_MAP.put("udigr", Character.valueOf('\u03cb'));
        SGML_MAP.put("Ugr", Character.valueOf('\u03a5'));
        SGML_MAP.put("ugr", Character.valueOf('\u03c5'));
        SGML_MAP.put("Ugrave", Character.valueOf('\u00d9'));
        SGML_MAP.put("ugrave", Character.valueOf('\u00f9'));
        SGML_MAP.put("uharl", Character.valueOf('\u21bf'));
        SGML_MAP.put("uharr", Character.valueOf('\u21be'));
        SGML_MAP.put("uhblk", Character.valueOf('\u2580'));
        SGML_MAP.put("ulcorn", Character.valueOf('\u231c'));
        SGML_MAP.put("ulcrop", Character.valueOf('\u230f'));
        SGML_MAP.put("Umacr", Character.valueOf('\u016a'));
        SGML_MAP.put("umacr", Character.valueOf('\u016b'));
        SGML_MAP.put("uml", Character.valueOf('\u00a8'));
        SGML_MAP.put("Uogon", Character.valueOf('\u0172'));
        SGML_MAP.put("uogon", Character.valueOf('\u0173'));
        SGML_MAP.put("uplus", Character.valueOf('\u228e'));
        SGML_MAP.put("Upsi", Character.valueOf('\u03a5'));
        SGML_MAP.put("upsi", Character.valueOf('\u03c5'));
        SGML_MAP.put("upsih", Character.valueOf('\u03d2'));
        SGML_MAP.put("Upsilon", Character.valueOf('\u03a5'));
        SGML_MAP.put("upsilon", Character.valueOf('\u03c5'));
        SGML_MAP.put("urcorn", Character.valueOf('\u231d'));
        SGML_MAP.put("urcrop", Character.valueOf('\u230e'));
        SGML_MAP.put("Uring", Character.valueOf('\u016e'));
        SGML_MAP.put("uring", Character.valueOf('\u016f'));
        SGML_MAP.put("Utilde", Character.valueOf('\u0168'));
        SGML_MAP.put("utilde", Character.valueOf('\u0169'));
        SGML_MAP.put("utri", Character.valueOf('\u25b5'));
        SGML_MAP.put("utrif", Character.valueOf('\u25b4'));
        SGML_MAP.put("Uuml", Character.valueOf('\u00dc'));
        SGML_MAP.put("uuml", Character.valueOf('\u00fc'));
        SGML_MAP.put("varr", Character.valueOf('\u2195'));
        SGML_MAP.put("vArr", Character.valueOf('\u21d5'));
        SGML_MAP.put("Vcy", Character.valueOf('\u0412'));
        SGML_MAP.put("vcy", Character.valueOf('\u0432'));
        SGML_MAP.put("vdash", Character.valueOf('\u22a2'));
        SGML_MAP.put("vDash", Character.valueOf('\u22a8'));
        SGML_MAP.put("Vdash", Character.valueOf('\u22a9'));
        SGML_MAP.put("veebar", Character.valueOf('\u22bb'));
        SGML_MAP.put("vellip", Character.valueOf('\u22ee'));
        SGML_MAP.put("verbar", Character.valueOf('|'));
        SGML_MAP.put("Verbar", Character.valueOf('\u2016'));
        SGML_MAP.put("vltri", Character.valueOf('\u22b2'));
        SGML_MAP.put("vprime", Character.valueOf('\u2032'));
        SGML_MAP.put("vprop", Character.valueOf('\u221d'));
        SGML_MAP.put("vrtri", Character.valueOf('\u22b3'));
        SGML_MAP.put("vsubnE", Character.valueOf('\u228a'));
        SGML_MAP.put("vsubne", Character.valueOf('\u228a'));
        SGML_MAP.put("vsupne", Character.valueOf('\u228b'));
        SGML_MAP.put("vsupnE", Character.valueOf('\u228b'));
        SGML_MAP.put("Vvdash", Character.valueOf('\u22aa'));
        SGML_MAP.put("Wcirc", Character.valueOf('\u0174'));
        SGML_MAP.put("wcirc", Character.valueOf('\u0175'));
        SGML_MAP.put("wedgeq", Character.valueOf('\u2259'));
        SGML_MAP.put("weierp", Character.valueOf('\u2118'));
        SGML_MAP.put("wreath", Character.valueOf('\u2240'));
        SGML_MAP.put("xcirc", Character.valueOf('\u25cb'));
        SGML_MAP.put("xdtri", Character.valueOf('\u25bd'));
        SGML_MAP.put("Xgr", Character.valueOf('\u039e'));
        SGML_MAP.put("xgr", Character.valueOf('\u03be'));
        SGML_MAP.put("xhArr", Character.valueOf('\u2194'));
        SGML_MAP.put("xharr", Character.valueOf('\u2194'));
        SGML_MAP.put("Xi", Character.valueOf('\u039e'));
        SGML_MAP.put("xi", Character.valueOf('\u03be'));
        SGML_MAP.put("xlArr", Character.valueOf('\u21d0'));
        SGML_MAP.put("xrArr", Character.valueOf('\u21d2'));
        SGML_MAP.put("xutri", Character.valueOf('\u25b3'));
        SGML_MAP.put("Yacute", Character.valueOf('\u00dd'));
        SGML_MAP.put("yacute", Character.valueOf('\u00fd'));
        SGML_MAP.put("YAcy", Character.valueOf('\u042f'));
        SGML_MAP.put("yacy", Character.valueOf('\u044f'));
        SGML_MAP.put("Ycirc", Character.valueOf('\u0176'));
        SGML_MAP.put("ycirc", Character.valueOf('\u0177'));
        SGML_MAP.put("Ycy", Character.valueOf('\u042b'));
        SGML_MAP.put("ycy", Character.valueOf('\u044b'));
        SGML_MAP.put("yen", Character.valueOf('\u00a5'));
        SGML_MAP.put("YIcy", Character.valueOf('\u0407'));
        SGML_MAP.put("yicy", Character.valueOf('\u0457'));
        SGML_MAP.put("YUcy", Character.valueOf('\u042e'));
        SGML_MAP.put("yucy", Character.valueOf('\u044e'));
        SGML_MAP.put("yuml", Character.valueOf('\u00ff'));
        SGML_MAP.put("Yuml", Character.valueOf('\u0178'));
        SGML_MAP.put("Zacute", Character.valueOf('\u0179'));
        SGML_MAP.put("zacute", Character.valueOf('\u017a'));
        SGML_MAP.put("Zcaron", Character.valueOf('\u017d'));
        SGML_MAP.put("zcaron", Character.valueOf('\u017e'));
        SGML_MAP.put("Zcy", Character.valueOf('\u0417'));
        SGML_MAP.put("zcy", Character.valueOf('\u0437'));
        SGML_MAP.put("Zdot", Character.valueOf('\u017b'));
        SGML_MAP.put("zdot", Character.valueOf('\u017c'));
        SGML_MAP.put("Zeta", Character.valueOf('\u0396'));
        SGML_MAP.put("zeta", Character.valueOf('\u03b6'));
        SGML_MAP.put("Zgr", Character.valueOf('\u0396'));
        SGML_MAP.put("zgr", Character.valueOf('\u03b6'));
        SGML_MAP.put("ZHcy", Character.valueOf('\u0416'));
        SGML_MAP.put("zhcy", Character.valueOf('\u0436'));
        SGML_MAP.put("zwj", Character.valueOf('\u200d'));
        SGML_MAP.put("zwnj", Character.valueOf('\u200c'));
    }
}

