/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.ScoredObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToDoubleMap<E>
extends HashMap<E, Double> {
    static final long serialVersionUID = 2891073039706316972L;

    public void increment(E key, double increment) {
        this.set(key, increment + this.getValue(key));
    }

    public void set(E key, double val) {
        if (val == 0.0) {
            this.remove(key);
        } else {
            this.put(key, new Double(val));
        }
    }

    public double getValue(E key) {
        Double d = (Double)this.get(key);
        return d == null ? 0.0 : d;
    }

    public List<E> keysOrderedByValueList() {
        ArrayList keys = new ArrayList(this.keySet().size());
        keys.addAll(this.keySet());
        Collections.sort(keys, this.valueComparator());
        return keys;
    }

    public Object[] keysOrderedByValue() {
        return this.keysOrderedByValueList().toArray();
    }

    public List<ScoredObject<E>> scoredObjectsOrderedByValueList() {
        Set entrySet = this.entrySet();
        ArrayList sos = new ArrayList(entrySet.size());
        for (Map.Entry entry : entrySet) {
            Object key = entry.getKey();
            double val = (Double)entry.getValue();
            sos.add(new ScoredObject(key, val));
        }
        Collections.sort(sos, ScoredObject.REVERSE_SCORE_COMPARATOR);
        return sos;
    }

    public ScoredObject<E>[] scoredObjectsOrderedByValue() {
        Set entrySet = this.entrySet();
        ScoredObject[] result = new ScoredObject[this.entrySet().size()];
        int i = 0;
        for (Map.Entry entry : entrySet) {
            Object key = entry.getKey();
            double val = (Double)entry.getValue();
            result[i++] = new ScoredObject(key, val);
        }
        Arrays.sort(result, ScoredObject.REVERSE_SCORE_COMPARATOR);
        return result;
    }

    public Comparator<E> valueComparator() {
        return new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                double d2;
                double d1 = ObjectToDoubleMap.this.getValue(o1);
                if (d1 > (d2 = ObjectToDoubleMap.this.getValue(o2))) {
                    return -1;
                }
                if (d1 < d2) {
                    return 1;
                }
                if (Double.isNaN(d1) && !Double.isNaN(d2)) {
                    return 1;
                }
                if (Double.isNaN(d2)) {
                    return -1;
                }
                if (!(o1 instanceof Comparable) || !(o2 instanceof Comparable)) {
                    return 0;
                }
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
        };
    }
}

