/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Counter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToCounterMap<E>
extends HashMap<E, Counter> {
    static final long serialVersionUID = -4735380145915633564L;

    public void increment(E key) {
        this.increment(key, 1);
    }

    public void increment(E key, int n) {
        if (!this.containsKey(key)) {
            this.put(key, new Counter(n));
            return;
        }
        Counter counter = (Counter)this.get(key);
        counter.increment(n);
        if (counter.value() == 0) {
            this.remove(key);
        }
    }

    public void set(E key, int n) {
        if (n == 0) {
            this.remove(key);
            return;
        }
        if (!this.containsKey(key)) {
            this.put(key, new Counter(n));
            return;
        }
        Counter counter = (Counter)this.get(key);
        counter.set(n);
    }

    public int getCount(E key) {
        if (!this.containsKey(key)) {
            return 0;
        }
        return ((Counter)this.get(key)).value();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        List<E> keyList = this.keysOrderedByCountList();
        for (E key : keyList) {
            sb.append(key);
            sb.append('=');
            sb.append(this.getCount(key));
            sb.append('\n');
        }
        return sb.toString();
    }

    public List<E> keysOrderedByCountList() {
        Set keySet = this.keySet();
        ArrayList result = new ArrayList(this.keySet().size());
        result.addAll(keySet);
        Collections.sort(result, this.countComparator());
        return result;
    }

    public Object[] keysOrderedByCount() {
        return this.keysOrderedByCountList().toArray();
    }

    public void prune(int minCount) {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            if (((Counter)it.next().getValue()).value() >= minCount) continue;
            it.remove();
        }
    }

    public Comparator<E> countComparator() {
        return new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                int count2;
                int count1 = ObjectToCounterMap.this.getCount(o1);
                if (count1 < (count2 = ObjectToCounterMap.this.getCount(o2))) {
                    return 1;
                }
                if (count1 > count2) {
                    return -1;
                }
                if (!(o1 instanceof Comparable) || !(o2 instanceof Comparable)) {
                    return 0;
                }
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
        };
    }
}

