/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBestSet<E>
extends TreeSet<E> {
    static final long serialVersionUID = 1877503923749415403L;
    private final int mMax;

    public NBestSet(int max, Comparator<? super E> comparator) {
        super(comparator);
        this.mMax = max;
    }

    public NBestSet(int max) {
        this.mMax = max;
    }

    @Override
    public boolean add(E obj) {
        int comparison;
        if (this.size() < this.mMax) {
            return super.add(obj);
        }
        Object first = this.first();
        Comparator comparator = this.comparator();
        int n = comparison = comparator == null ? ((Comparable)obj).compareTo((Comparable)first) : comparator.compare(obj, first);
        if (comparison <= 0) {
            return false;
        }
        this.remove(first);
        return super.add(obj);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            changed = changed || this.add(it.next());
        }
        return changed;
    }
}

