/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Iterators {
    private Iterators() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sequence<E>
    implements Iterator<E> {
        private final Iterator<? extends Iterator<? extends E>> mIterators;
        private Iterator<? extends E> mCurrentIterator;
        private Iterator<? extends E> mLastIteratorNextCalled;

        public Sequence(Iterator<? extends E> iterator1, Iterator<? extends E> iterator2) {
            this(Sequence.toIteratorIterator(iterator1, iterator2));
        }

        public Sequence(Iterator<? extends E>[] iterators) {
            this(new Array<Iterator<? extends E>>(iterators));
        }

        public Sequence(Iterator<? extends Iterator<? extends E>> iteratorOfIterators) {
            this.mIterators = iteratorOfIterators;
        }

        @Override
        public boolean hasNext() {
            if (this.mCurrentIterator == null) {
                this.nextIterator();
            }
            while (this.mCurrentIterator != null) {
                if (this.mCurrentIterator.hasNext()) {
                    return true;
                }
                this.nextIterator();
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mLastIteratorNextCalled = this.mCurrentIterator;
            return this.mCurrentIterator.next();
        }

        @Override
        public void remove() {
            if (this.mLastIteratorNextCalled == null) {
                throw new IllegalStateException("next() not yet called.");
            }
            this.mLastIteratorNextCalled.remove();
            this.mLastIteratorNextCalled = null;
        }

        private void nextIterator() {
            this.mCurrentIterator = this.mIterators.hasNext() ? this.mIterators.next() : null;
        }

        static <E> Iterator<? extends Iterator<? extends E>> toIteratorIterator(Iterator<? extends E> it1, Iterator<? extends E> it2) {
            ArrayList<Iterator<? extends E>> list = new ArrayList<Iterator<? extends E>>(2);
            list.add(it1);
            list.add(it2);
            return list.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Buffered<E>
    implements Iterator<E> {
        private E mNext;

        protected Buffered() {
        }

        protected abstract E bufferNext();

        @Override
        public boolean hasNext() {
            return this.mNext != null || (this.mNext = this.bufferNext()) != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E result = this.mNext;
            this.mNext = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Modifier<E>
    implements Iterator<E> {
        private final Iterator<? extends E> mIt;

        public Modifier(Iterator<? extends E> it) {
            this.mIt = it;
        }

        @Override
        public void remove() {
            this.mIt.remove();
        }

        @Override
        public boolean hasNext() {
            return this.mIt.hasNext();
        }

        @Override
        public E next() {
            return this.modify(this.mIt.next());
        }

        public abstract E modify(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Filter<E>
    implements Iterator<E> {
        private final Iterator<? extends E> mIterator;
        private boolean mFoundNext = false;
        private E mNext;

        public Filter(Iterator<? extends E> iterator) {
            this.mIterator = iterator;
        }

        public abstract boolean accept(E var1);

        @Override
        public boolean hasNext() {
            if (this.mFoundNext) {
                return true;
            }
            while (this.mIterator.hasNext()) {
                E y = this.mIterator.next();
                if (!this.accept(y)) continue;
                this.mFoundNext = true;
                this.mNext = y;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mFoundNext = false;
            E result = this.mNext;
            this.mNext = null;
            return result;
        }

        @Override
        public void remove() {
            String msg = "Cannot remove from a filtered iterator.";
            throw new UnsupportedOperationException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<E>
    implements Iterator<E> {
        private int mMembersReturned = 0;
        private E mMember1;
        private E mMember2;

        public Pair(E member1, E member2) {
            this.mMember1 = member1;
            this.mMember2 = member2;
        }

        @Override
        public boolean hasNext() {
            return this.mMembersReturned < 2;
        }

        @Override
        public E next() {
            if (this.mMembersReturned == 0) {
                ++this.mMembersReturned;
                E result1 = this.mMember1;
                this.mMember1 = null;
                return result1;
            }
            if (this.mMembersReturned == 1) {
                ++this.mMembersReturned;
                E result2 = this.mMember2;
                this.mMember2 = null;
                return result2;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            String msg = "This iterator does not support remove(). class=" + this.getClass();
            throw new UnsupportedOperationException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Singleton<E>
    implements Iterator<E> {
        private E mMember;
        private boolean mHasNext = true;

        public Singleton(E member) {
            this.mMember = member;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public E next() {
            if (!this.mHasNext) {
                throw new NoSuchElementException();
            }
            this.mHasNext = false;
            E result = this.mMember;
            this.mMember = null;
            return result;
        }

        @Override
        public void remove() {
            String msg = "This iterator does not support remove(). class=" + this.getClass();
            throw new UnsupportedOperationException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Empty<E>
    implements Iterator<E> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            String msg = "No elements in empty iterator.";
            throw new NoSuchElementException(msg);
        }

        @Override
        public void remove() {
            String msg = "No elements to remove in empty iterator.";
            throw new IllegalStateException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArraySlice<E>
    implements Iterator<E> {
        private final E[] mObjects;
        private int mNext;
        private final int mLast;

        public ArraySlice(E[] objects, int start, int length) {
            this.mObjects = objects;
            this.mNext = start;
            this.mLast = start + length;
        }

        @Override
        public boolean hasNext() {
            return this.mNext < this.mLast;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.mObjects[this.mNext++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array<E>
    implements Iterator<E> {
        private final E[] mMembers;
        private int mPosition = 0;

        public Array(E[] members) {
            this.mMembers = members;
        }

        @Override
        public boolean hasNext() {
            return this.mPosition < this.mMembers.length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.mMembers[this.mPosition++];
        }

        @Override
        public void remove() {
            if (this.mPosition < 1) {
                throw new IllegalStateException("Next not yet called.");
            }
            if (this.mMembers[this.mPosition - 1] == null) {
                throw new IllegalStateException("Remove already called.");
            }
            this.mMembers[this.mPosition - 1] = null;
        }
    }
}

