/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Collections;
import com.aliasi.util.Streams;
import com.aliasi.util.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;

public class Files {
    private static String FILE_URL_PREFIX = "file:///";
    private static final String TEMP_DIRECTORY_SYS_PROPERTY = "java.io.tmpdir";
    public static final File TEMP_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    public static final FileFilter NON_CVS_DIRECTORY_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().equalsIgnoreCase("CVS");
        }
    };
    public static final FileFilter FILES_ONLY_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile();
        }
    };

    private Files() {
    }

    public static void writeBytesToFile(byte[] bytes, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        out.write(bytes);
        Streams.closeOutputStream(out);
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        Streams.copy(in, bytesOut);
        Streams.closeInputStream(in);
        return bytesOut.toByteArray();
    }

    public static void writeCharsToFile(char[] chars, File file, String charset) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);
        writer.write(chars);
        Streams.closeWriter(writer);
    }

    public static void writeCharsToFile(char[] chars, File file) throws IOException {
        Files.writeCharsToFile(chars, file, Strings.UTF8);
    }

    public static void writeStringToFile(String s, File file) throws IOException {
        Files.writeCharsToFile(s.toCharArray(), file);
    }

    public static void writeStringToFile(String s, File file, String charset) throws IOException {
        Files.writeCharsToFile(s.toCharArray(), file, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readCharsFromFile(File file, String charset) throws IOException {
        CharArrayWriter charWriter = new CharArrayWriter();
        FileInputStream in = null;
        InputStreamReader inReader = null;
        BufferedReader bufferedReader = null;
        try {
            in = new FileInputStream(file);
            inReader = new InputStreamReader((InputStream)in, charset);
            bufferedReader = new BufferedReader(inReader);
            Streams.copy(bufferedReader, charWriter);
        }
        catch (Throwable throwable) {
            Streams.closeReader(bufferedReader);
            Streams.closeReader(inReader);
            Streams.closeInputStream(in);
            throw throwable;
        }
        Streams.closeReader(bufferedReader);
        Streams.closeReader(inReader);
        Streams.closeInputStream(in);
        return charWriter.toCharArray();
    }

    public static char[] readCharsFromFile(File file) throws IOException {
        return Files.readCharsFromFile(file, Strings.UTF8);
    }

    public static String readFromFile(File file, String charset) throws IOException {
        return new String(Files.readCharsFromFile(file, charset));
    }

    public static String readFromFile(File file) throws IOException {
        return Files.readFromFile(file, Strings.UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFrom(File file) throws ClassNotFoundException, IOException {
        Object object;
        FileInputStream fileIn = null;
        BufferedInputStream bufIn = null;
        ObjectInputStream objIn = null;
        try {
            fileIn = new FileInputStream(file);
            bufIn = new BufferedInputStream(fileIn);
            objIn = new ObjectInputStream(bufIn);
            object = objIn.readObject();
        }
        catch (Throwable throwable) {
            Streams.closeInputStream(objIn);
            Streams.closeInputStream(bufIn);
            Streams.closeInputStream(fileIn);
            throw throwable;
        }
        Streams.closeInputStream(objIn);
        Streams.closeInputStream(bufIn);
        Streams.closeInputStream(fileIn);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectTo(Serializable object, File file) throws IOException {
        FileOutputStream fileOut = null;
        BufferedOutputStream bufOut = null;
        ObjectOutputStream objOut = null;
        try {
            fileOut = new FileOutputStream(file);
            bufOut = new BufferedOutputStream(fileOut);
            objOut = new ObjectOutputStream(bufOut);
            objOut.writeObject(object);
        }
        catch (Throwable throwable) {
            Streams.closeOutputStream(objOut);
            Streams.closeOutputStream(bufOut);
            Streams.closeOutputStream(fileOut);
            throw throwable;
        }
        Streams.closeOutputStream(objOut);
        Streams.closeOutputStream(bufOut);
        Streams.closeOutputStream(fileOut);
    }

    public static String prefix(String name) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return name;
        }
        return name.substring(0, lastDotIndex);
    }

    public static String suffix(String name) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return "";
        }
        if (lastDotIndex >= name.length()) {
            return "";
        }
        return name.substring(lastDotIndex + 1);
    }

    public static String baseName(File file) {
        return Files.prefix(file.getName());
    }

    public static int removeRecursive(File file) {
        if (file == null) {
            return 0;
        }
        int descCount = Files.removeDescendants(file);
        file.delete();
        return descCount + 1;
    }

    public static int removeDescendants(File file) {
        if (!file.isDirectory()) {
            return 0;
        }
        int count = 0;
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            count += Files.removeRecursive(files[i]);
        }
        return count;
    }

    public static File makeCleanDir(File directory, String name) {
        return Files.makeCleanDir(new File(directory, name));
    }

    public static File makeCleanDir(File file) {
        if (file.exists() & !file.isDirectory()) {
            file.delete();
        }
        if (!file.isDirectory()) {
            file.mkdir();
        }
        Files.removeDescendants(file);
        return file;
    }

    public static File createTempFile(String fileName) {
        File tempFile = new File(TEMP_DIRECTORY, fileName);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static String fileToURLName(File file) throws IOException {
        return FILE_URL_PREFIX + file.getCanonicalPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLinesFromFile(File file, String charset) throws IOException {
        String[] stringArray;
        FileInputStream in = null;
        InputStreamReader streamReader = null;
        BufferedReader reader = null;
        try {
            String line;
            in = new FileInputStream(file);
            streamReader = new InputStreamReader((InputStream)in, charset);
            reader = new BufferedReader(streamReader);
            ArrayList<String> list = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            stringArray = Collections.toStringArray(list);
        }
        catch (Throwable throwable) {
            Streams.closeInputStream(in);
            Streams.closeReader(streamReader);
            Streams.closeReader(reader);
            throw throwable;
        }
        Streams.closeInputStream(in);
        Streams.closeReader(streamReader);
        Streams.closeReader(reader);
        return stringArray;
    }

    public static Object serializeDeserialize(Serializable in) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        objOut.writeObject(in);
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        return objIn.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            byte[] bytes = new byte[4096];
            int len = 0;
            while ((len = in.read(bytes)) >= 0) {
                out.write(bytes, 0, len);
            }
        }
        catch (Throwable throwable) {
            Streams.closeInputStream(in);
            Streams.closeOutputStream(out);
            throw throwable;
        }
        Streams.closeInputStream(in);
        Streams.closeOutputStream(out);
    }
}

