/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastCache<K, V>
extends AbstractMap<K, V> {
    private static final double DEFAULT_LOAD_FACTOR = 0.5;
    private final SoftReference[] mBuckets;
    private volatile int mNumEntries = 0;
    private int mMaxEntries;

    public FastCache(int size) {
        this(size, 0.5);
    }

    public FastCache(int size, double loadFactor) {
        this.mMaxEntries = (int)(loadFactor * (double)size);
        if (this.mMaxEntries < 1) {
            String msg = "size * loadFactor must be > 0. Found size=" + size + " loadFactor=" + loadFactor;
            throw new IllegalArgumentException(msg);
        }
        this.mBuckets = new SoftReference[size];
    }

    Record<K, V> getFirstRecord(int bucketId) {
        SoftReference ref = this.mBuckets[bucketId];
        if (ref == null) {
            return null;
        }
        Record record = (Record)ref.get();
        if (record == null) {
            return null;
        }
        return record;
    }

    void setFirstRecord(int bucketId, Record<K, V> record) {
        SoftReference<Record<K, V>> ref;
        this.mBuckets[bucketId] = ref = new SoftReference<Record<K, V>>(record);
    }

    @Override
    public V get(Object key) {
        int bucketId = this.bucketId(key);
        Record<K, V> record = this.getFirstRecord(bucketId);
        while (record != null) {
            if (record.mKey.equals(key)) {
                ++record.mCount;
                return record.mValue;
            }
            record = record.mNextRecord;
        }
        return null;
    }

    int bucketId(Object key) {
        return Math.abs(key.hashCode() % this.mBuckets.length);
    }

    @Override
    public V put(K key, V value) {
        Record<K, V> firstRecord;
        int bucketId = this.bucketId(key);
        Record<K, V> record = firstRecord = this.getFirstRecord(bucketId);
        while (record != null) {
            if (record.mKey.equals(key)) {
                ++record.mCount;
                return null;
            }
            record = record.mNextRecord;
        }
        this.prune();
        record = new Record<K, V>(key, value, firstRecord);
        this.setFirstRecord(bucketId, record);
        ++this.mNumEntries;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune() {
        FastCache fastCache = this;
        synchronized (fastCache) {
            if (this.mNumEntries < this.mMaxEntries) {
                return;
            }
            int count = 0;
            for (int i = 0; i < this.mBuckets.length; ++i) {
                Record<K, V> record = this.getFirstRecord(i);
                Record<K, V> prunedRecord = this.prune(record);
                this.setFirstRecord(i, prunedRecord);
                Record<K, V> r = prunedRecord;
                while (r != null) {
                    ++count;
                    r = r.mNextRecord;
                }
            }
            this.mNumEntries = count;
        }
    }

    final Record<K, V> prune(Record<K, V> inRecord) {
        Record<K, V> record = inRecord;
        while (record != null && record.mCount >>> 2 == 0) {
            record = record.mNextRecord;
        }
        if (record == null) {
            return null;
        }
        Record tail = this.prune(record.mNextRecord);
        return new Record(record.mKey, record.mValue, tail, record.mCount);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.mBuckets.length; ++i) {
            Record<K, V> record = this.getFirstRecord(i);
            while (record != null) {
                entrySet.add(record);
                record = record.mNextRecord;
            }
        }
        return entrySet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Record<K, V>
    implements Map.Entry<K, V> {
        final K mKey;
        final V mValue;
        final Record<K, V> mNextRecord;
        int mCount;

        Record(K key, V value) {
            this(key, value, null);
        }

        Record(K key, V value, Record<K, V> nextRecord) {
            this(key, value, nextRecord, 1);
        }

        Record(K key, V value, Record<K, V> nextRecord, int count) {
            this.mKey = key;
            this.mValue = value;
            this.mNextRecord = nextRecord;
            this.mCount = count;
        }

        @Override
        public K getKey() {
            return this.mKey;
        }

        @Override
        public V getValue() {
            return this.mValue;
        }

        @Override
        public int hashCode() {
            return (this.mKey == null ? 0 : this.mKey.hashCode()) ^ (this.mValue == null ? 0 : this.mValue.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o;
            return (this.mKey == null ? e2.getKey() == null : this.mKey.equals(e2.getKey())) && (this.mValue == null ? e2.getValue() == null : this.mValue.equals(e2.getValue()));
        }

        @Override
        public V setValue(V value) {
            String msg = "Cache records may not be set.";
            throw new UnsupportedOperationException(msg);
        }
    }
}

