/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collections {
    private Collections() {
    }

    public static boolean isSingleton(Collection<?> c) {
        return c.size() == 1;
    }

    public static <E> E getFirst(List<? extends E> l) {
        return l.get(0);
    }

    public static <E> E getFirst(Set<? extends E> s) {
        return s.iterator().next();
    }

    public static boolean intersects(Set<?> set1, Set<?> set2) {
        for (Object element1 : set1) {
            if (!set2.contains(element1)) continue;
            return true;
        }
        return false;
    }

    public static <E> void addAll(Collection<? super E> c, E[] xs) {
        for (int i = 0; i < xs.length; ++i) {
            c.add(xs[i]);
        }
    }

    public static String[] toStringArray(Collection c) {
        String[] result = new String[c.size()];
        Collections.toStringArray(c, result);
        return result;
    }

    public static void toStringArray(Collection c, String[] members) {
        Iterator it = c.iterator();
        for (int i = 0; it.hasNext() && i < members.length; ++i) {
            Object obj = it.next();
            members[i] = obj == null ? "null" : obj.toString();
        }
    }

    public static int[] toIntArray(Collection cs) {
        int[] result = new int[cs.size()];
        Iterator it = cs.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i] = (Integer)it.next();
            ++i;
        }
        return result;
    }

    public static String setToString(Set<?> s) {
        StringBuffer sb = new StringBuffer();
        Collections.setToStringBuffer(sb, s);
        return sb.toString();
    }

    public static String listToString(List<?> ls) {
        StringBuffer sb = new StringBuffer();
        Collections.listToStringBuffer(sb, ls);
        return sb.toString();
    }

    public static void listToStringBuffer(StringBuffer sb, List<?> ls) {
        sb.append('<');
        Collections.elementsToStringBuffer(sb, ls);
        sb.append('>');
    }

    public static void setToStringBuffer(StringBuffer sb, Set<?> c) {
        sb.append('{');
        Collections.elementsToStringBuffer(sb, c);
        sb.append('}');
    }

    public static void elementsToStringBuffer(StringBuffer sb, Collection<?> c) {
        Iterator<?> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(it.next());
            ++i;
        }
    }

    public static <E> Set<E> immutableSet(Collection<? extends E> elts) {
        return new ImmutableSet<E>(elts);
    }

    public static <E> Set<E> immutableSet(E[] elts) {
        return new ImmutableSet<E>(elts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImmutableSet<E>
    extends HashSet<E> {
        final int mHashCode;
        static final long serialVersionUID = -5024744406713321676L;

        ImmutableSet(Collection<? extends E> elts) {
            for (E elt : elts) {
                this.add(elt);
            }
            this.mHashCode = super.hashCode();
        }

        ImmutableSet(E[] elts) {
            for (int i = 0; i < elts.length; ++i) {
                this.add(elts[i]);
            }
            this.mHashCode = super.hashCode();
        }

        @Override
        public int hashCode() {
            return this.mHashCode;
        }

        @Override
        public Iterator<E> iterator() {
            return java.util.Collections.unmodifiableSet(this).iterator();
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

