/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.PriorityQueue;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedPriorityQueue<E>
extends AbstractCollection<E>
implements PriorityQueue<E> {
    final TreeSet<Entry<E>> mQueue;
    private int mMaxSize;
    private final Comparator<? super E> mComparator;

    public BoundedPriorityQueue(Comparator<? super E> comparator, int maxSize) {
        if (maxSize < 1) {
            String msg = "Require maximum size >= 1. Found max size=" + maxSize;
            throw new IllegalArgumentException(msg);
        }
        this.mQueue = new TreeSet(new EntryComparator());
        this.mComparator = comparator;
        this.mMaxSize = maxSize;
    }

    @Override
    public boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)((Entry)this.mQueue.first()).mObject;
    }

    @Override
    public E pop() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.mQueue.isEmpty()) {
            return null;
        }
        Entry<E> entry = this.mQueue.first();
        this.mQueue.remove(entry);
        return (E)((Entry)entry).mObject;
    }

    @Override
    public boolean remove(Object obj) {
        return this.mQueue.remove(new Entry<Object>(obj, -1L));
    }

    public void setMaxSize(int maxSize) {
        this.mMaxSize = maxSize;
        while (this.mQueue.size() > this.maxSize()) {
            this.mQueue.remove(this.mQueue.last());
        }
    }

    @Override
    public boolean add(E o) {
        if (this.size() < this.mMaxSize) {
            return this.mQueue.add(new Entry<E>(o));
        }
        Entry<E> last = this.mQueue.last();
        Object lastObj = ((Entry)last).mObject;
        if (this.mComparator.compare(o, lastObj) <= 0) {
            return false;
        }
        if (!this.mQueue.add(new Entry<E>(o))) {
            return false;
        }
        this.mQueue.remove(last);
        return true;
    }

    @Override
    public void clear() {
        this.mQueue.clear();
    }

    @Override
    public int size() {
        return this.mQueue.size();
    }

    public int maxSize() {
        return this.mMaxSize;
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator<E>(this.mQueue.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueueIterator<E>
    implements Iterator<E> {
        private final Iterator<Entry<E>> mIterator;

        QueueIterator(Iterator<Entry<E>> iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public E next() {
            return (E)((Entry)this.mIterator.next()).mObject;
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<E> {
        private final long mId;
        private final E mObject;
        private static long sNextId = 0L;

        public Entry(E object) {
            this(object, Entry.nextId());
        }

        public Entry(E object, long id) {
            this.mObject = object;
            this.mId = id;
        }

        private static synchronized long nextId() {
            return sNextId++;
        }

        public String toString() {
            return "qEntry(" + this.mObject.toString() + "," + this.mId + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryComparator
    implements Comparator<Entry<E>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Entry<E> entry1, Entry<E> entry2) {
            Object eObj2;
            Object eObj1 = entry1.mObject;
            if (eObj1.equals(eObj2 = entry2.mObject)) {
                return 0;
            }
            int comp = BoundedPriorityQueue.this.mComparator.compare(eObj1, eObj2);
            if (comp != 0) {
                return -comp;
            }
            return entry1.mId < entry2.mId ? 1 : -1;
        }
    }
}

