/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Compilable;
import com.aliasi.util.Streams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class AbstractExternalizable
implements Externalizable {
    static final long serialVersionUID = -3880451086025138660L;
    private Object mObjectRead;

    protected AbstractExternalizable() {
    }

    protected abstract Object read(ObjectInput var1) throws ClassNotFoundException, IOException;

    public abstract void writeExternal(ObjectOutput var1) throws IOException;

    public final void readExternal(ObjectInput objIn) throws ClassNotFoundException, IOException {
        this.mObjectRead = this.read(objIn);
    }

    protected Object readResolve() {
        return this.mObjectRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compileTo(Compilable compilable, File file) throws IOException {
        FileOutputStream fileOut = null;
        BufferedOutputStream bufOut = null;
        ObjectOutputStream objOut = null;
        try {
            fileOut = new FileOutputStream(file);
            bufOut = new BufferedOutputStream(fileOut);
            objOut = new ObjectOutputStream(bufOut);
            compilable.compileTo(objOut);
        }
        catch (Throwable throwable) {
            Streams.closeOutputStream(objOut);
            Streams.closeOutputStream(bufOut);
            Streams.closeOutputStream(fileOut);
            throw throwable;
        }
        Streams.closeOutputStream(objOut);
        Streams.closeOutputStream(bufOut);
        Streams.closeOutputStream(fileOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeTo(Serializable serializable, File file) throws IOException {
        FileOutputStream fileOut = null;
        BufferedOutputStream bufOut = null;
        ObjectOutputStream objOut = null;
        try {
            fileOut = new FileOutputStream(file);
            bufOut = new BufferedOutputStream(fileOut);
            objOut = new ObjectOutputStream(bufOut);
            objOut.writeObject(serializable);
        }
        catch (Throwable throwable) {
            Streams.closeOutputStream(objOut);
            Streams.closeOutputStream(bufOut);
            Streams.closeOutputStream(fileOut);
            throw throwable;
        }
        Streams.closeOutputStream(objOut);
        Streams.closeOutputStream(bufOut);
        Streams.closeOutputStream(fileOut);
    }

    public static void serializeOrCompile(Object obj, ObjectOutput out) throws IOException {
        if (obj instanceof Serializable) {
            out.writeObject(obj);
        } else if (obj instanceof Compilable) {
            ((Compilable)obj).compileTo(out);
        } else {
            String msg = "Object must be compilable or serializable. Found object with class=" + obj.getClass();
            throw new IllegalArgumentException(msg);
        }
    }

    public static void compileOrSerialize(Object obj, ObjectOutput out) throws IOException {
        if (obj instanceof Compilable) {
            ((Compilable)obj).compileTo(out);
        } else if (obj instanceof Serializable) {
            out.writeObject(obj);
        } else {
            String msg = "Object must be compilable or serializable. Found object with class=" + obj.getClass();
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        Object object;
        FileInputStream fileIn = null;
        BufferedInputStream bufIn = null;
        ObjectInputStream objIn = null;
        try {
            fileIn = new FileInputStream(file);
            bufIn = new BufferedInputStream(fileIn);
            objIn = new ObjectInputStream(bufIn);
            object = objIn.readObject();
        }
        catch (Throwable throwable) {
            Streams.closeInputStream(objIn);
            Streams.closeInputStream(bufIn);
            Streams.closeInputStream(fileIn);
            throw throwable;
        }
        Streams.closeInputStream(objIn);
        Streams.closeInputStream(bufIn);
        Streams.closeInputStream(fileIn);
        return object;
    }

    public static Object compile(Compilable c) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        c.compileTo(objOut);
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        try {
            return objIn.readObject();
        }
        catch (ClassNotFoundException e) {
            String msg = "Compile i/o class not found exception=" + e;
            throw new IOException(msg);
        }
    }

    public static Object serializeDeserialize(Serializable s) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        objOut.writeObject(s);
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        try {
            return objIn.readObject();
        }
        catch (ClassNotFoundException e) {
            String msg = "Compile i/o class not found exception=" + e;
            throw new IOException(msg);
        }
    }
}

