/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.util.Collections;
import com.aliasi.util.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tokenizer
implements Iterable<String> {
    protected Tokenizer() {
    }

    @Override
    public Iterator<String> iterator() {
        return new TokenIterator();
    }

    public abstract String nextToken();

    public String nextWhitespace() {
        return " ";
    }

    public int lastTokenStartPosition() {
        throw new UnsupportedOperationException();
    }

    public void tokenize(List<? super String> tokens, List<? super String> whitespaces) {
        String token;
        whitespaces.add(this.nextWhitespace());
        while ((token = this.nextToken()) != null) {
            tokens.add(token.toString());
            whitespaces.add(this.nextWhitespace().toString());
        }
    }

    public String[] tokenize() {
        String token;
        ArrayList<String> tokenList = new ArrayList<String>();
        while ((token = this.nextToken()) != null) {
            tokenList.add(token);
        }
        return Collections.toStringArray(tokenList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TokenIterator
    extends Iterators.Buffered<String> {
        TokenIterator() {
        }

        @Override
        public String bufferNext() {
            return Tokenizer.this.nextToken();
        }
    }
}

