/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.Counter;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenFeatureExtractor
implements FeatureExtractor<CharSequence>,
Serializable {
    static final long serialVersionUID = -1946484959983081450L;
    private final TokenizerFactory mTokenizerFactory;

    public TokenFeatureExtractor(TokenizerFactory factory) {
        this.mTokenizerFactory = factory;
    }

    @Override
    public Map<String, Counter> features(CharSequence in) {
        ObjectToCounterMap<String> map = new ObjectToCounterMap<String>();
        char[] cs = Strings.toCharArray(in);
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
        for (String token : tokenizer) {
            map.increment(token);
        }
        return map;
    }

    private Object writeReplace() {
        return new Externalizer(this);
    }

    static class Externalizer
    extends AbstractExternalizable {
        static final long serialVersionUID = 4716086241839692672L;
        private final TokenFeatureExtractor mExtractor;

        public Externalizer() {
            this(null);
        }

        public Externalizer(TokenFeatureExtractor extractor) {
            this.mExtractor = extractor;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            TokenizerFactory factory = this.mExtractor.mTokenizerFactory;
            if (factory instanceof Compilable) {
                ((Compilable)((Object)factory)).compileTo(out);
            } else {
                out.writeObject(factory);
            }
        }

        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            TokenizerFactory factory = (TokenizerFactory)in.readObject();
            return new TokenFeatureExtractor(factory);
        }
    }
}

