/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.Tokenizer;

class CharacterTokenizer
extends Tokenizer {
    private final char[] mChars;
    private final int mLastPosition;
    private int mPosition;

    public CharacterTokenizer(char[] ch, int offset, int length) {
        this.mChars = ch;
        this.mPosition = offset;
        this.mLastPosition = offset + length;
    }

    public String nextWhitespace() {
        StringBuffer sb = new StringBuffer();
        while (this.hasMoreCharacters() && Character.isWhitespace(this.currentChar())) {
            sb.append(this.currentChar());
            ++this.mPosition;
        }
        return sb.toString();
    }

    public String nextToken() {
        this.skipWhitespace();
        if (!this.hasMoreCharacters()) {
            return null;
        }
        return new String(new char[]{this.mChars[this.mPosition++]});
    }

    private void skipWhitespace() {
        while (this.hasMoreCharacters() && Character.isWhitespace(this.currentChar())) {
            ++this.mPosition;
        }
    }

    private boolean hasMoreCharacters() {
        return this.mPosition < this.mLastPosition;
    }

    private char currentChar() {
        return this.mChars[this.mPosition];
    }
}

