/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.symbol;

import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSymbolTable
implements Compilable,
Serializable,
SymbolTable {
    final HashMap<String, Integer> mSymbolToId = new HashMap();
    final HashMap<Integer, String> mIdToSymbol = new HashMap();
    private int mNextSymbol = 0;

    public MapSymbolTable() {
        this(0);
    }

    public MapSymbolTable(int firstId) {
        this.mNextSymbol = firstId;
    }

    public Set<String> symbolSet() {
        return Collections.unmodifiableSet(this.mSymbolToId.keySet());
    }

    private MapSymbolTable(ObjectInput objIn) throws IOException {
        int numEntries = objIn.readInt();
        int max = 0;
        for (int i = 0; i < numEntries; ++i) {
            String symbol = objIn.readUTF();
            Integer id = new Integer(objIn.readInt());
            max = Math.max(max, id);
            this.mSymbolToId.put(symbol, id);
            this.mIdToSymbol.put(id, symbol);
        }
        this.mNextSymbol = max + 1;
    }

    public void writeTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    private Object writeReplace() {
        return new Externalizer(this);
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    @Override
    public int numSymbols() {
        return this.mSymbolToId.size();
    }

    @Override
    public int symbolToID(String symbol) {
        Integer result = this.symbolToIDInteger(symbol);
        return result == null ? -1 : result;
    }

    public Integer symbolToIDInteger(String symbol) {
        return this.mSymbolToId.get(symbol);
    }

    public String idToSymbol(Integer id) {
        String symbol = this.mIdToSymbol.get(id);
        if (symbol == null) {
            String msg = "Could not find id=" + id;
            throw new IndexOutOfBoundsException(msg);
        }
        return symbol;
    }

    @Override
    public String idToSymbol(int id) {
        return this.idToSymbol(new Integer(id));
    }

    @Override
    public int removeSymbol(String symbol) {
        int id = this.symbolToID(symbol);
        if (id >= 0) {
            this.mSymbolToId.remove(symbol);
            this.mIdToSymbol.remove(new Integer(id));
        }
        return id;
    }

    @Override
    public void clear() {
        this.mSymbolToId.clear();
        this.mIdToSymbol.clear();
    }

    @Override
    public int getOrAddSymbol(String symbol) {
        return this.getOrAddSymbolInteger(symbol);
    }

    public Integer getOrAddSymbolInteger(String symbol) {
        Integer id = this.mSymbolToId.get(symbol);
        if (id != null) {
            return id;
        }
        Integer freshId = new Integer(this.mNextSymbol++);
        this.mSymbolToId.put(symbol, freshId);
        this.mIdToSymbol.put(freshId, symbol);
        return freshId;
    }

    public String toString() {
        return this.mIdToSymbol.toString();
    }

    public static SymbolTable unmodifiableView(SymbolTable table) {
        return new UnmodifiableViewTable(table);
    }

    private static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = -6040616216389802649L;
        final MapSymbolTable mSymbolTable;

        public Externalizer() {
            this.mSymbolTable = null;
        }

        public Externalizer(MapSymbolTable symbolTable) {
            this.mSymbolTable = symbolTable;
        }

        public Object read(ObjectInput in) throws IOException {
            return new MapSymbolTable(in);
        }

        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeInt(this.mSymbolTable.mSymbolToId.size());
            for (Map.Entry<String, Integer> entry : this.mSymbolTable.mSymbolToId.entrySet()) {
                objOut.writeUTF(entry.getKey().toString());
                objOut.writeInt(entry.getValue());
            }
        }
    }

    private static class UnmodifiableViewTable
    implements SymbolTable {
        private final SymbolTable mSymbolTable;
        static final String UNSUPPORTED_MSG = "Cannot modify the underlying symbol table from this view.";

        UnmodifiableViewTable(SymbolTable symbolTable) {
            this.mSymbolTable = symbolTable;
        }

        public void clear() {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        public int getOrAddSymbol(String symbol) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        public int removeSymbol(String symbol) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        public String idToSymbol(int id) {
            return this.mSymbolTable.idToSymbol(id);
        }

        public int numSymbols() {
            return this.mSymbolTable.numSymbols();
        }

        public int symbolToID(String symbol) {
            return this.mSymbolTable.symbolToID(symbol);
        }
    }
}

