/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.symbol;

import com.aliasi.symbol.SymbolTable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Arrays;

class CompiledSymbolTable
implements SymbolTable {
    private final String[] mSymbols;

    public CompiledSymbolTable(String[] symbols) {
        this.mSymbols = new String[symbols.length];
        System.arraycopy(symbols, 0, this.mSymbols, 0, symbols.length);
        Arrays.sort(this.mSymbols);
    }

    public String toString() {
        return Arrays.asList(this.mSymbols).toString();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.numSymbols());
        for (int i = 0; i < this.numSymbols(); ++i) {
            String symbol = this.idToSymbol(i);
            out.writeShort(symbol.length());
            out.writeChars(symbol);
        }
    }

    void writeObj(ObjectOutput out) throws IOException {
        out.writeInt(this.numSymbols());
        for (int i = 0; i < this.numSymbols(); ++i) {
            String symbol = this.idToSymbol(i);
            out.writeShort(symbol.length());
            out.writeChars(symbol);
        }
    }

    public int symbolToID(String symbol) {
        return Arrays.binarySearch(this.mSymbols, symbol);
    }

    public String idToSymbol(int id) {
        return this.mSymbols[id];
    }

    public int numSymbols() {
        return this.mSymbols.length;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public int getOrAddSymbol(String symbol) {
        throw new UnsupportedOperationException();
    }

    public int removeSymbol(String symbol) {
        throw new UnsupportedOperationException();
    }
}

