/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.lm.CompiledNGramProcessLM;
import com.aliasi.spell.FixedWeightEditDistance;
import com.aliasi.spell.SpellChecker;
import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Compilable;
import com.aliasi.util.Iterators;
import com.aliasi.util.ObjectToSet;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.SmallSet;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledSpellChecker
implements SpellChecker {
    CompiledNGramProcessLM mLM;
    WeightedEditDistance mEditDistance;
    Set<String> mTokenSet;
    Set<String> mDoNotEditTokens = SmallSet.create();
    int mNBestSize;
    boolean mAllowInsert = true;
    boolean mAllowDelete = true;
    boolean mAllowMatch = true;
    boolean mAllowSubstitute = true;
    boolean mAllowTranspose = true;
    int mMinimumTokenLengthToCorrect = 0;
    int mNumConsecutiveInsertionsAllowed = 1;
    double mKnownTokenEditCost;
    double mFirstCharEditCost;
    double mSecondCharEditCost;
    TokenizerFactory mTokenizerFactory;
    TokenTrieNode mTokenPrefixTrie;
    public static WeightedEditDistance CASE_RESTORING = new CaseRestoring();
    public static WeightedEditDistance TOKENIZING = new Tokenizing();
    static final int DEFAULT_N_BEST_SIZE = 64;
    static final double DEFAULT_KNOWN_TOKEN_EDIT_COST = -2.0;
    static final double DEFAULT_FIRST_CHAR_EDIT_COST = -1.5;
    static final double DEFAULT_SECOND_CHAR_EDIT_COST = -1.0;

    public CompiledSpellChecker(CompiledNGramProcessLM lm, WeightedEditDistance editDistance, TokenizerFactory factory, Set<String> tokenSet, int nBestSize, double knownTokenEditCost, double firstCharEditCost, double secondCharEditCost) {
        this.mLM = lm;
        this.mEditDistance = editDistance;
        this.mTokenizerFactory = factory;
        this.mNBestSize = nBestSize;
        this.setTokenSet(tokenSet);
        this.mKnownTokenEditCost = knownTokenEditCost;
        this.mFirstCharEditCost = firstCharEditCost;
        this.mSecondCharEditCost = secondCharEditCost;
    }

    public CompiledSpellChecker(CompiledNGramProcessLM lm, WeightedEditDistance editDistance, TokenizerFactory factory, Set<String> tokenSet, int nBestSize) {
        this(lm, editDistance, factory, tokenSet, nBestSize, -2.0, -1.5, -1.0);
    }

    public CompiledSpellChecker(CompiledNGramProcessLM lm, WeightedEditDistance editDistance, Set<String> tokenSet, int nBestSize) {
        this(lm, editDistance, null, tokenSet, nBestSize);
    }

    public CompiledSpellChecker(CompiledNGramProcessLM lm, WeightedEditDistance editDistance, Set<String> tokenSet) {
        this(lm, editDistance, tokenSet, 64);
    }

    public CompiledNGramProcessLM languageModel() {
        return this.mLM;
    }

    public WeightedEditDistance editDistance() {
        return this.mEditDistance;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    public Set<String> tokenSet() {
        return Collections.unmodifiableSet(this.mTokenSet);
    }

    public Set<String> doNotEditTokens() {
        return Collections.unmodifiableSet(this.mDoNotEditTokens);
    }

    public void setDoNotEditTokens(Set<String> tokens) {
        this.mDoNotEditTokens = tokens;
    }

    public int nBestSize() {
        return this.mNBestSize;
    }

    public double knownTokenEditCost() {
        return this.mKnownTokenEditCost;
    }

    public double firstCharEditCost() {
        return this.mFirstCharEditCost;
    }

    public double secondCharEditCost() {
        return this.mSecondCharEditCost;
    }

    public void setKnownTokenEditCost(double cost) {
        this.mKnownTokenEditCost = cost;
    }

    public void setFirstCharEditCost(double cost) {
        this.mFirstCharEditCost = cost;
    }

    public void setSecondCharEditCost(double cost) {
        this.mSecondCharEditCost = cost;
    }

    public int numConsecutiveInsertionsAllowed() {
        return this.mNumConsecutiveInsertionsAllowed;
    }

    public boolean allowInsert() {
        return this.mAllowInsert;
    }

    public boolean allowDelete() {
        return this.mAllowDelete;
    }

    public boolean allowMatch() {
        return this.mAllowMatch;
    }

    public boolean allowSubstitute() {
        return this.mAllowSubstitute;
    }

    public boolean allowTranspose() {
        return this.mAllowTranspose;
    }

    public void setEditDistance(WeightedEditDistance editDistance) {
        this.mEditDistance = editDistance;
    }

    public void setMinimumTokenLengthToCorrect(int tokenCharLength) {
        if (tokenCharLength < 0) {
            String msg = "Minimum token length to correct must be >= 0. Found tokenCharLength=" + tokenCharLength;
            throw new IllegalArgumentException(msg);
        }
        this.mMinimumTokenLengthToCorrect = tokenCharLength;
    }

    public int minimumTokenLengthToCorrect() {
        return this.mMinimumTokenLengthToCorrect;
    }

    public void setLanguageModel(CompiledNGramProcessLM lm) {
        this.mLM = lm;
    }

    public void setTokenizerFactory(TokenizerFactory factory) {
        this.mTokenizerFactory = factory;
    }

    public final void setTokenSet(Set<String> tokenSet) {
        this.mTokenSet = tokenSet;
        this.mTokenPrefixTrie = tokenSet == null ? null : this.prefixTrie(tokenSet);
    }

    public void setNBest(int size) {
        if (size < 1) {
            String msg = "N-best size must be greather than 0. Found size=" + size;
            throw new IllegalArgumentException(msg);
        }
        this.mNBestSize = size;
    }

    public void setAllowInsert(boolean allowInsert) {
        this.mAllowInsert = allowInsert;
        if (!allowInsert) {
            this.setNumConsecutiveInsertionsAllowed(0);
        }
    }

    public void setAllowDelete(boolean allowDelete) {
        this.mAllowDelete = allowDelete;
    }

    public void setAllowMatch(boolean allowMatch) {
        this.mAllowMatch = allowMatch;
    }

    public void setAllowSubstitute(boolean allowSubstitute) {
        this.mAllowSubstitute = allowSubstitute;
    }

    public void setAllowTranspose(boolean allowTranspose) {
        this.mAllowTranspose = allowTranspose;
    }

    public void setNumConsecutiveInsertionsAllowed(int numAllowed) {
        if (numAllowed < 0) {
            String msg = "Num insertions allowed must be >= 0. Found numAllowed=" + numAllowed;
            throw new IllegalArgumentException(msg);
        }
        if (numAllowed > 0) {
            this.setAllowInsert(true);
        }
        this.mNumConsecutiveInsertionsAllowed = numAllowed;
    }

    @Override
    public String didYouMean(String receivedMsg) {
        String msg = this.normalizeQuery(receivedMsg);
        if (msg.length() == 0) {
            return msg;
        }
        DpSpellQueue queue = new DpSpellQueue();
        DpSpellQueue finalQueue = new DpSpellQueue();
        this.computeBestPaths(msg, queue, finalQueue);
        if (finalQueue.isEmpty()) {
            return msg;
        }
        State bestState = (State)finalQueue.pop();
        return bestState.output().trim();
    }

    void computeBestPaths(String msg, StateQueue queue, StateQueue finalQueue) {
        double[] editPenalties = this.editPenalties(msg);
        State initialState = new State(0.0, false, this.mTokenPrefixTrie, null, this.mLM.nextContext(0, ' '));
        this.addToQueue(queue, initialState, editPenalties[0]);
        DpSpellQueue nextQ = new DpSpellQueue();
        DpSpellQueue nextQ2 = new DpSpellQueue();
        for (int i = 0; i < msg.length(); ++i) {
            char c = msg.charAt(i);
            char nextC = i + 1 < msg.length() ? msg.charAt(i + 1) : (char)'\u0000';
            for (State state : queue) {
                if (i + 1 < msg.length()) {
                    this.extend2(c, nextC, state, nextQ, nextQ2, editPenalties[i]);
                    continue;
                }
                this.extend1(c, state, nextQ, editPenalties[i]);
            }
            queue = nextQ;
            nextQ = nextQ2;
            nextQ2 = new DpSpellQueue();
        }
        this.extendToFinalSpace(queue, finalQueue);
    }

    public Iterator<ScoredObject<String>> didYouMeanNBest(String receivedMsg) {
        String msg = this.normalizeQuery(receivedMsg);
        if (msg.length() == 0) {
            return new Iterators.Singleton<ScoredObject<String>>(new ScoredObject<String>("", 0.0));
        }
        NBestSpellQueue queue = new NBestSpellQueue();
        NBestSpellQueue finalQueue = new NBestSpellQueue();
        this.computeBestPaths(msg, queue, finalQueue);
        BoundedPriorityQueue<ScoredObject<String>> resultQueue = new BoundedPriorityQueue<ScoredObject<String>>(ScoredObject.SCORE_COMPARATOR, this.mNBestSize);
        for (State state : finalQueue) {
            resultQueue.add(new ScoredObject<String>(state.output().trim(), state.score()));
        }
        return resultQueue.iterator();
    }

    private boolean isShortToken(String token) {
        return token.length() <= this.mMinimumTokenLengthToCorrect;
    }

    private double[] editPenalties(String msg) {
        double[] penalties = new double[msg.length()];
        Arrays.fill(penalties, 0.0);
        if (this.mTokenSet == null) {
            return penalties;
        }
        int charPosition = 0;
        for (int i = 0; i < penalties.length; ++i) {
            char c = msg.charAt(i);
            if (this.mTokenSet != null && (i == 0 || msg.charAt(i - 1) == ' ')) {
                int j;
                String token;
                int endIndex = msg.indexOf(32, i);
                if (endIndex == -1) {
                    endIndex = msg.length();
                }
                if (this.mDoNotEditTokens.contains(token = msg.substring(i, endIndex)) || this.isShortToken(token)) {
                    if (i > 0) {
                        penalties[i - 1] = Double.NEGATIVE_INFINITY;
                    }
                    for (j = i; j < endIndex; ++j) {
                        penalties[j] = Double.NEGATIVE_INFINITY;
                    }
                    if (endIndex < penalties.length) {
                        penalties[endIndex] = Double.NEGATIVE_INFINITY;
                    }
                } else if (this.mTokenSet.contains(token)) {
                    if (i > 0) {
                        int n = i - 1;
                        penalties[n] = penalties[n] + this.mKnownTokenEditCost;
                    }
                    j = i;
                    while (j < endIndex) {
                        int n = j++;
                        penalties[n] = penalties[n] + this.mKnownTokenEditCost;
                    }
                    if (endIndex < penalties.length) {
                        int n = endIndex;
                        penalties[n] = penalties[n] + this.mKnownTokenEditCost;
                    }
                }
            }
            if (c == ' ') {
                charPosition = 0;
                int n = i;
                penalties[n] = penalties[n] + this.mFirstCharEditCost;
                continue;
            }
            if (charPosition == 0) {
                int n = i;
                penalties[n] = penalties[n] + this.mFirstCharEditCost;
                ++charPosition;
                continue;
            }
            if (charPosition != true) continue;
            int n = i;
            penalties[n] = penalties[n] + this.mSecondCharEditCost;
            ++charPosition;
        }
        return penalties;
    }

    public String parametersToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SEARCH");
        sb.append("\n  N-best size=" + this.mNBestSize);
        sb.append("\n\nTOKEN SENSITIVITY");
        sb.append("\n  Token sensitive=" + (this.mTokenSet != null));
        if (this.mTokenSet != null) {
            sb.append("\n  # Known Tokens=" + this.mTokenSet.size());
        }
        sb.append("\n\nEDITS ALLOWED");
        sb.append("\n  Allow insert=" + this.mAllowInsert);
        sb.append("\n  Allow delete=" + this.mAllowDelete);
        sb.append("\n  Allow match=" + this.mAllowMatch);
        sb.append("\n  Allow substitute=" + this.mAllowSubstitute);
        sb.append("\n  Allow transpose=" + this.mAllowTranspose);
        sb.append("\n  Num consecutive insertions allowed=" + this.mNumConsecutiveInsertionsAllowed);
        sb.append("\n  Minimum Length Token Edit=" + this.mMinimumTokenLengthToCorrect);
        sb.append("\n  # of do-not-Edit Tokens=" + this.mDoNotEditTokens.size());
        sb.append("\n\nEDIT COSTS");
        sb.append("\n  Edit Distance=" + this.mEditDistance);
        sb.append("\n  Known Token Edit Cost=" + this.mKnownTokenEditCost);
        sb.append("\n  First Char Edit Cost=" + this.mFirstCharEditCost);
        sb.append("\n  Second Char Edit Cost=" + this.mSecondCharEditCost);
        sb.append("\n\nEDIT DISTANCE\n");
        sb.append(this.mEditDistance);
        sb.append("\n\nTOKENIZER FACTORY\n");
        sb.append(this.mTokenizerFactory);
        return sb.toString();
    }

    String normalizeQuery(String query) {
        StringBuffer sb = new StringBuffer();
        if (this.mTokenizerFactory == null) {
            Strings.normalizeWhitespace(query, sb);
        } else {
            String nextToken;
            char[] cs = query.toCharArray();
            Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
            int i = 0;
            while ((nextToken = tokenizer.nextToken()) != null) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(nextToken);
                ++i;
            }
        }
        return sb.toString();
    }

    char[] observedCharacters() {
        return this.mLM.observedCharacters();
    }

    void extendToFinalSpace(StateQueue queue, StateQueue finalQueue) {
        for (State state : queue) {
            double nextScore;
            if (state.mTokenEdited && !state.tokenComplete() || (nextScore = state.mScore + this.mLM.log2Estimate(state.mContextIndex, ' ')) == Double.NEGATIVE_INFINITY) continue;
            State nextState = new State(nextScore, false, null, state, -1);
            finalQueue.addState(nextState);
        }
    }

    void extend2(char c1, char c2, State state, DpSpellQueue nextQ, DpSpellQueue nextQ2, double positionalEditPenalty) {
        this.extend1(c1, state, nextQ, positionalEditPenalty);
        if (positionalEditPenalty == Double.NEGATIVE_INFINITY) {
            return;
        }
        if (this.allowTranspose()) {
            this.transpose(c1, c2, state, nextQ2, positionalEditPenalty);
        }
    }

    void extend1(char c, State state, DpSpellQueue nextQ, double positionalEditPenalty) {
        if (this.allowMatch()) {
            this.match(c, state, nextQ, positionalEditPenalty);
        }
        if (positionalEditPenalty == Double.NEGATIVE_INFINITY) {
            return;
        }
        if (this.allowSubstitute()) {
            this.substitute(c, state, nextQ, positionalEditPenalty);
        }
        if (this.allowDelete()) {
            this.delete(c, state, nextQ, positionalEditPenalty);
        }
    }

    void addToQueue(StateQueue queue, State state, double positionalEditPenalty) {
        this.addToQueue(queue, state, 0, positionalEditPenalty);
    }

    void addToQueue(StateQueue queue, State state, int numInserts, double positionalEditPenalty) {
        if (!queue.addState(state)) {
            return;
        }
        if (numInserts >= this.mNumConsecutiveInsertionsAllowed) {
            return;
        }
        if (positionalEditPenalty == Double.NEGATIVE_INFINITY) {
            return;
        }
        this.insert(state, queue, numInserts, positionalEditPenalty);
    }

    TokenTrieNode daughter(TokenTrieNode node, char c) {
        return node == null ? null : node.daughter(c);
    }

    void match(char c, State state, DpSpellQueue nextQ, double positionalEditPenalty) {
        if (state.mTokenEdited && (c == ' ' ? !state.tokenComplete() : !state.continuedBy(c))) {
            return;
        }
        double score = state.mScore + this.mLM.log2Estimate(state.mContextIndex, c) + this.mEditDistance.matchWeight(c);
        if (score == Double.NEGATIVE_INFINITY) {
            return;
        }
        TokenTrieNode tokenTrieNode = c == ' ' ? this.mTokenPrefixTrie : this.daughter(state.mTokenTrieNode, c);
        this.addToQueue(nextQ, new State1(score, c != ' ' && state.mTokenEdited, tokenTrieNode, state, c, this.mLM.nextContext(state.mContextIndex, c)), positionalEditPenalty);
    }

    void delete(char c, State state, DpSpellQueue nextQ, double positionalEditPenalty) {
        double deleteWeight = this.mEditDistance.deleteWeight(c);
        if (deleteWeight == Double.NEGATIVE_INFINITY) {
            return;
        }
        double score = state.mScore + deleteWeight + positionalEditPenalty;
        this.addToQueue(nextQ, new State(score, true, state.mTokenTrieNode, state, state.mContextIndex), positionalEditPenalty);
    }

    void insert(State state, StateQueue nextQ, int numInserts, double positionalEditPenalty) {
        char[] followers;
        double score;
        if (state.tokenComplete() && (score = state.mScore + this.mLM.log2Estimate(state.mContextIndex, ' ') + this.mEditDistance.insertWeight(' ') + positionalEditPenalty) != Double.NEGATIVE_INFINITY) {
            this.addToQueue(nextQ, new State1(score, true, this.mTokenPrefixTrie, state, ' ', this.mLM.nextContext(state.mContextIndex, ' ')), numInserts + 1, positionalEditPenalty);
        }
        if ((followers = state.getContinuations()) == null) {
            return;
        }
        for (int i = 0; i < followers.length; ++i) {
            double score2;
            char c = followers[i];
            double insertWeight = this.mEditDistance.insertWeight(c);
            if (insertWeight == Double.NEGATIVE_INFINITY || (score2 = state.mScore + this.mLM.log2Estimate(state.mContextIndex, c) + insertWeight + positionalEditPenalty) == Double.NEGATIVE_INFINITY) continue;
            this.addToQueue(nextQ, new State1(score2, true, state.followingNode(i), state, c, this.mLM.nextContext(state.mContextIndex, c)), numInserts + 1, positionalEditPenalty);
        }
    }

    void substitute(char c, State state, StateQueue nextQ, double positionalEditPenalty) {
        char[] followers;
        double score;
        if (state.tokenComplete() && c != ' ' && (score = state.mScore + this.mLM.log2Estimate(state.mContextIndex, ' ') + this.mEditDistance.substituteWeight(c, ' ') + positionalEditPenalty) != Double.NEGATIVE_INFINITY) {
            this.addToQueue(nextQ, new State1(score, true, this.mTokenPrefixTrie, state, ' ', this.mLM.nextContext(state.mContextIndex, ' ')), positionalEditPenalty);
        }
        if ((followers = state.getContinuations()) == null) {
            return;
        }
        for (int i = 0; i < followers.length; ++i) {
            double score2;
            double substWeight;
            char c2 = followers[i];
            if (c == c2 || (substWeight = this.mEditDistance.substituteWeight(c, c2)) == Double.NEGATIVE_INFINITY || (score2 = state.mScore + this.mLM.log2Estimate(state.mContextIndex, c2) + substWeight + positionalEditPenalty) == Double.NEGATIVE_INFINITY) continue;
            this.addToQueue(nextQ, new State1(score2, true, state.followingNode(i), state, c2, this.mLM.nextContext(state.mContextIndex, c2)), positionalEditPenalty);
        }
    }

    void transpose(char c1, char c2, State state, StateQueue nextQ, double positionalEditPenalty) {
        TokenTrieNode midNode;
        double transposeWeight = this.mEditDistance.transposeWeight(c1, c2);
        if (transposeWeight == Double.NEGATIVE_INFINITY) {
            return;
        }
        if (c2 == ' ' && !state.tokenComplete()) {
            return;
        }
        TokenTrieNode tokenTrieNode = midNode = c2 == ' ' ? this.mTokenPrefixTrie : this.daughter(state.mTokenTrieNode, c2);
        if (c1 == ' ' && midNode != null && !midNode.mIsToken) {
            return;
        }
        int nextContextIndex = this.mLM.nextContext(state.mContextIndex, c2);
        int nextContextIndex2 = this.mLM.nextContext(nextContextIndex, c1);
        double score = state.mScore + this.mLM.log2Estimate(state.mContextIndex, c2) + this.mLM.log2Estimate(nextContextIndex, c1) + this.mEditDistance.transposeWeight(c1, c2) + positionalEditPenalty;
        if (score == Double.NEGATIVE_INFINITY) {
            return;
        }
        TokenTrieNode nextNode = c1 == ' ' ? this.mTokenPrefixTrie : this.daughter(midNode, c1);
        this.addToQueue(nextQ, new State2(score, true, nextNode, state, c2, c1, nextContextIndex2), positionalEditPenalty);
    }

    private static HashMap prefixToContinuations(Set<? extends CharSequence> tokens) {
        ObjectToSet<String, Character> prefixToContinuationSet = new ObjectToSet<String, Character>();
        Iterator<? extends CharSequence> tokenIt = tokens.iterator();
        while (tokenIt.hasNext()) {
            String token = ((Object)tokenIt.next()).toString();
            for (int i = 0; i < token.length(); ++i) {
                String prefix = token.substring(0, i);
                char nextChar = token.charAt(i);
                prefixToContinuationSet.addMember(prefix, new Character(nextChar));
            }
        }
        HashMap<String, char[]> prefixToContinuations = new HashMap<String, char[]>((int)(1.5 * (double)prefixToContinuationSet.size()));
        for (String prefix : prefixToContinuationSet.keySet()) {
            Set continuationSet = prefixToContinuationSet.getSet(prefix);
            char[] continuations = new char[continuationSet.size()];
            Iterator charIt = continuationSet.iterator();
            int i = 0;
            while (charIt.hasNext()) {
                continuations[i] = ((Character)charIt.next()).charValue();
                ++i;
            }
            prefixToContinuations.put(prefix, continuations);
        }
        return prefixToContinuations;
    }

    private TokenTrieNode prefixTrie(Set tokens) {
        HashMap prefixMap = CompiledSpellChecker.prefixToContinuations(tokens);
        return this.completeTrieNode("", tokens, prefixMap);
    }

    private TokenTrieNode completeTrieNode(String prefix, Set tokens, Map prefixMap) {
        char[] contChars = (char[])prefixMap.get(prefix);
        if (contChars == null) {
            contChars = com.aliasi.util.Arrays.EMPTY_CHAR_ARRAY;
        } else {
            Arrays.sort(contChars);
        }
        TokenTrieNode[] contNodes = new TokenTrieNode[contChars.length];
        for (int i = 0; i < contNodes.length; ++i) {
            contNodes[i] = this.completeTrieNode(prefix + contChars[i], tokens, prefixMap);
        }
        return new TokenTrieNode(tokens.contains(prefix), contChars, contNodes);
    }

    private static final class Tokenizing
    extends FixedWeightEditDistance
    implements Compilable {
        public Tokenizing() {
            super(0.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }

        public double insertWeight(char cInserted) {
            return cInserted == ' ' ? 0.0 : Double.NEGATIVE_INFINITY;
        }

        public void compileTo(ObjectOutput objOut) throws IOException {
            objOut.writeObject(new Externalizable());
        }

        private static class Externalizable
        extends AbstractExternalizable {
            private static final long serialVersionUID = -3015819851142009998L;

            public void writeExternal(ObjectOutput objOut) {
            }

            public Object read(ObjectInput objIn) {
                return TOKENIZING;
            }
        }
    }

    private static final class CaseRestoring
    extends FixedWeightEditDistance
    implements Compilable {
        public CaseRestoring() {
            super(0.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }

        public double substituteWeight(char cDeleted, char cInserted) {
            return Character.toLowerCase(cDeleted) == Character.toLowerCase(cInserted) ? 0.0 : Double.NEGATIVE_INFINITY;
        }

        public void compileTo(ObjectOutput objOut) throws IOException {
            objOut.writeObject(new Externalizable());
        }

        private static class Externalizable
        extends AbstractExternalizable {
            private static final long serialVersionUID = 2825384056772387737L;

            public void writeExternal(ObjectOutput objOut) {
            }

            public Object read(ObjectInput objIn) {
                return CASE_RESTORING;
            }
        }
    }

    private abstract class StateQueue
    extends BoundedPriorityQueue {
        StateQueue() {
            super(Scored.SCORE_COMPARATOR, CompiledSpellChecker.this.mNBestSize);
        }

        abstract boolean addState(State var1);
    }

    private final class NBestSpellQueue
    extends StateQueue {
        private NBestSpellQueue() {
        }

        public boolean addState(State state) {
            return this.add(state);
        }
    }

    private final class DpSpellQueue
    extends StateQueue {
        private final HashMap mStateToBest = new HashMap();

        private DpSpellQueue() {
        }

        public boolean addState(State state) {
            Integer dp = new Integer(state.mContextIndex);
            State bestState = (State)this.mStateToBest.get(dp);
            if (bestState == null) {
                this.mStateToBest.put(dp, state);
                return this.add(state);
            }
            if (bestState.mScore >= state.mScore) {
                return false;
            }
            this.remove(bestState);
            this.mStateToBest.put(dp, state);
            return this.add(state);
        }
    }

    private class State
    implements Scored {
        final TokenTrieNode mTokenTrieNode;
        final double mScore;
        final boolean mTokenEdited;
        final State mPreviousState;
        final int mContextIndex;

        State(double score, boolean tokenEdited, TokenTrieNode tokenTrieNode, State previousState, int contextIndex) {
            this.mScore = score;
            this.mTokenEdited = tokenEdited;
            this.mTokenTrieNode = tokenTrieNode;
            this.mPreviousState = previousState;
            this.mContextIndex = contextIndex;
        }

        public double score() {
            return this.mScore;
        }

        TokenTrieNode followingNode(int i) {
            return this.mTokenTrieNode == null ? null : this.mTokenTrieNode.mFollowingNodes[i];
        }

        public String toString() {
            return this.output() + "/" + this.mTokenEdited + "/" + this.mScore;
        }

        boolean tokenComplete() {
            boolean result = CompiledSpellChecker.this.mTokenSet == null || this.mTokenTrieNode != null && this.mTokenTrieNode.mIsToken;
            return result;
        }

        boolean continuedBy(char c) {
            if (this.mTokenTrieNode == null) {
                return true;
            }
            char[] continuations = this.getContinuations();
            return continuations != null && Arrays.binarySearch(continuations, c) >= 0;
        }

        char[] getContinuations() {
            return this.mTokenTrieNode == null ? CompiledSpellChecker.this.observedCharacters() : this.mTokenTrieNode.mFollowingChars;
        }

        void outputLocal(StringBuffer sb) {
        }

        String output() {
            StringBuffer sb = new StringBuffer();
            State s = this;
            while (s != null) {
                s.outputLocal(sb);
                s = s.mPreviousState;
            }
            int len = sb.length();
            char[] cs = new char[len];
            for (int i = 0; i < len; ++i) {
                cs[i] = sb.charAt(len - i - 1);
            }
            return new String(cs);
        }
    }

    private final class State2
    extends State {
        final char mChar1;
        final char mChar2;

        State2(double score, boolean tokenEdited, TokenTrieNode tokenTrieNode, State previousState, char char1, char char2, int contextIndex) {
            super(score, tokenEdited, tokenTrieNode, previousState, contextIndex);
            this.mChar1 = char1;
            this.mChar2 = char2;
        }

        void outputLocal(StringBuffer sb) {
            sb.append(this.mChar2);
            sb.append(this.mChar1);
        }
    }

    private final class State1
    extends State {
        final char mChar1;

        State1(double score, boolean tokenEdited, TokenTrieNode tokenTrieNode, State previousState, char char1, int contextIndex) {
            super(score, tokenEdited, tokenTrieNode, previousState, contextIndex);
            this.mChar1 = char1;
        }

        void outputLocal(StringBuffer sb) {
            sb.append(this.mChar1);
        }
    }

    private static final class TokenTrieNode {
        final boolean mIsToken;
        final char[] mFollowingChars;
        final TokenTrieNode[] mFollowingNodes;

        TokenTrieNode(boolean isToken, char[] followingChars, TokenTrieNode[] followingNodes) {
            this.mIsToken = isToken;
            this.mFollowingChars = followingChars;
            this.mFollowingNodes = followingNodes;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            this.toString("", sb, 0);
            return sb.toString();
        }

        void toString(String prefix, StringBuffer sb, int indent) {
            if (this.mIsToken) {
                sb.append(" [token=" + prefix + "]");
            }
            sb.append('\n');
            for (int i = 0; i < this.mFollowingChars.length; ++i) {
                for (int k = 0; k < indent; ++k) {
                    sb.append("  ");
                }
                sb.append(this.mFollowingChars[i]);
                this.mFollowingNodes[i].toString(prefix + this.mFollowingChars[i], sb, indent + 1);
            }
        }

        TokenTrieNode daughter(char c) {
            int index = Arrays.binarySearch(this.mFollowingChars, c);
            return index < 0 ? null : this.mFollowingNodes[index];
        }
    }
}

