/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.sentences;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkAndCharSeq;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingEvaluation;
import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.util.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceEvaluation {
    private final ChunkingEvaluation mChunkingEvaluation;
    private final PrecisionRecallEvaluation mEndBoundaryEvaluation;
    private final Set<ChunkAndCharSeq> mTPBoundaries = new HashSet<ChunkAndCharSeq>();
    private final Set<ChunkAndCharSeq> mFPBoundaries = new HashSet<ChunkAndCharSeq>();
    private final Set<ChunkAndCharSeq> mFNBoundaries = new HashSet<ChunkAndCharSeq>();
    private final Chunking[] mLastCase = new Chunking[2];

    public SentenceEvaluation() {
        this.mChunkingEvaluation = new ChunkingEvaluation();
        this.mEndBoundaryEvaluation = new PrecisionRecallEvaluation();
    }

    public void addCase(Chunking referenceChunking, Chunking responseChunking) {
        if (!Strings.equalCharSequence(referenceChunking.charSequence(), responseChunking.charSequence())) {
            String msg = "Underlying char sequences must have same characters. Found referenceChunking.charSequence()=" + referenceChunking.charSequence() + " responseChunking.charSequence()=" + responseChunking.charSequence();
            throw new IllegalArgumentException(msg);
        }
        SentenceEvaluation.verifySentenceTypes("reference", referenceChunking);
        SentenceEvaluation.verifySentenceTypes("response", responseChunking);
        this.mChunkingEvaluation.addCase(referenceChunking, responseChunking);
        this.mLastCase[0] = referenceChunking;
        this.mLastCase[1] = responseChunking;
        HashMap<Integer, Chunk> endChunkMap = new HashMap<Integer, Chunk>();
        CharSequence cSeq = referenceChunking.charSequence();
        for (Chunk refChunk : referenceChunking.chunkSet()) {
            Integer end = new Integer(refChunk.end());
            endChunkMap.put(end, refChunk);
        }
        for (Chunk respChunk : responseChunking.chunkSet()) {
            Integer end = new Integer(respChunk.end());
            boolean inRef = endChunkMap.containsKey(end);
            ChunkAndCharSeq ccs = new ChunkAndCharSeq(respChunk, cSeq);
            if (inRef) {
                this.mTPBoundaries.add(ccs);
                this.mEndBoundaryEvaluation.addCase(true, true);
                endChunkMap.remove(end);
                continue;
            }
            this.mFPBoundaries.add(ccs);
            this.mEndBoundaryEvaluation.addCase(false, true);
        }
        for (Chunk refChunk : endChunkMap.values()) {
            this.mFNBoundaries.add(new ChunkAndCharSeq(refChunk, cSeq));
            this.mEndBoundaryEvaluation.addCase(true, false);
        }
    }

    public ChunkingEvaluation chunkingEvaluation() {
        return this.mChunkingEvaluation;
    }

    public PrecisionRecallEvaluation endBoundaryEvaluation() {
        return this.mEndBoundaryEvaluation;
    }

    public Set<ChunkAndCharSeq> truePositiveEndBoundaries() {
        return Collections.unmodifiableSet(this.mTPBoundaries);
    }

    public Set<ChunkAndCharSeq> falsePositiveEndBoundaries() {
        return Collections.unmodifiableSet(this.mFPBoundaries);
    }

    public Set<ChunkAndCharSeq> falseNegativeEndBoundaries() {
        return Collections.unmodifiableSet(this.mFNBoundaries);
    }

    static void verifySentenceTypes(String input, Chunking chunking) {
        for (Chunk chunk : chunking.chunkSet()) {
            if (chunk.type().equals("S")) continue;
            String msg = "Chunk must have sentence type. Found type=" + chunk.type();
            throw new IllegalArgumentException(msg);
        }
    }

    public String lastCaseToString(int lineLength) {
        if (lineLength < 1) {
            String msg = "Line length must be greater than 0.";
            throw new IllegalArgumentException(msg);
        }
        if (this.mLastCase[0] == null || this.mLastCase[1] == null) {
            String msg = "No cases have been evaluated.";
            throw new IllegalStateException(msg);
        }
        return SentenceEvaluation.sentenceCaseToString(this.mLastCase[0], this.mLastCase[1], lineLength);
    }

    public static String sentenceCaseToString(Chunking referenceChunking, Chunking responseChunking, int lineLength) {
        if (lineLength < 1) {
            String msg = "Line length must be greater than 0.";
            throw new IllegalArgumentException(msg);
        }
        if (!Strings.equalCharSequence(referenceChunking.charSequence(), responseChunking.charSequence())) {
            String msg = "Underlying char sequences must have same characters. Found referenceChunking.charSequence()=" + referenceChunking.charSequence() + " responseChunking.charSequence()=" + responseChunking.charSequence();
            throw new IllegalArgumentException(msg);
        }
        SentenceEvaluation.verifySentenceTypes("reference", referenceChunking);
        SentenceEvaluation.verifySentenceTypes("response", responseChunking);
        CharSequence cSeq = referenceChunking.charSequence();
        int[] refEnds = new int[referenceChunking.chunkSet().size()];
        int iRef = 0;
        for (Chunk refChunk : referenceChunking.chunkSet()) {
            refEnds[iRef++] = refChunk.end() - 1;
        }
        int[] respEnds = new int[responseChunking.chunkSet().size()];
        int iResp = 0;
        for (Chunk respChunk : responseChunking.chunkSet()) {
            respEnds[iResp++] = respChunk.end() - 1;
        }
        StringBuffer sbOut = new StringBuffer();
        StringBuffer refLine = new StringBuffer();
        StringBuffer textLine = new StringBuffer();
        StringBuffer respLine = new StringBuffer();
        refLine.append("ref:  ");
        textLine.append("text: ");
        respLine.append("resp: ");
        int cLen = cSeq.length();
        int refIndex = 0;
        int respIndex = 0;
        for (int i = 0; i < cLen; ++i) {
            textLine.append(cSeq.charAt(i));
            if (refIndex < refEnds.length && respIndex < respEnds.length && refEnds[refIndex] == i && respEnds[respIndex] == i) {
                refLine.append("+");
                respLine.append("+");
                ++refIndex;
                ++respIndex;
            } else if (refIndex < refEnds.length && refEnds[refIndex] == i) {
                refLine.append("X");
                respLine.append("-");
                ++refIndex;
            } else if (respIndex < respEnds.length && respEnds[respIndex] == i) {
                refLine.append("-");
                respLine.append("X");
                ++respIndex;
            } else {
                refLine.append("-");
                respLine.append("-");
            }
            if (i <= 0 || i % lineLength != 0) continue;
            sbOut.append(refLine + "\n");
            sbOut.append(textLine + "\n");
            sbOut.append(respLine + "\n");
            sbOut.append("\n");
            refLine.setLength(0);
            textLine.setLength(0);
            respLine.setLength(0);
            refLine.append("ref:  ");
            textLine.append("text: ");
            respLine.append("resp: ");
        }
        sbOut.append(refLine + "\n");
        sbOut.append(textLine + "\n");
        sbOut.append(respLine + "\n");
        sbOut.append("\n\n");
        return sbOut.toString();
    }
}

