/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.sentences;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.sentences.SentenceModel;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.Strings;
import java.util.ArrayList;

public class SentenceChunker
implements Chunker {
    private final TokenizerFactory mTokenizerFactory;
    private final SentenceModel mSentenceModel;
    public static final String SENTENCE_CHUNK_TYPE = "S";

    public SentenceChunker(TokenizerFactory tf, SentenceModel sm) {
        this.mTokenizerFactory = tf;
        this.mSentenceModel = sm;
    }

    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    public Chunking chunk(char[] cs, int start, int end) {
        ArrayList tokenList = new ArrayList();
        ArrayList whiteList = new ArrayList();
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        tokenizer.tokenize(tokenList, whiteList);
        ChunkingImpl chunking = new ChunkingImpl(cs, start, end);
        if (tokenList.size() == 0) {
            return chunking;
        }
        String[] tokens = new String[tokenList.size()];
        String[] whites = new String[whiteList.size()];
        tokenList.toArray(tokens);
        whiteList.toArray(whites);
        int[] tokenStarts = new int[tokens.length];
        int[] tokenEnds = new int[tokens.length];
        int pos = whites[0].length();
        for (int i = 0; i < tokens.length; ++i) {
            tokenStarts[i] = pos;
            tokenEnds[i] = pos += tokens[i].length();
            pos += whites[i + 1].length();
        }
        int[] sentenceBoundaries = this.mSentenceModel.boundaryIndices(tokens, whites);
        if (sentenceBoundaries.length < 1) {
            return chunking;
        }
        int nextSentStart = tokenStarts[0];
        for (int i = 0; i < sentenceBoundaries.length; ++i) {
            int sentenceStart = nextSentStart;
            int endTokIdx = sentenceBoundaries[i];
            int sentenceEnd = tokenEnds[endTokIdx];
            Chunk chunk = ChunkFactory.createChunk(sentenceStart, sentenceEnd, SENTENCE_CHUNK_TYPE);
            chunking.add(chunk);
            nextSentStart = sentenceEnd + whites[endTokIdx + 1].length();
        }
        return chunking;
    }
}

