/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.sentences;

import com.aliasi.sentences.HeuristicSentenceModel;
import java.util.HashSet;

public class MedlineSentenceModel
extends HeuristicSentenceModel {
    private static final HashSet POSSIBLE_STOPS = new HashSet();
    private static final HashSet IMPOSSIBLE_PENULTIMATES;
    private static final HashSet IMPOSSIBLE_SENTENCE_STARTS;
    private static final HashSet LOWERCASE_STARTS;

    public MedlineSentenceModel() {
        super(POSSIBLE_STOPS, IMPOSSIBLE_PENULTIMATES, IMPOSSIBLE_SENTENCE_STARTS, true, true);
    }

    protected boolean possibleStart(String[] tokens, String[] whitespaces, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (LOWERCASE_STARTS.contains(tokens[i])) {
                return true;
            }
            if (this.containsDigitOrUpper(tokens[i])) {
                return true;
            }
            if (whitespaces[i + 1].length() <= 0) continue;
            return false;
        }
        return false;
    }

    private boolean containsDigitOrUpper(CharSequence token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isUpperCase(token.charAt(i))) {
                return true;
            }
            if (!Character.isDigit(token.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static {
        POSSIBLE_STOPS.add(".");
        POSSIBLE_STOPS.add("..");
        POSSIBLE_STOPS.add("!");
        POSSIBLE_STOPS.add("?");
        IMPOSSIBLE_PENULTIMATES = new HashSet();
        IMPOSSIBLE_PENULTIMATES.add("Bros");
        IMPOSSIBLE_PENULTIMATES.add("No");
        IMPOSSIBLE_PENULTIMATES.add("al");
        IMPOSSIBLE_PENULTIMATES.add("vs");
        IMPOSSIBLE_PENULTIMATES.add("etc");
        IMPOSSIBLE_PENULTIMATES.add("Fig");
        IMPOSSIBLE_PENULTIMATES.add("Dr");
        IMPOSSIBLE_PENULTIMATES.add("Prof");
        IMPOSSIBLE_PENULTIMATES.add("PhD");
        IMPOSSIBLE_PENULTIMATES.add("MD");
        IMPOSSIBLE_PENULTIMATES.add("Co");
        IMPOSSIBLE_PENULTIMATES.add("Corp");
        IMPOSSIBLE_PENULTIMATES.add("Inc");
        IMPOSSIBLE_PENULTIMATES.add("Jan");
        IMPOSSIBLE_PENULTIMATES.add("Feb");
        IMPOSSIBLE_PENULTIMATES.add("Mar");
        IMPOSSIBLE_PENULTIMATES.add("Apr");
        IMPOSSIBLE_PENULTIMATES.add("Jul");
        IMPOSSIBLE_PENULTIMATES.add("Aug");
        IMPOSSIBLE_PENULTIMATES.add("Sep");
        IMPOSSIBLE_PENULTIMATES.add("Sept");
        IMPOSSIBLE_PENULTIMATES.add("Oct");
        IMPOSSIBLE_PENULTIMATES.add("Nov");
        IMPOSSIBLE_PENULTIMATES.add("Dec");
        IMPOSSIBLE_PENULTIMATES.add("St");
        IMPOSSIBLE_PENULTIMATES.add("AM");
        IMPOSSIBLE_PENULTIMATES.add("PM");
        IMPOSSIBLE_SENTENCE_STARTS = new HashSet();
        IMPOSSIBLE_SENTENCE_STARTS.add(")");
        IMPOSSIBLE_SENTENCE_STARTS.add("]");
        IMPOSSIBLE_SENTENCE_STARTS.add("}");
        IMPOSSIBLE_SENTENCE_STARTS.add(">");
        IMPOSSIBLE_SENTENCE_STARTS.add("<");
        IMPOSSIBLE_SENTENCE_STARTS.add(".");
        IMPOSSIBLE_SENTENCE_STARTS.add("!");
        IMPOSSIBLE_SENTENCE_STARTS.add("?");
        IMPOSSIBLE_SENTENCE_STARTS.add(":");
        IMPOSSIBLE_SENTENCE_STARTS.add(";");
        IMPOSSIBLE_SENTENCE_STARTS.add("-");
        IMPOSSIBLE_SENTENCE_STARTS.add("--");
        IMPOSSIBLE_SENTENCE_STARTS.add("---");
        IMPOSSIBLE_SENTENCE_STARTS.add("%");
        LOWERCASE_STARTS = new HashSet();
        LOWERCASE_STARTS.add("alpha");
        LOWERCASE_STARTS.add("beta");
        LOWERCASE_STARTS.add("gamma");
        LOWERCASE_STARTS.add("delta");
        LOWERCASE_STARTS.add("c");
        LOWERCASE_STARTS.add("i");
        LOWERCASE_STARTS.add("ii");
        LOWERCASE_STARTS.add("iii");
        LOWERCASE_STARTS.add("iv");
        LOWERCASE_STARTS.add("v");
        LOWERCASE_STARTS.add("vi");
        LOWERCASE_STARTS.add("vii");
        LOWERCASE_STARTS.add("viii");
        LOWERCASE_STARTS.add("ix");
        LOWERCASE_STARTS.add("x");
    }
}

