/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.medline.Topic;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import java.util.ArrayList;
import java.util.Arrays;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MeshHeading {
    private final Topic[] mTopics;

    MeshHeading(Topic[] topics) {
        this.mTopics = topics;
    }

    public Topic[] topics() {
        return this.mTopics;
    }

    public Topic descriptor() {
        return this.mTopics[0];
    }

    public Topic[] qualifiers() {
        Topic[] result = new Topic[this.mTopics.length - 1];
        System.arraycopy(this.mTopics, 1, result, 0, this.mTopics.length - 1);
        return result;
    }

    public String toString() {
        return Arrays.asList(this.mTopics).toString();
    }

    static class Handler
    extends DelegateHandler {
        private final ArrayList mTopicList = new ArrayList();
        private final Topic.Handler mTopicHandler = new Topic.Handler();

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.setDelegate("DescriptorName", this.mTopicHandler);
            this.setDelegate("QualifierName", this.mTopicHandler);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.mTopicList.clear();
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("DescriptorName") || qName.equals("QualifierName")) {
                this.mTopicList.add(((Topic.Handler)handler).getTopic());
            }
        }

        public MeshHeading getMeshHeading() {
            Topic[] topics = new Topic[this.mTopicList.size()];
            this.mTopicList.toArray(topics);
            return new MeshHeading(topics);
        }
    }

    static class ListHandler
    extends DelegateHandler {
        private final Handler mMeshHeadingHandler;
        private final ArrayList mMeshHeadingList = new ArrayList();

        public ListHandler(DelegatingHandler delegator) {
            super(delegator);
            this.mMeshHeadingHandler = new Handler(delegator);
            this.setDelegate("MeshHeading", this.mMeshHeadingHandler);
        }

        public void reset() {
            this.mMeshHeadingList.clear();
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("MeshHeading")) {
                this.mMeshHeadingList.add(((Handler)handler).getMeshHeading());
            }
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.reset();
        }

        public MeshHeading[] getMeshHeadings() {
            MeshHeading[] meshHeadings = new MeshHeading[this.mMeshHeadingList.size()];
            this.mMeshHeadingList.toArray(meshHeadings);
            return meshHeadings;
        }
    }
}

