/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.corpus.XMLParser;
import com.aliasi.medline.MedlineCitation;
import com.aliasi.medline.MedlineHandler;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedlineParser
extends XMLParser<MedlineHandler> {
    private final boolean mIncludeRawXML;

    public MedlineParser(boolean includeRawXML) {
        this(null, includeRawXML);
    }

    public MedlineParser(MedlineHandler handler, boolean includeRawXML) {
        super(handler);
        this.mIncludeRawXML = includeRawXML;
    }

    public void parse(InputSource inSource, MedlineHandler handler) throws IOException, SAXException {
        this.setHandler(handler);
        this.parse(inSource);
    }

    @Override
    protected DefaultHandler getXMLHandler() {
        return new VisitingHandler((MedlineHandler)this.getHandler(), this.mIncludeRawXML);
    }

    private static class VisitingHandler
    extends DelegatingHandler {
        private final MedlineHandler mVisitor;
        private StringBuffer mXMLBuffer = new StringBuffer();
        private final boolean mSaveXML;
        private final DeletionHandler mDeletionHandler;
        private static final HashMap DTD_MAP = new HashMap();

        public VisitingHandler(MedlineHandler visitor) {
            this(visitor, true);
        }

        public VisitingHandler(MedlineHandler visitor, boolean saveXML) {
            this.mVisitor = visitor;
            this.mSaveXML = saveXML;
            this.setDelegate("MedlineCitation", new MedlineCitation.Handler(this));
            this.mDeletionHandler = new DeletionHandler(this);
            this.setDelegate("DeleteCitation", this.mDeletionHandler);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.mSaveXML) {
                if (qName.equals("MedlineCitation")) {
                    this.mXMLBuffer = new StringBuffer();
                    this.mXMLBuffer.append("<MedlineCitation");
                    this.appendAttributes(atts);
                    this.mXMLBuffer.append('>');
                } else {
                    this.mXMLBuffer.append('<');
                    this.mXMLBuffer.append(qName);
                    this.appendAttributes(atts);
                    this.mXMLBuffer.append('>');
                }
            }
            super.startElement(namespaceURI, localName, qName, atts);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.mSaveXML) {
                this.mXMLBuffer.append("</");
                this.mXMLBuffer.append(qName);
                this.mXMLBuffer.append('>');
            }
            super.endElement(namespaceURI, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mSaveXML) {
                this.appendCharacters(ch, start, length);
            }
            super.characters(ch, start, length);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (!DTD_MAP.containsKey(publicId)) {
                System.out.println("Can't find local Entity=" + publicId);
                System.out.println("Looking for systemId=" + systemId);
                return super.resolveEntity(publicId, systemId);
            }
            String fileName = DTD_MAP.get(publicId).toString();
            InputStream in = this.getClass().getResourceAsStream(fileName);
            return new InputSource(in);
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("MedlineCitation")) {
                MedlineCitation.Handler citationHandler = (MedlineCitation.Handler)handler;
                MedlineCitation citation = citationHandler.getCitation();
                if (this.mSaveXML) {
                    citation.setXMLString(this.mXMLBuffer.toString());
                }
                this.mVisitor.handle(citation);
            }
            if (qName.equals("DeleteCitation")) {
                Set deletedPmidSet = this.mDeletionHandler.deletionSet();
                Iterator it = deletedPmidSet.iterator();
                while (it.hasNext()) {
                    String pmid = it.next().toString();
                    this.mVisitor.delete(pmid);
                }
            }
        }

        private void appendAttributes(Attributes atts) {
            for (int i = 0; i < atts.getLength(); ++i) {
                this.mXMLBuffer.append(' ');
                this.mXMLBuffer.append(atts.getQName(i));
                this.mXMLBuffer.append("=\"");
                char[] cs = atts.getValue(i).toCharArray();
                this.appendCharacters(cs, 0, cs.length);
                this.mXMLBuffer.append('\"');
            }
        }

        private void appendCharacters(char[] cs, int start, int length) {
            block6: for (int i = 0; i < length; ++i) {
                char c = cs[start + i];
                switch (c) {
                    case '<': {
                        this.mXMLBuffer.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        this.mXMLBuffer.append("&gt;");
                        continue block6;
                    }
                    case '&': {
                        this.mXMLBuffer.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        this.mXMLBuffer.append("&quot;");
                        continue block6;
                    }
                    default: {
                        this.mXMLBuffer.append(c);
                    }
                }
            }
        }

        static {
            DTD_MAP.put("-//NLM//DTD Medline Citation, 1st January 2008//EN", "nlmmedline_080101.dtd");
            DTD_MAP.put("-//NLM//DTD MedlineCitation, 1st January 2008//EN", "nlmmedlinecitation_080101.dtd");
            DTD_MAP.put("-//NLM//DTD SharedCatCit, 1st January 2008//EN", "nlmsharedcatcit_080101.dtd");
            DTD_MAP.put("-//NLM//DTD Common, 1st January 2008//EN", "nlmcommon_080101.dtd");
        }
    }

    private static class DeletionHandler
    extends DelegateHandler {
        TextAccumulatorHandler mPMIDHandler = new TextAccumulatorHandler();
        Set mDeletions = new HashSet();

        public DeletionHandler(DelegatingHandler delegator) {
            super(delegator);
            this.setDelegate("PMID", this.mPMIDHandler);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.mPMIDHandler.reset();
            this.mDeletions = new HashSet();
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("PMID")) {
                this.mDeletions.add(this.mPMIDHandler.getText());
            }
        }

        public Set deletionSet() {
            return this.mDeletions;
        }
    }
}

