/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import org.xml.sax.SAXException;

public class JournalInfo {
    private final String mMedlineTA;
    private final String mCountry;
    private final String mNlmUniqueID;
    private final String mIssnLinking;

    JournalInfo(String medlineTA, String country, String nlmUniqueID, String issnLinking) {
        this.mMedlineTA = medlineTA;
        this.mCountry = country;
        this.mNlmUniqueID = nlmUniqueID;
        this.mIssnLinking = issnLinking;
    }

    public String medlineTA() {
        return this.mMedlineTA;
    }

    public String country() {
        return this.mCountry;
    }

    public String nlmUniqueID() {
        return this.mNlmUniqueID;
    }

    public String issnLinking() {
        return this.mIssnLinking;
    }

    public String toString() {
        return "{Medline TA=" + this.medlineTA() + " Country=" + this.country() + " NLM ID=" + this.nlmUniqueID() + " ISSN Linking=" + this.issnLinking() + "}";
    }

    static class Handler
    extends DelegateHandler {
        private final TextAccumulatorHandler mMedlineTAHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mCountryHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mNlmUniqueIDHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mIssnLinkingHandler = new TextAccumulatorHandler();

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.setDelegate("MedlineTA", this.mMedlineTAHandler);
            this.setDelegate("Country", this.mCountryHandler);
            this.setDelegate("NlmUniqueID", this.mNlmUniqueIDHandler);
            this.setDelegate("ISSNLinking", this.mIssnLinkingHandler);
        }

        public void startDocument() throws SAXException {
            this.mMedlineTAHandler.reset();
            this.mCountryHandler.reset();
            this.mNlmUniqueIDHandler.reset();
            this.mIssnLinkingHandler.reset();
            super.startDocument();
        }

        public JournalInfo getJournalInfo() {
            return new JournalInfo(this.mMedlineTAHandler.getText(), this.mCountryHandler.getText(), this.mNlmUniqueIDHandler.getText(), this.mIssnLinkingHandler.getText());
        }
    }
}

