/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.medline.DataBank;
import com.aliasi.util.Iterators;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBankList
implements Iterable<DataBank> {
    private final boolean mComplete;
    private final DataBank[] mDataBanks;

    DataBankList(boolean complete, DataBank[] dataBanks) {
        this.mComplete = complete;
        this.mDataBanks = dataBanks;
    }

    @Override
    public Iterator<DataBank> iterator() {
        return new Iterators.Array<DataBank>(this.mDataBanks);
    }

    public boolean complete() {
        return this.mComplete;
    }

    public DataBank[] dataBanks() {
        return this.mDataBanks;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("Complete=");
        sb.append(this.complete());
        sb.append(" DataBanks=");
        sb.append(Arrays.asList(this.dataBanks()));
        sb.append('}');
        return sb.toString();
    }

    static class Handler
    extends DelegateHandler {
        private boolean mComplete;
        private final ArrayList mDataBankList = new ArrayList();
        private final DataBank.Handler mDataBankHandler;
        private boolean mVisited;

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.mDataBankHandler = new DataBank.Handler(delegator);
            this.setDelegate("DataBank", this.mDataBankHandler);
        }

        public void reset() {
            this.mVisited = false;
            this.mDataBankList.clear();
            this.mDataBankHandler.reset();
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.reset();
            this.mVisited = true;
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("DataBank")) {
                this.mDataBankList.add(this.mDataBankHandler.getDataBank());
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            if (qName.equals("DataBankList")) {
                this.mComplete = "Y".equals(atts.getValue("CompleteYN"));
            }
        }

        public DataBankList getDataBankList() {
            if (!this.mVisited) {
                return null;
            }
            DataBank[] dataBanks = new DataBank[this.mDataBankList.size()];
            this.mDataBankList.toArray(dataBanks);
            return new DataBankList(this.mComplete, dataBanks);
        }
    }
}

