/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DataBank {
    private final String mDataBankName;
    private final String[] mAccessionNumbers;

    DataBank(String dataBankname, String[] accessionNumbers) {
        this.mDataBankName = dataBankname;
        this.mAccessionNumbers = accessionNumbers;
    }

    public String dataBankName() {
        return this.mDataBankName;
    }

    public String[] accessionNumbers() {
        return this.mAccessionNumbers;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("Data Bank Name=" + this.dataBankName());
        sb.append(" Accession Numbers=" + Arrays.asList(this.accessionNumbers()));
        sb.append('}');
        return sb.toString();
    }

    static class Handler
    extends DelegateHandler {
        private final TextAccumulatorHandler mAccessionNumberHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mDataBankNameHandler = new TextAccumulatorHandler();
        private final ArrayList mAccessionNumberList = new ArrayList();
        private boolean mVisited;

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.setDelegate("DataBankName", this.mDataBankNameHandler);
            this.setDelegate("AccessionNumber", this.mAccessionNumberHandler);
        }

        public void reset() {
            this.mVisited = false;
            this.mAccessionNumberList.clear();
            this.mDataBankNameHandler.reset();
        }

        public boolean visited() {
            return this.mVisited;
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("AccessionNumber")) {
                this.mAccessionNumberList.add(this.mAccessionNumberHandler.getText());
            }
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.reset();
            this.mVisited = true;
        }

        public DataBank getDataBank() {
            String[] accessionNumbers = new String[this.mAccessionNumberList.size()];
            this.mAccessionNumberList.toArray(accessionNumbers);
            return new DataBank(this.mDataBankNameHandler.getText(), accessionNumbers);
        }
    }
}

