/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import org.xml.sax.SAXException;

public class CommentOrCorrection {
    private final String mType;
    private final String mRefSource;
    private final String mPMID;
    private final String mNote;

    CommentOrCorrection(String type, String refSource, String pmid, String note) {
        this.mType = type;
        this.mRefSource = refSource;
        this.mPMID = pmid;
        this.mNote = note;
    }

    public String type() {
        return this.mType;
    }

    public String refSource() {
        return this.mRefSource;
    }

    public String pmid() {
        return this.mPMID;
    }

    public String note() {
        return this.mNote;
    }

    public String toString() {
        return "Type=" + this.type() + " RefSource=" + this.refSource() + " PMID=" + this.pmid() + " Note=" + this.note();
    }

    static class Handler
    extends DelegateHandler {
        private final String mType;
        private final TextAccumulatorHandler mRefSourceHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mPMIDHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mNoteHandler = new TextAccumulatorHandler();

        public Handler(String type, DelegatingHandler delegator) {
            super(delegator);
            this.mType = type;
            this.setDelegate("RefSource", this.mRefSourceHandler);
            this.setDelegate("PMID", this.mPMIDHandler);
            this.setDelegate("Note", this.mNoteHandler);
        }

        public void startDocument() throws SAXException {
            this.mRefSourceHandler.reset();
            this.mPMIDHandler.reset();
            this.mNoteHandler.reset();
            super.startDocument();
        }

        public CommentOrCorrection getCommentOrCorrection() {
            return new CommentOrCorrection(this.mType, this.mRefSourceHandler.getText(), this.mPMIDHandler.getText(), this.mNoteHandler.getText());
        }
    }
}

