/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.medline.AuthorList;
import com.aliasi.medline.PubDate;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import org.xml.sax.SAXException;

public class Book {
    private final PubDate mPubDate;
    private final String mPublisher;
    private final String mTitle;
    private final AuthorList mAuthorList;
    private final String mCollectionTitle;
    private final String mVolume;

    Book(PubDate pubDate, String publisher, String title, AuthorList authorList, String collectionTitle, String volume) {
        this.mPubDate = pubDate;
        this.mPublisher = publisher;
        this.mTitle = title;
        this.mAuthorList = authorList;
        this.mCollectionTitle = collectionTitle;
        this.mVolume = volume;
    }

    public PubDate pubDate() {
        return this.mPubDate;
    }

    public String publisher() {
        return this.mPublisher;
    }

    public String title() {
        return this.mTitle;
    }

    public AuthorList authorList() {
        return this.mAuthorList;
    }

    public String collectionTitle() {
        return this.mCollectionTitle;
    }

    public String volume() {
        return this.mVolume;
    }

    static class Handler
    extends DelegateHandler {
        private boolean mFound = false;
        private final PubDate.Handler mPubDateHandler;
        private final TextAccumulatorHandler mPublisherHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mTitleHandler = new TextAccumulatorHandler();
        private final AuthorList.Handler mAuthorListHandler;
        private final TextAccumulatorHandler mCollectionTitleHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mVolumeHandler = new TextAccumulatorHandler();

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.mPubDateHandler = new PubDate.Handler(delegator);
            this.mAuthorListHandler = new AuthorList.Handler(delegator);
            this.setDelegate("PubDate", this.mPubDateHandler);
            this.setDelegate("Publisher", this.mPublisherHandler);
            this.setDelegate("Title", this.mTitleHandler);
            this.setDelegate("AuthorList", this.mAuthorListHandler);
            this.setDelegate("CollectionTitle", this.mCollectionTitleHandler);
            this.setDelegate("Volume", this.mVolumeHandler);
        }

        public Book getBook() {
            if (!this.mFound) {
                return null;
            }
            return new Book(this.mPubDateHandler.getPubDate(), this.mPublisherHandler.getText(), this.mTitleHandler.getText(), this.mAuthorListHandler.getAuthorList(), this.mCollectionTitleHandler.getText(), this.mVolumeHandler.getText());
        }

        public void reset() {
            this.mFound = false;
            this.mPubDateHandler.reset();
            this.mPublisherHandler.reset();
            this.mTitleHandler.reset();
            this.mCollectionTitleHandler.reset();
            this.mVolumeHandler.reset();
            this.mAuthorListHandler.reset();
        }

        public boolean found() {
            return this.mFound;
        }

        public void startDocument() throws SAXException {
            this.reset();
            super.startDocument();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            this.mFound = true;
        }
    }
}

