/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.medline.Author;
import com.aliasi.util.Iterators;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorList
implements Iterable<Author> {
    private final boolean mComplete;
    private final Author[] mAuthors;

    AuthorList(boolean complete, Author[] authors) {
        this.mComplete = complete;
        this.mAuthors = authors;
    }

    @Override
    public Iterator<Author> iterator() {
        return new Iterators.Array<Author>(this.mAuthors);
    }

    public boolean complete() {
        return this.mComplete;
    }

    public Author[] authors() {
        return this.mAuthors;
    }

    public String toString() {
        return Arrays.asList(this.mAuthors) + " Complete=" + this.mComplete;
    }

    static class Handler
    extends DelegateHandler {
        private boolean mComplete;
        private final ArrayList mAuthorList = new ArrayList();
        private final Author.Handler mAuthorHandler;

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.mAuthorHandler = new Author.Handler(delegator);
            this.setDelegate("Author", this.mAuthorHandler);
        }

        public void reset() {
            this.mAuthorList.clear();
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("Author")) {
                this.mAuthorList.add(this.mAuthorHandler.getAuthor());
            }
        }

        public AuthorList getAuthorList() {
            Author[] authors = new Author[this.mAuthorList.size()];
            this.mAuthorList.toArray(authors);
            return new AuthorList(this.mComplete, authors);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("AuthorList")) {
                this.mComplete = "Y".equals(atts.getValue("CompleteYN"));
            }
            super.startElement(namespaceURI, localName, qName, atts);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.reset();
        }
    }
}

