/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.medline.Abstract;
import com.aliasi.medline.ArticleDate;
import com.aliasi.medline.AuthorList;
import com.aliasi.medline.Book;
import com.aliasi.medline.DataBankList;
import com.aliasi.medline.ELocationId;
import com.aliasi.medline.GrantList;
import com.aliasi.medline.Journal;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Article {
    private final String mPublicationModel;
    private final Journal mJournal;
    private final Book mBook;
    private final String mArticleTitle;
    private final String mPagination;
    private final ELocationId[] mELocationIds;
    private final Abstract mAbstract;
    private final String mAffiliation;
    private final AuthorList mAuthorList;
    private final String[] mLanguages;
    private final DataBankList mDataBankList;
    private final GrantList mGrantList;
    private final String[] mPublicationTypes;
    private final String mVernacularTitle;
    private final ArticleDate mArticleDate;
    private static final String AUTHORS_TRANS_MARKER = " (author's trans)";

    Article(String publicationModel, Journal journal, Book book, String articleTitle, String pagination, ELocationId[] eLocationIds, Abstract abstrct, String affiliation, AuthorList authorList, String[] languages, DataBankList dataBankList, GrantList grantList, String[] publicationTypes, String vernacularTitle, ArticleDate articleDate) {
        this.mPublicationModel = publicationModel;
        this.mJournal = journal;
        this.mBook = book;
        this.mArticleTitle = articleTitle;
        this.mPagination = pagination;
        this.mELocationIds = eLocationIds;
        this.mAbstract = abstrct;
        this.mAffiliation = affiliation;
        this.mAuthorList = authorList;
        this.mLanguages = languages;
        this.mDataBankList = dataBankList;
        this.mGrantList = grantList;
        this.mPublicationTypes = publicationTypes;
        this.mVernacularTitle = vernacularTitle;
        this.mArticleDate = articleDate;
    }

    public String publicationModel() {
        return this.mPublicationModel;
    }

    public String pagination() {
        return this.mPagination;
    }

    public ELocationId[] eLocationIds() {
        return this.mELocationIds;
    }

    public Journal journal() {
        return this.mJournal;
    }

    public Book book() {
        return this.mBook;
    }

    public boolean inBook() {
        return this.mBook != null;
    }

    public boolean inJournal() {
        return this.mJournal != null;
    }

    public Object in() {
        if (this.inBook()) {
            return this.book();
        }
        return this.journal();
    }

    public String articleTitle() {
        return this.mArticleTitle;
    }

    public boolean articleTranslated() {
        return this.articleTitle().length() > 1 && this.articleTitle().charAt(0) == '[' && this.articleTitle().charAt(this.articleTitle().length() - 1) == ']';
    }

    public String articleTitleText() {
        if (!this.articleTranslated()) {
            return this.articleTitle();
        }
        String baseText = this.articleTitle().substring(1, this.articleTitle().length() - 1);
        if (baseText.endsWith(AUTHORS_TRANS_MARKER)) {
            return baseText.substring(0, baseText.length() - AUTHORS_TRANS_MARKER.length());
        }
        return baseText;
    }

    public Abstract abstrct() {
        return this.mAbstract;
    }

    public AuthorList authorList() {
        return this.mAuthorList;
    }

    public String affiliation() {
        return this.mAffiliation;
    }

    public String[] languages() {
        return this.mLanguages;
    }

    public DataBankList dataBankList() {
        return this.mDataBankList;
    }

    public GrantList grantList() {
        return this.mGrantList;
    }

    public String[] publicationTypes() {
        return this.mPublicationTypes;
    }

    public String vernacularTitle() {
        return this.mVernacularTitle;
    }

    public ArticleDate articleDate() {
        return this.mArticleDate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("Title=");
        sb.append(this.articleTitle());
        sb.append(" Authors=");
        sb.append(this.authorList());
        sb.append(" Publication Model=");
        sb.append(this.publicationModel());
        if (this.inJournal()) {
            sb.append(" Journal=" + this.journal());
        } else {
            sb.append(" Book=" + this.book());
        }
        if (this.pagination().length() > 0) {
            sb.append(" Pagination=" + this.pagination());
        }
        if (this.abstrct() != null && this.abstrct().text().length() > 0) {
            sb.append(" Abstract=");
            sb.append(this.abstrct());
        }
        if (this.affiliation().length() > 0) {
            sb.append(" Affiliation=");
            sb.append(this.affiliation());
        }
        sb.append(" Languages=");
        sb.append(Arrays.asList(this.languages()));
        if (this.dataBankList() != null) {
            sb.append(" Data Banks=");
            sb.append(this.dataBankList());
        }
        if (this.grantList() != null) {
            sb.append(" Grant List=");
            sb.append(this.grantList());
        }
        if (this.publicationTypes().length > 0) {
            sb.append(" Publication Types=");
            sb.append(Arrays.asList(this.publicationTypes()));
        }
        if (this.vernacularTitle() != null && this.vernacularTitle().length() > 0) {
            sb.append(" Vernacular Title=");
            sb.append(this.vernacularTitle());
        }
        if (this.articleDate() != null) {
            sb.append(" Electronic Article Pub Date=");
            sb.append(this.articleDate());
        }
        sb.append('}');
        return sb.toString();
    }

    static class Handler
    extends DelegateHandler {
        private String mPublicationModel;
        private final Journal.Handler mJournalHandler;
        private final Book.Handler mBookHandler;
        private final TextAccumulatorHandler mArticleTitleHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mMedlinePaginationHandler = new TextAccumulatorHandler();
        private final Abstract.Handler mAbstractHandler;
        private final TextAccumulatorHandler mAffiliationHandler = new TextAccumulatorHandler();
        String mPagination;
        private final ELocationId.Handler mELocationIdHandler = new ELocationId.Handler();
        private final List<ELocationId> mELocationIdList = new ArrayList<ELocationId>();
        private final TextAccumulatorHandler mStartPageHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mEndPageHandler = new TextAccumulatorHandler();
        private final AuthorList.Handler mAuthorListHandler;
        private final ArrayList mLanguageList = new ArrayList();
        private final TextAccumulatorHandler mLanguageHandler = new TextAccumulatorHandler();
        private final DataBankList.Handler mDataBankListHandler;
        private final GrantList.Handler mGrantListHandler;
        private final ArrayList mPublicationTypeList = new ArrayList();
        private final TextAccumulatorHandler mPublicationTypeHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mVernacularTitleHandler = new TextAccumulatorHandler();
        private final ArticleDate.Handler mArticleDateHandler;

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.mJournalHandler = new Journal.Handler(delegator);
            this.mBookHandler = new Book.Handler(delegator);
            this.mAbstractHandler = new Abstract.Handler(delegator);
            this.mAuthorListHandler = new AuthorList.Handler(delegator);
            this.mDataBankListHandler = new DataBankList.Handler(delegator);
            this.mGrantListHandler = new GrantList.Handler(delegator);
            this.mArticleDateHandler = new ArticleDate.Handler(delegator);
            this.setDelegate("Journal", this.mJournalHandler);
            this.setDelegate("Book", this.mBookHandler);
            this.setDelegate("ArticleTitle", this.mArticleTitleHandler);
            this.setDelegate("MedlinePgn", this.mMedlinePaginationHandler);
            this.setDelegate("ELocationId", this.mELocationIdHandler);
            this.setDelegate("StartPage", this.mStartPageHandler);
            this.setDelegate("EndPage", this.mEndPageHandler);
            this.setDelegate("Abstract", this.mAbstractHandler);
            this.setDelegate("Affiliation", this.mAffiliationHandler);
            this.setDelegate("AuthorList", this.mAuthorListHandler);
            this.setDelegate("Language", this.mLanguageHandler);
            this.setDelegate("DataBankList", this.mDataBankListHandler);
            this.setDelegate("GrantList", this.mGrantListHandler);
            this.setDelegate("PublicationType", this.mPublicationTypeHandler);
            this.setDelegate("VernacularTitle", this.mVernacularTitleHandler);
            this.setDelegate("ElectronicPubDate", this.mArticleDateHandler);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.mJournalHandler.reset();
            this.mBookHandler.reset();
            this.mArticleTitleHandler.reset();
            this.mMedlinePaginationHandler.reset();
            this.mPagination = null;
            this.mStartPageHandler.reset();
            this.mEndPageHandler.reset();
            this.mAbstractHandler.reset();
            this.mAffiliationHandler.reset();
            this.mAuthorListHandler.reset();
            this.mLanguageList.clear();
            this.mDataBankListHandler.reset();
            this.mGrantListHandler.reset();
            this.mPublicationTypeList.clear();
            this.mVernacularTitleHandler.reset();
            this.mArticleDateHandler.reset();
            this.mELocationIdList.clear();
            super.startDocument();
        }

        public void startElement(String x, String y, String qName, Attributes atts) throws SAXException {
            if (qName.equals("Article")) {
                this.mPublicationModel = atts.getValue("PubModel");
            }
            super.startElement(x, y, qName, atts);
        }

        public Article getArticle() {
            String[] languages = new String[this.mLanguageList.size()];
            this.mLanguageList.toArray(languages);
            String[] publicationTypes = new String[this.mPublicationTypeList.size()];
            this.mPublicationTypeList.toArray(publicationTypes);
            ELocationId[] eLocationIds = new ELocationId[this.mELocationIdList.size()];
            this.mELocationIdList.toArray(eLocationIds);
            return new Article(this.mPublicationModel, this.mJournalHandler.getJournal(), this.mBookHandler.getBook(), this.mArticleTitleHandler.getText(), this.mPagination, eLocationIds, this.mAbstractHandler.getAbstract(), this.mAffiliationHandler.getText(), this.mAuthorListHandler.getAuthorList(), languages, this.mDataBankListHandler.getDataBankList(), this.mGrantListHandler.getGrantList(), publicationTypes, this.mVernacularTitleHandler.getText(), this.mArticleDateHandler.getArticleDate());
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("MedlinePgn")) {
                this.mPagination = this.mMedlinePaginationHandler.getText();
            } else if (qName.equals("StartPage")) {
                this.mPagination = this.mStartPageHandler.getText();
            } else if (qName.equals("EndPage")) {
                this.mPagination = this.mPagination.length() > 0 ? this.mPagination + "-" + this.mEndPageHandler.getText() : this.mEndPageHandler.getText();
            } else if (qName.equals("Language")) {
                this.mLanguageList.add(this.mLanguageHandler.getText());
            } else if (qName.equals("PublicationType")) {
                this.mPublicationTypeList.add(this.mPublicationTypeHandler.getText());
            } else if (qName.equals("ELocationId")) {
                this.mELocationIdList.add(this.mELocationIdHandler.getELocationId());
            }
        }
    }
}

