/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import org.xml.sax.SAXException;

public class Abstract {
    private static final String TRUNCATION_MARKER_250 = "(ABSTRACT TRUNCATED AT 250 WORDS)";
    private static final String TRUNCATION_MARKER_400 = "(ABSTRACT TRUNCATED AT 400 WORDS)";
    private static final String TRUNCATION_MARKER_4096 = "(ABSTRACT TRUNCATED)";
    private static final String[] TRUNCATION_MARKERS = new String[]{"(ABSTRACT TRUNCATED AT 250 WORDS)", "(ABSTRACT TRUNCATED AT 400 WORDS)", "(ABSTRACT TRUNCATED)"};
    private final String mText;
    private final String mCopyrightInformation;

    Abstract(String text, String copyrightInformation) {
        this.mText = text;
        this.mCopyrightInformation = copyrightInformation;
    }

    public String text() {
        return this.mText;
    }

    public boolean isTruncated() {
        for (int i = 0; i < TRUNCATION_MARKERS.length; ++i) {
            if (!this.text().endsWith(TRUNCATION_MARKERS[i])) continue;
            return true;
        }
        return false;
    }

    public String textWithoutTruncationMarker() {
        return Abstract.textWithoutTruncationMarker(this.text());
    }

    public static String textWithoutTruncationMarker(String text) {
        String trimmedText = text.trim();
        for (int i = 0; i < TRUNCATION_MARKERS.length; ++i) {
            if (!trimmedText.endsWith(TRUNCATION_MARKERS[i])) continue;
            return trimmedText.substring(0, trimmedText.length() - TRUNCATION_MARKERS[i].length());
        }
        return trimmedText;
    }

    public String copyrightInformation() {
        return this.mCopyrightInformation;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("Text=");
        sb.append(this.text());
        if (this.copyrightInformation().length() > 0) {
            sb.append(" Copyright Information=");
            sb.append(this.copyrightInformation());
        }
        sb.append('}');
        return sb.toString();
    }

    static class Handler
    extends DelegateHandler {
        private final TextAccumulatorHandler mTextHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mCopyrightInformationHandler = new TextAccumulatorHandler();

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.setDelegate("AbstractText", this.mTextHandler);
            this.setDelegate("CopyrightInformation", this.mCopyrightInformationHandler);
        }

        public void reset() {
            this.mTextHandler.reset();
            this.mCopyrightInformationHandler.reset();
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.reset();
        }

        public Abstract getAbstract() {
            return new Abstract(this.mTextHandler.getText(), this.mCopyrightInformationHandler.getText());
        }
    }
}

