/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.Matrix;
import com.aliasi.matrix.Vector;

public class Matrices {
    private Matrices() {
    }

    public static Vector unmodifiableVector(Vector v) {
        return new UnmodifiableVector(v);
    }

    public static boolean hasZeroDiagonal(Matrix m) {
        int n = m.numRows();
        if (n != m.numColumns()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (m.value(i, i) == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSymmetric(Matrix m) {
        int n = m.numRows();
        if (n != m.numColumns()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (m.value(i, j) == m.value(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNonNegative(Matrix m) {
        for (int i = 0; i < m.numRows(); ++i) {
            for (int j = 0; j < m.numColumns(); ++j) {
                if (!(m.value(i, j) < 0.0) && !Double.isNaN(m.value(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public static double[] toArray(Vector v) {
        double[] xs = new double[v.numDimensions()];
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = v.value(i);
        }
        return xs;
    }

    static Vector add(Vector v1, Vector v2) {
        int numDimensions = v1.numDimensions();
        if (numDimensions != v2.numDimensions()) {
            String msg = "Can only add vectors of the same dimensionality. Found v1.numDimensions()=" + v1.numDimensions() + " v2.numDimensions()=" + v2.numDimensions();
            throw new IllegalArgumentException(msg);
        }
        double[] vals = new double[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            vals[i] = v1.value(i) + v2.value(i);
        }
        return new DenseVector(vals);
    }

    static class VectorFilter
    implements Vector {
        private final Vector mV;

        VectorFilter(Vector v) {
            this.mV = v;
        }

        public int[] nonZeroDimensions() {
            return this.mV.nonZeroDimensions();
        }

        public void increment(double scale, Vector v) {
            this.mV.increment(scale, v);
        }

        public Vector add(Vector v) {
            return this.mV.add(v);
        }

        public double cosine(Vector v) {
            return this.mV.cosine(v);
        }

        public double dotProduct(Vector v) {
            return this.mV.dotProduct(v);
        }

        public boolean equals(Object that) {
            return ((Object)this.mV).equals(that);
        }

        public int hashCode() {
            return ((Object)this.mV).hashCode();
        }

        public double length() {
            return this.mV.length();
        }

        public int numDimensions() {
            return this.mV.numDimensions();
        }

        public void setValue(int dimension, double value) {
            this.mV.setValue(dimension, value);
        }

        public double value(int dimension) {
            return this.mV.value(dimension);
        }
    }

    static class UnmodifiableVector
    extends VectorFilter {
        UnmodifiableVector(Vector v) {
            super(v);
        }

        public void setValue(int dimension, double value) {
            String msg = "Cannot modify an unmodifiable vector.";
            throw new UnsupportedOperationException(msg);
        }
    }
}

