/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.AbstractVector;
import com.aliasi.matrix.Matrices;
import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.Vector;
import java.util.Arrays;

public class DenseVector
extends AbstractVector {
    static final boolean IGNORE = true;
    private final double[] mValues;

    public DenseVector(int numDimensions) {
        this(DenseVector.zeroValues(numDimensions), true);
        if (numDimensions < 1) {
            String msg = "Require positive number of dimensions. Found numDimensions=" + numDimensions;
            throw new IllegalArgumentException(msg);
        }
    }

    public DenseVector(double[] values) {
        this(DenseVector.copyValues(values), true);
        if (values.length < 1) {
            String msg = "Vectors must have positive length. Found length=" + values.length;
            throw new IllegalArgumentException(msg);
        }
    }

    public DenseVector(DenseVector v) {
        this(v.mValues);
    }

    DenseVector(double[] values, boolean ignore) {
        this.mValues = values;
    }

    public void setValue(int dimension, double value) {
        this.mValues[dimension] = value;
    }

    public int numDimensions() {
        return this.mValues.length;
    }

    public void increment(double scale, Vector v) {
        if (v instanceof SparseFloatVector) {
            int[] nonZeroDims = v.nonZeroDimensions();
            for (int i = 0; i < nonZeroDims.length; ++i) {
                int dim;
                int n = dim = nonZeroDims[i];
                this.mValues[n] = this.mValues[n] + scale * v.value(dim);
            }
        } else {
            for (int i = 0; i < this.mValues.length; ++i) {
                int n = i;
                this.mValues[n] = this.mValues[n] + scale * v.value(i);
            }
        }
    }

    public Vector add(Vector v) {
        return Matrices.add(this, v);
    }

    public double value(int dimension) {
        return this.mValues[dimension];
    }

    private static double[] zeroValues(int n) {
        double[] xs = new double[n];
        Arrays.fill(xs, 0.0);
        return xs;
    }

    private static double[] copyValues(double[] values) {
        double[] xs = new double[values.length];
        System.arraycopy(values, 0, xs, 0, xs.length);
        return xs;
    }
}

