/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.TrieReader;
import java.io.IOException;
import java.util.Stack;

public class MultiTrieReader
implements TrieReader {
    private final Stack mStack1 = new Stack();
    private final Stack mStack2 = new Stack();
    private final TrieReader mReader1;
    private final TrieReader mReader2;
    private boolean mNotInitialized = true;

    public MultiTrieReader(TrieReader reader1, TrieReader reader2) {
        this.mReader1 = reader1;
        this.mReader2 = reader2;
    }

    public long readSymbol() throws IOException {
        if (this.mStack1.size() > this.mStack2.size()) {
            long symbol = MultiTrieReader.peek(this.mStack1);
            if (symbol == -1L) {
                this.mStack1.pop();
                MultiTrieReader.replace(this.mStack1, this.mReader1);
            } else {
                MultiTrieReader.replace(this.mStack1, -2L);
            }
            return symbol;
        }
        if (this.mStack1.size() < this.mStack2.size()) {
            long symbol = MultiTrieReader.peek(this.mStack2);
            if (symbol == -1L) {
                this.mStack2.pop();
                MultiTrieReader.replace(this.mStack2, this.mReader2);
            } else {
                MultiTrieReader.replace(this.mStack2, -2L);
            }
            return symbol;
        }
        long top1 = MultiTrieReader.peek(this.mStack1);
        long top2 = MultiTrieReader.peek(this.mStack2);
        if (top1 == -1L && top2 == -1L) {
            this.mStack1.pop();
            MultiTrieReader.replace(this.mStack1, this.mReader1);
            this.mStack2.pop();
            MultiTrieReader.replace(this.mStack2, this.mReader2);
            return -1L;
        }
        if (top2 == -1L || top1 != -1L && top1 < top2) {
            MultiTrieReader.replace(this.mStack1, -2L);
            return top1;
        }
        if (top1 == -1L || top2 != -1L && top2 < top1) {
            MultiTrieReader.replace(this.mStack2, -2L);
            return top2;
        }
        MultiTrieReader.replace(this.mStack1, -2L);
        MultiTrieReader.replace(this.mStack2, -2L);
        return top1;
    }

    public long readCount() throws IOException {
        if (this.mNotInitialized) {
            this.mNotInitialized = false;
            long count = this.mReader1.readCount() + this.mReader2.readCount();
            MultiTrieReader.push(this.mStack1, this.mReader1.readSymbol());
            MultiTrieReader.push(this.mStack2, this.mReader2.readSymbol());
            return count;
        }
        if (this.mStack1.size() > this.mStack2.size()) {
            long count = this.mReader1.readCount();
            MultiTrieReader.push(this.mStack1, this.mReader1.readSymbol());
            return count;
        }
        if (this.mStack1.size() < this.mStack2.size()) {
            long count = this.mReader2.readCount();
            MultiTrieReader.push(this.mStack2, this.mReader2.readSymbol());
            return count;
        }
        if (MultiTrieReader.peek(this.mStack1) == -2L && MultiTrieReader.peek(this.mStack2) == -2L) {
            long count = this.mReader1.readCount() + this.mReader2.readCount();
            MultiTrieReader.push(this.mStack1, this.mReader1.readSymbol());
            MultiTrieReader.push(this.mStack2, this.mReader2.readSymbol());
            return count;
        }
        if (MultiTrieReader.peek(this.mStack1) == -2L) {
            long count = this.mReader1.readCount();
            MultiTrieReader.push(this.mStack1, this.mReader1.readSymbol());
            return count;
        }
        if (MultiTrieReader.peek(this.mStack2) == -2L) {
            long count = this.mReader2.readCount();
            MultiTrieReader.push(this.mStack2, this.mReader2.readSymbol());
            return count;
        }
        throw new IllegalStateException("readCount(): Stack1=" + this.mStack1 + " Stack2=" + this.mStack2);
    }

    static long peek(Stack stack) {
        return (Long)stack.peek();
    }

    static void push(Stack stack, long x) {
        stack.push(new Long(x));
    }

    static long pop(Stack stack) {
        return (Long)stack.pop();
    }

    static void replace(Stack stack, TrieReader reader) throws IOException {
        if (stack.size() > 0) {
            MultiTrieReader.replace(stack, reader.readSymbol());
        }
    }

    static void replace(Stack stack, long x) {
        if (stack.size() == 0) {
            return;
        }
        MultiTrieReader.pop(stack);
        stack.push(new Long(x));
    }
}

