/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.AbstractNode;
import com.aliasi.lm.DtrMap;
import com.aliasi.lm.DtrMap0;
import com.aliasi.lm.DtrMap1;
import com.aliasi.symbol.SymbolTable;
import java.util.List;

class IntNode {
    int mCount;
    long mExtCount;
    DtrMap mDtrs;
    static final int[] EMPTY_INT_ARRAY = new int[0];

    IntNode() {
        this.mCount = 0;
        this.mExtCount = 0L;
        this.mDtrs = DtrMap0.EMPTY_DTR_MAP;
    }

    IntNode(int[] toks, int start, int end) {
        this.mCount = 1;
        if (start == end) {
            this.mDtrs = DtrMap0.EMPTY_DTR_MAP;
            this.mExtCount = 0L;
            return;
        }
        this.mExtCount = 1L;
        int tok = toks[start];
        IntNode dtr = new IntNode(toks, start + 1, end);
        this.mDtrs = new DtrMap1(tok, dtr);
    }

    IntNode(int[] toks, int start, int end, int count) {
        this.mCount = count;
        if (start == end) {
            this.mDtrs = DtrMap0.EMPTY_DTR_MAP;
            this.mExtCount = 0L;
            return;
        }
        this.mExtCount = count;
        int tok = toks[start];
        IntNode dtr = new IntNode(toks, start + 1, end, count);
        this.mDtrs = new DtrMap1(tok, dtr);
    }

    IntNode(int[] toks, int start, int end, int count, boolean incrementPath) {
        if (incrementPath) {
            throw new IllegalArgumentException("require true");
        }
        if (start == end) {
            this.mCount = count;
            this.mDtrs = DtrMap0.EMPTY_DTR_MAP;
            this.mExtCount = 0L;
            return;
        }
        this.mCount = 0;
        this.mExtCount = start + 1 == end ? (long)count : 0L;
        int tok = toks[start];
        IntNode dtr = new IntNode(toks, start + 1, end, count, incrementPath);
        this.mDtrs = new DtrMap1(tok, dtr);
    }

    public void prune(int minCount) {
        this.mDtrs = this.mDtrs.prune(minCount);
        this.mExtCount = this.mDtrs.extensionCount();
    }

    public void rescale(double countMultiplier) {
        this.mCount = (int)(countMultiplier * (double)this.mCount);
        this.mDtrs = this.mDtrs.rescale(countMultiplier);
        this.mExtCount = this.mDtrs.extensionCount();
    }

    public static String idToSymbol(int id, SymbolTable st) {
        if (id == -2) {
            return "EOS";
        }
        if (id == -1) {
            return "UNK";
        }
        return st.idToSymbol(id);
    }

    int trieSize() {
        return 1 + this.mDtrs.dtrsTrieSize();
    }

    void decrement(int symbol) {
        IntNode dtr = this.mDtrs.getDtr(symbol);
        if (dtr == null) {
            String msg = "symbol doesn't exist=" + symbol;
            throw new IllegalArgumentException(msg);
        }
        if (this.mCount <= 0) {
            String msg = "Cannot decrement below zero.";
            throw new IllegalArgumentException(msg);
        }
        if (this.mExtCount < 1L) {
            String msg = "Cannot decrement extensions below zero.";
            throw new IllegalArgumentException(msg);
        }
        --this.mCount;
        --this.mExtCount;
        dtr.decrement();
    }

    private void decrement() {
        if (this.mCount == 0) {
            String msg = "Cannot decrement below 0.";
            throw new IllegalArgumentException(msg);
        }
        --this.mCount;
    }

    void decrement(int symbol, int count) {
        IntNode dtr = this.mDtrs.getDtr(symbol);
        if (dtr == null) {
            String msg = "symbol doesn't exist=" + symbol;
            throw new IllegalArgumentException(msg);
        }
        if (this.mCount - count < 0) {
            String msg = "Cannot decrement below zero. Count=" + this.mCount + " decrement=" + count;
            throw new IllegalArgumentException(msg);
        }
        if (this.mExtCount - (long)count < 0L) {
            String msg = "Cannot decrement extension count below zero. Ext count=" + this.mExtCount + " decrement=" + count;
            throw new IllegalArgumentException(msg);
        }
        this.mCount -= count;
        this.mExtCount -= (long)count;
        dtr.decrementCount(count);
    }

    private void decrementCount(int count) {
        if (this.mCount - count < 0) {
            String msg = "Cannot decrement below 0. Count=" + this.mCount + " decrement=" + count;
            throw new IllegalArgumentException(msg);
        }
        this.mCount -= count;
    }

    int count() {
        return this.mCount;
    }

    void addDaughters(List queue) {
        this.mDtrs.addDtrs(queue);
    }

    long extensionCount() {
        return this.mExtCount;
    }

    int numExtensions() {
        return this.mDtrs.numExtensions();
    }

    int[] integersFollowing() {
        return this.mDtrs.integersFollowing();
    }

    int[] integersFollowing(int[] is, int start, int end) {
        IntNode dtr = this.getDtr(is, start, end);
        if (dtr == null) {
            return EMPTY_INT_ARRAY;
        }
        return dtr.integersFollowing();
    }

    int[] observedIntegers() {
        return this.integersFollowing(EMPTY_INT_ARRAY, 0, 0);
    }

    void incrementSequence(int[] tokIndices, int start, int end, int count) {
        DtrMap newDtrs;
        if (start == end) {
            this.mCount += count;
            return;
        }
        if (start + 1 == end) {
            this.mExtCount += (long)count;
        }
        if (!(newDtrs = this.mDtrs.incrementSequence(tokIndices, start, end, count)).equals(this.mDtrs)) {
            this.mDtrs = newDtrs;
        }
    }

    void increment(int[] tokIndices, int start, int end) {
        ++this.mCount;
        if (start == end) {
            return;
        }
        ++this.mExtCount;
        DtrMap newDtrs = this.mDtrs.incrementDtrs(tokIndices, start, end);
        if (!newDtrs.equals(this.mDtrs)) {
            this.mDtrs = newDtrs;
        }
    }

    void increment(int[] tokIndices, int start, int end, int count) {
        this.mCount += count;
        if (start == end) {
            return;
        }
        this.mExtCount += (long)count;
        DtrMap newDtrs = this.mDtrs.incrementDtrs(tokIndices, start, end, count);
        if (!newDtrs.equals(this.mDtrs)) {
            this.mDtrs = newDtrs;
        }
    }

    IntNode getDtr(int[] toks, int start, int end) {
        if (start == end) {
            return this;
        }
        IntNode dtr = this.mDtrs.getDtr(toks[start]);
        if (dtr == null) {
            return null;
        }
        return dtr.getDtr(toks, start + 1, end);
    }

    public String toString(SymbolTable st) {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, 0, st);
        return sb.toString();
    }

    public void toString(StringBuffer sb, int depth, SymbolTable st) {
        sb.append(this.count());
        AbstractNode.indent(sb, depth);
        this.mDtrs.toString(sb, depth, st);
    }
}

