/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.AbstractNode;
import com.aliasi.lm.DtrMap;
import com.aliasi.lm.DtrMap0;
import com.aliasi.lm.DtrMap1;
import com.aliasi.lm.DtrMapMap;
import com.aliasi.lm.IntNode;
import com.aliasi.symbol.SymbolTable;
import java.util.List;

class DtrMap2
implements DtrMap {
    final int mTok1;
    final int mTok2;
    IntNode mDtr1;
    IntNode mDtr2;

    public DtrMap2(int tok1, int tok2, IntNode dtr1, IntNode dtr2) {
        this.mTok1 = tok1;
        this.mDtr1 = dtr1;
        this.mTok2 = tok2;
        this.mDtr2 = dtr2;
    }

    public DtrMap prune(int minCount) {
        if (this.mDtr1.count() < minCount) {
            if (this.mDtr2.count() < minCount) {
                return DtrMap0.EMPTY_DTR_MAP;
            }
            this.mDtr2.prune(minCount);
            return new DtrMap1(this.mTok2, this.mDtr2);
        }
        this.mDtr1.prune(minCount);
        if (this.mDtr2.count() < minCount) {
            return new DtrMap1(this.mTok1, this.mDtr1);
        }
        this.mDtr2.prune(minCount);
        return this;
    }

    public DtrMap rescale(double countMultiplier) {
        this.mDtr1.rescale(countMultiplier);
        this.mDtr2.rescale(countMultiplier);
        if (this.mDtr1.count() == 0) {
            if (this.mDtr2.count() == 0) {
                return DtrMap0.EMPTY_DTR_MAP;
            }
            return new DtrMap1(this.mTok2, this.mDtr2);
        }
        if (this.mDtr2.count() == 0) {
            return new DtrMap1(this.mTok1, this.mDtr1);
        }
        return this;
    }

    public int numExtensions() {
        return 2;
    }

    public void toString(StringBuffer sb, int depth, SymbolTable st) {
        if (st != null) {
            sb.append(IntNode.idToSymbol(this.mTok1, st));
        } else {
            sb.append(this.mTok1);
        }
        sb.append(": ");
        this.mDtr1.toString(sb, depth + 1, st);
        AbstractNode.indent(sb, depth);
        if (st != null) {
            sb.append(IntNode.idToSymbol(this.mTok2, st));
        } else {
            sb.append(this.mTok2);
        }
        sb.append(": ");
        this.mDtr2.toString(sb, depth + 1, st);
    }

    public void addDtrs(List queue) {
        queue.add(this.mDtr1);
        queue.add(this.mDtr2);
    }

    public int dtrsTrieSize() {
        return this.mDtr1.trieSize() + this.mDtr2.trieSize();
    }

    public IntNode getDtr(int tok) {
        if (tok == this.mTok1) {
            return this.mDtr1;
        }
        if (tok == this.mTok2) {
            return this.mDtr2;
        }
        return null;
    }

    public DtrMap incrementDtrs(int[] tokIndices, int start, int end) {
        if (start == end) {
            return this;
        }
        int tok = tokIndices[start];
        if (tok == this.mTok1) {
            this.mDtr1.increment(tokIndices, start + 1, end);
            return this;
        }
        if (tok == this.mTok2) {
            this.mDtr2.increment(tokIndices, start + 1, end);
            return this;
        }
        IntNode dtr = new IntNode(tokIndices, start + 1, end);
        return new DtrMapMap(tok, this.mTok1, this.mTok2, dtr, this.mDtr1, this.mDtr2);
    }

    public DtrMap incrementDtrs(int[] tokIndices, int start, int end, int count) {
        if (start == end) {
            return this;
        }
        int tok = tokIndices[start];
        if (tok == this.mTok1) {
            this.mDtr1.increment(tokIndices, start + 1, end, count);
            return this;
        }
        if (tok == this.mTok2) {
            this.mDtr2.increment(tokIndices, start + 1, end, count);
            return this;
        }
        IntNode dtr = new IntNode(tokIndices, start + 1, end, count);
        return new DtrMapMap(tok, this.mTok1, this.mTok2, dtr, this.mDtr1, this.mDtr2);
    }

    public DtrMap incrementSequence(int[] tokIndices, int start, int end, int count) {
        if (start == end) {
            return this;
        }
        int tok = tokIndices[start];
        if (tok == this.mTok1) {
            this.mDtr1.incrementSequence(tokIndices, start + 1, end, count);
            return this;
        }
        if (tok == this.mTok2) {
            this.mDtr2.incrementSequence(tokIndices, start + 1, end, count);
        }
        IntNode dtr = new IntNode(tokIndices, start + 1, end, count, false);
        return new DtrMapMap(tok, this.mTok1, this.mTok2, dtr, this.mDtr1, this.mDtr2);
    }

    public int[] integersFollowing() {
        return new int[]{this.mTok1, this.mTok2};
    }

    public long extensionCount() {
        return (long)this.mDtr1.count() + (long)this.mDtr2.count();
    }
}

