/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.DtrMap;
import com.aliasi.lm.DtrMap0;
import com.aliasi.lm.DtrMap2;
import com.aliasi.lm.IntNode;
import com.aliasi.symbol.SymbolTable;
import java.util.List;

class DtrMap1
implements DtrMap {
    final int mTok;
    IntNode mDtr = new IntNode();

    public DtrMap1(int tok, IntNode dtr) {
        this.mTok = tok;
        this.mDtr = dtr;
    }

    public DtrMap prune(int minCount) {
        if (this.mDtr.count() < minCount) {
            return DtrMap0.EMPTY_DTR_MAP;
        }
        this.mDtr.prune(minCount);
        return this;
    }

    public DtrMap rescale(double countMultiplier) {
        this.mDtr.rescale(countMultiplier);
        if (this.mDtr.count() == 0) {
            return DtrMap0.EMPTY_DTR_MAP;
        }
        return this;
    }

    public int numExtensions() {
        return 1;
    }

    public void toString(StringBuffer sb, int depth, SymbolTable st) {
        if (st != null) {
            sb.append(IntNode.idToSymbol(this.mTok, st));
        } else {
            sb.append(this.mTok);
        }
        sb.append(": ");
        this.mDtr.toString(sb, depth + 1, st);
    }

    public void addDtrs(List queue) {
        queue.add(this.mDtr);
    }

    public int dtrsTrieSize() {
        return this.mDtr.trieSize();
    }

    public IntNode getDtr(int tok) {
        return tok == this.mTok ? this.mDtr : null;
    }

    public DtrMap incrementDtrs(int[] tokIndices, int start, int end) {
        if (start == end) {
            return this;
        }
        if (tokIndices[start] == this.mTok) {
            this.mDtr.increment(tokIndices, start + 1, end);
            return this;
        }
        IntNode dtr = new IntNode(tokIndices, start + 1, end);
        if (tokIndices[start] < this.mTok) {
            return new DtrMap2(tokIndices[start], this.mTok, dtr, this.mDtr);
        }
        return new DtrMap2(this.mTok, tokIndices[start], this.mDtr, dtr);
    }

    public DtrMap incrementDtrs(int[] tokIndices, int start, int end, int count) {
        if (start == end) {
            return this;
        }
        if (tokIndices[start] == this.mTok) {
            this.mDtr.increment(tokIndices, start + 1, end, count);
            return this;
        }
        IntNode dtr = new IntNode(tokIndices, start + 1, end, count);
        if (tokIndices[start] < this.mTok) {
            return new DtrMap2(tokIndices[start], this.mTok, dtr, this.mDtr);
        }
        return new DtrMap2(this.mTok, tokIndices[start], this.mDtr, dtr);
    }

    public DtrMap incrementSequence(int[] tokIndices, int start, int end, int count) {
        if (start == end) {
            return this;
        }
        if (tokIndices[start] == this.mTok) {
            this.mDtr.incrementSequence(tokIndices, start + 1, end, count);
            return this;
        }
        IntNode dtr = new IntNode(tokIndices, start + 1, end, count, false);
        if (tokIndices[start] < this.mTok) {
            return new DtrMap2(tokIndices[start], this.mTok, dtr, this.mDtr);
        }
        return new DtrMap2(this.mTok, tokIndices[start], this.mDtr, dtr);
    }

    public long extensionCount() {
        return this.mDtr.count();
    }

    public int[] integersFollowing() {
        return new int[]{this.mTok};
    }
}

