/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.LanguageModel;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Arrays;

public class CompiledNGramProcessLM
implements LanguageModel.Process,
LanguageModel.Conditional {
    private final int mMaxNGram;
    private final float mLogUniformEstimate;
    private final char[] mChars;
    private final float[] mLogProbs;
    private final float[] mLogOneMinusLambdas;
    private final int[] mFirstChild;
    private final int[] mSuffix;
    private final int mLastContextIndex;
    public static final int ROOT_NODE_INDEX = 0;
    private static final int CACHE_NOT_COMPUTED_VALUE = -1;

    CompiledNGramProcessLM(ObjectInput dataIn) throws IOException {
        int i;
        int lastInternalNodeIndex;
        this.mMaxNGram = dataIn.readInt();
        this.mLogUniformEstimate = dataIn.readFloat();
        int numTotalNodes = dataIn.readInt();
        this.mLastContextIndex = lastInternalNodeIndex = dataIn.readInt();
        this.mChars = new char[numTotalNodes];
        this.mLogProbs = new float[numTotalNodes];
        this.mSuffix = new int[numTotalNodes];
        Arrays.fill(this.mSuffix, -1);
        this.mLogOneMinusLambdas = new float[lastInternalNodeIndex + 1];
        this.mFirstChild = new int[lastInternalNodeIndex + 2];
        this.mFirstChild[lastInternalNodeIndex + 1] = numTotalNodes;
        for (i = 0; i <= lastInternalNodeIndex; ++i) {
            this.mChars[i] = dataIn.readChar();
            this.mLogProbs[i] = dataIn.readFloat();
            this.mLogOneMinusLambdas[i] = dataIn.readFloat();
            this.mFirstChild[i] = dataIn.readInt();
        }
        for (i = lastInternalNodeIndex + 1; i < numTotalNodes; ++i) {
            this.mChars[i] = dataIn.readChar();
            this.mLogProbs[i] = dataIn.readFloat();
        }
        this.compileSuffixes("", 0);
    }

    public char[] observedCharacters() {
        if (this.mFirstChild.length < 2) {
            return new char[0];
        }
        char[] result = new char[this.mFirstChild[1] - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.mChars[i + 1];
        }
        return result;
    }

    public int maxNGram() {
        return this.mMaxNGram;
    }

    public int numNodes() {
        return this.mChars.length;
    }

    public int longestContextIndex(String context) {
        char[] cs = context.toCharArray();
        int length = cs.length;
        for (int i = 0; i < length; ++i) {
            int k = this.getIndex(cs, i, length);
            if (k < 0) continue;
            while (k >= this.mLogOneMinusLambdas.length) {
                k = this.mSuffix[k];
            }
            return k;
        }
        return 0;
    }

    int numInternalNodes() {
        return this.mFirstChild.length;
    }

    private void compileSuffixes(String context, int index) {
        this.mSuffix[index] = this.suffixIndex(context);
        if (index >= this.mFirstChild.length) {
            return;
        }
        int firstChildIndex = this.mFirstChild[index];
        int lastChildIndex = index + 1 < this.mFirstChild.length ? this.mFirstChild[index + 1] : this.mChars.length;
        for (int i = firstChildIndex; i < lastChildIndex; ++i) {
            this.compileSuffixes(context + this.mChars[i], i);
        }
    }

    private int suffixIndex(String context) {
        int suffixLength = context.length() - 1;
        if (suffixLength < 0) {
            return -1;
        }
        char[] cs = new char[suffixLength];
        for (int i = 0; i < suffixLength; ++i) {
            cs[i] = context.charAt(i + 1);
        }
        return this.getIndex(cs, 0, suffixLength);
    }

    public final double log2Estimate(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.log2Estimate(cs, 0, cs.length);
    }

    public final double log2Estimate(int contextIndex, char nextChar) {
        int outcomeIndex;
        double sum = 0.0;
        int currentContextIndex = contextIndex;
        while ((outcomeIndex = this.getIndex(currentContextIndex, nextChar)) < 0) {
            if (currentContextIndex < this.mLogOneMinusLambdas.length) {
                sum += (double)this.mLogOneMinusLambdas[currentContextIndex];
            }
            if (currentContextIndex == 0) {
                return sum + (double)this.mLogUniformEstimate;
            }
            currentContextIndex = this.mSuffix[currentContextIndex];
        }
        return sum + (double)this.mLogProbs[outcomeIndex];
    }

    public int nextContext(int contextIndex, char nextChar) {
        if (contextIndex < 0 || contextIndex > this.mLastContextIndex) {
            String msg = "Context must be greater than zero. Context must be less than last index=" + this.mLastContextIndex + " Context=" + contextIndex;
            throw new IllegalArgumentException(msg);
        }
        int currentContextIndex = contextIndex;
        int outcomeIndex;
        while ((outcomeIndex = this.getIndex(currentContextIndex, nextChar)) >= this.mLogOneMinusLambdas.length || outcomeIndex < 0) {
            if (currentContextIndex == 0) {
                return 0;
            }
            currentContextIndex = this.mSuffix[currentContextIndex];
        }
        return outcomeIndex;
    }

    public final double log2Estimate(char[] cs, int start, int end) {
        int len = this.mLogOneMinusLambdas.length;
        Strings.checkArgsStartEnd(cs, start, end);
        double sum = 0.0;
        int contextIndex = 0;
        block0: for (int i = start; i < end; ++i) {
            int outcomeIndex;
            char nextChar = cs[i];
            while ((outcomeIndex = this.getIndex(contextIndex, nextChar)) < 0) {
                if (contextIndex < len) {
                    sum += (double)this.mLogOneMinusLambdas[contextIndex];
                }
                if (contextIndex == 0) {
                    sum += (double)this.mLogUniformEstimate;
                    contextIndex = 0;
                    continue block0;
                }
                contextIndex = this.mSuffix[contextIndex];
            }
            sum += (double)this.mLogProbs[outcomeIndex];
            contextIndex = outcomeIndex < len ? outcomeIndex : this.mSuffix[outcomeIndex];
        }
        return sum;
    }

    public double log2ConditionalEstimate(CharSequence cSeq) {
        char[] cs = ((Object)cSeq).toString().toCharArray();
        return this.log2ConditionalEstimate(cs, 0, cs.length);
    }

    public double log2ConditionalEstimate(char[] cs, int start, int end) {
        int maxContextLength;
        Strings.checkArgsStartEnd(cs, start, end);
        double total = 0.0;
        int contextEnd = end - 1;
        char c = cs[contextEnd];
        for (int contextLength = maxContextLength = Math.min(contextEnd - start, this.mMaxNGram - 1); contextLength >= 0; --contextLength) {
            int contextStart = contextEnd - contextLength;
            int contextIndex = this.getIndex(cs, contextStart, contextEnd);
            if (contextIndex == -1) continue;
            while (contextIndex > this.mLastContextIndex) {
                contextIndex = this.mSuffix[contextIndex];
            }
            int outcomeIndex = this.getIndex(contextIndex, c);
            if (outcomeIndex != -1) {
                return total + (double)this.mLogProbs[outcomeIndex];
            }
            total += (double)this.mLogOneMinusLambdas[contextIndex];
        }
        return total + (double)this.mLogUniformEstimate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Max NGram=" + this.mMaxNGram);
        sb.append('\n');
        sb.append("Log2 Uniform Estimate=" + this.mLogUniformEstimate);
        sb.append('\n');
        sb.append("i c suff prob 1-lambda firstChild");
        sb.append('\n');
        for (int i = 0; i < this.mChars.length; ++i) {
            sb.append(i);
            sb.append(" ");
            sb.append(this.mChars[i]);
            sb.append(" ");
            sb.append(this.mSuffix[i]);
            sb.append(" ");
            sb.append(this.mLogProbs[i]);
            if (i < this.mLogOneMinusLambdas.length) {
                sb.append(" ");
                sb.append(this.mFirstChild[i]);
                sb.append(" ");
                sb.append(this.mLogOneMinusLambdas[i]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private int getIndex(int fromIndex, char c) {
        if (fromIndex + 1 >= this.mFirstChild.length) {
            return -1;
        }
        int low = this.mFirstChild[fromIndex];
        int high = this.mFirstChild[fromIndex + 1] - 1;
        while (low <= high) {
            int mid = (high + low) / 2;
            if (this.mChars[mid] == c) {
                return mid;
            }
            if (this.mChars[mid] < c) {
                low = low == mid ? mid + 1 : mid;
                continue;
            }
            high = high == mid ? mid - 1 : mid;
        }
        return -1;
    }

    private int getIndex(char[] cs, int start, int end) {
        int index = 0;
        for (int currentStart = start; currentStart < end; ++currentStart) {
            if ((index = this.getIndex(index, cs[currentStart])) != -1) continue;
            return -1;
        }
        return index;
    }
}

