/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.hmm;

import com.aliasi.corpus.TagHandler;
import com.aliasi.hmm.AbstractHmm;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.ObjectOutput;

public abstract class AbstractHmmEstimator
extends AbstractHmm
implements TagHandler,
Compilable {
    private long mNumTrainingTokens = 0L;
    private long mNumTrainingTaggings = 0L;

    public AbstractHmmEstimator(SymbolTable table) {
        super(table);
    }

    public abstract void trainStart(String var1);

    public abstract void trainEnd(String var1);

    public abstract void trainTransit(String var1, String var2);

    public abstract void trainEmit(String var1, CharSequence var2);

    public abstract void compileTo(ObjectOutput var1) throws IOException;

    public long numTrainingCases() {
        return this.mNumTrainingTaggings;
    }

    public long numTrainingTokens() {
        return this.mNumTrainingTokens;
    }

    public void handle(String[] toks, String[] whitespaces, String[] tags) {
        ++this.mNumTrainingTaggings;
        this.mNumTrainingTokens += (long)toks.length;
        if (toks.length < 1) {
            return;
        }
        this.trainStart(tags[0]);
        for (int i = 0; i < toks.length; ++i) {
            this.trainEmit(tags[i], toks[i]);
            if (i <= 0) continue;
            this.trainTransit(tags[i - 1], tags[i]);
        }
        this.trainEnd(tags[tags.length - 1]);
    }
}

