/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.dict.DictionaryEntry;
import java.util.Arrays;

class Node {
    static final DictionaryEntry[] EMPTY_ENTRIES = new DictionaryEntry[0];
    static final char[] EMPTY_CHARS = new char[0];
    static final Node[] EMPTY_NODES = new Node[0];
    DictionaryEntry[] mEntries = EMPTY_ENTRIES;
    char[] mDtrChars = EMPTY_CHARS;
    Node[] mDtrNodes = EMPTY_NODES;

    Node() {
    }

    Node getDtr(char c) {
        int i = Arrays.binarySearch(this.mDtrChars, c);
        return i < 0 ? null : this.mDtrNodes[i];
    }

    Node getOrAddDtr(char c) {
        int i;
        Node dtr = this.getDtr(c);
        if (dtr != null) {
            return dtr;
        }
        Node result = new Node();
        char[] oldDtrChars = this.mDtrChars;
        Node[] oldDtrNodes = this.mDtrNodes;
        this.mDtrChars = new char[this.mDtrChars.length + 1];
        this.mDtrNodes = new Node[this.mDtrNodes.length + 1];
        for (i = 0; i < oldDtrChars.length && oldDtrChars[i] <= c; ++i) {
            this.mDtrChars[i] = oldDtrChars[i];
            this.mDtrNodes[i] = oldDtrNodes[i];
        }
        this.mDtrChars[i] = c;
        this.mDtrNodes[i] = result;
        while (i < oldDtrChars.length) {
            this.mDtrChars[i + 1] = oldDtrChars[i];
            this.mDtrNodes[i + 1] = oldDtrNodes[i];
            ++i;
        }
        return result;
    }

    void addEntry(DictionaryEntry entry) {
        DictionaryEntry[] oldEntries = this.mEntries;
        for (int i = 0; i < oldEntries.length; ++i) {
            if (!oldEntries[i].equals(entry)) continue;
            return;
        }
        this.mEntries = new DictionaryEntry[oldEntries.length + 1];
        this.mEntries[0] = entry;
        System.arraycopy(oldEntries, 0, this.mEntries, 1, oldEntries.length);
    }
}

