/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.dict.AbstractDictionary;
import com.aliasi.dict.DictionaryEntry;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.ObjectToSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDictionary<C>
extends AbstractDictionary<C>
implements Compilable {
    final ObjectToSet<String, DictionaryEntry<C>> mPhraseToEntrySet;

    public MapDictionary() {
        this(new ObjectToSet<String, DictionaryEntry<C>>());
    }

    private MapDictionary(ObjectToSet<String, DictionaryEntry<C>> phraseToEntrySet) {
        this.mPhraseToEntrySet = phraseToEntrySet;
    }

    @Override
    public void addEntry(DictionaryEntry<C> entry) {
        this.mPhraseToEntrySet.addMember(entry.phrase(), entry);
    }

    @Override
    public Iterator<DictionaryEntry<C>> iterator() {
        return this.mPhraseToEntrySet.memberIterator();
    }

    @Override
    public Iterator<DictionaryEntry<C>> phraseEntryIt(String phrase) {
        return this.mPhraseToEntrySet.getSet(phrase).iterator();
    }

    @Override
    public void compileTo(ObjectOutput out) throws IOException {
        out.writeObject(new Externalizer(this));
    }

    private static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = -9136273040574611243L;
        final MapDictionary mDictionary;

        public Externalizer() {
            this(null);
        }

        public Externalizer(MapDictionary dictionary) {
            this.mDictionary = dictionary;
        }

        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            MapDictionary dict = new MapDictionary();
            int numEntries = in.readInt();
            for (int i = 0; i < numEntries; ++i) {
                DictionaryEntry entry = (DictionaryEntry)in.readObject();
                dict.addEntry(entry);
            }
            return dict;
        }

        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeInt(this.mDictionary.size());
            for (DictionaryEntry entry : this.mDictionary) {
                entry.compileTo(objOut);
            }
        }
    }
}

