/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus.parsers;

import com.aliasi.corpus.StringParser;
import com.aliasi.corpus.TagHandler;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexLineTagParser
extends StringParser {
    private final Pattern mTokenTagPattern;
    private final Pattern mIgnoreLinePattern;
    private final Pattern mEosPattern;
    private final int mTokenGroup;
    private final int mTagGroup;

    public RegexLineTagParser(String matchRegex, int tokenGroup, int tagGroup, String ignoreRegex, String eosRegex) {
        this(null, matchRegex, tokenGroup, tagGroup, ignoreRegex, eosRegex);
    }

    public RegexLineTagParser(TagHandler handler, String matchRegex, int tokenGroup, int tagGroup, String ignoreRegex, String eosRegex) {
        super(handler);
        this.mTokenTagPattern = Pattern.compile(matchRegex);
        this.mTokenGroup = tokenGroup;
        this.mTagGroup = tagGroup;
        this.mIgnoreLinePattern = Pattern.compile(ignoreRegex);
        this.mEosPattern = Pattern.compile(eosRegex);
    }

    public void parseString(char[] cs, int start, int end) {
        String in = new String(cs, start, end - start);
        String[] lines = in.split("\n");
        ArrayList<String> tokenList = new ArrayList<String>();
        ArrayList<String> tagList = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            Matcher lineIgnorer = this.mIgnoreLinePattern.matcher(lines[i]);
            if (lineIgnorer.matches()) continue;
            Matcher eosMatcher = this.mEosPattern.matcher(lines[i]);
            if (eosMatcher.matches()) {
                this.handle(tokenList, tagList);
                continue;
            }
            Matcher matcher = this.mTokenTagPattern.matcher(lines[i]);
            if (!matcher.matches()) {
                String msg = "Illegal line=" + lines[i];
                throw new IllegalArgumentException(msg);
            }
            String token = matcher.group(this.mTokenGroup);
            String tag = matcher.group(this.mTagGroup);
            tokenList.add(token);
            tagList.add(tag);
        }
        this.handle(tokenList, tagList);
    }

    public TagHandler getTagHandler() {
        return (TagHandler)this.getHandler();
    }

    private void handle(ArrayList tokenList, ArrayList tagList) {
        int len = tokenList.size();
        String[] tokens = tokenList.toArray(new String[len]);
        String[] tags = tagList.toArray(new String[len]);
        this.getTagHandler().handle(tokens, null, tags);
        tokenList.clear();
        tagList.clear();
    }
}

