/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus.parsers;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.corpus.ChunkHandler;
import com.aliasi.corpus.XMLParser;
import com.aliasi.xml.DelegatingHandler;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Muc6ChunkParser
extends XMLParser<ChunkHandler> {
    String mSentenceTag = "s";

    public Muc6ChunkParser() {
    }

    public Muc6ChunkParser(ChunkHandler handler) {
        super(handler);
    }

    @Override
    protected DefaultHandler getXMLHandler() {
        return new MucHandler((ChunkHandler)this.getHandler());
    }

    public void setSentenceTag(String tag) {
        this.mSentenceTag = tag;
    }

    static class SentenceHandler
    extends DefaultHandler {
        StringBuffer mBuf;
        String mType;
        int mStart;
        int mEnd;
        final ArrayList mChunkList = new ArrayList();

        SentenceHandler() {
        }

        public void startDocument() {
            this.mBuf = new StringBuffer();
            this.mChunkList.clear();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!"ENAMEX".equals(qName)) {
                return;
            }
            this.mType = attributes.getValue("TYPE");
            this.mStart = this.mBuf.length();
        }

        public void endElement(String uri, String localName, String qName) {
            if (!"ENAMEX".equals(qName)) {
                return;
            }
            this.mEnd = this.mBuf.length();
            Chunk chunk = ChunkFactory.createChunk(this.mStart, this.mEnd, this.mType, 0.0);
            this.mChunkList.add(chunk);
        }

        public void characters(char[] cs, int start, int length) {
            this.mBuf.append(cs, start, length);
        }

        public Chunking getChunking() {
            ChunkingImpl chunking = new ChunkingImpl(this.mBuf);
            Iterator it = this.mChunkList.iterator();
            while (it.hasNext()) {
                chunking.add((Chunk)it.next());
            }
            return chunking;
        }
    }

    class MucHandler
    extends DelegatingHandler {
        ChunkHandler mChunkHandler;
        SentenceHandler mSentHandler;

        MucHandler(ChunkHandler chunkHandler) {
            this.mChunkHandler = chunkHandler;
            this.mSentHandler = new SentenceHandler();
            this.setDelegate(Muc6ChunkParser.this.mSentenceTag, this.mSentHandler);
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            Chunking chunking = this.mSentHandler.getChunking();
            this.mChunkHandler.handle(chunking);
        }
    }
}

