/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus.parsers;

import com.aliasi.corpus.Handler;
import com.aliasi.corpus.TextHandler;
import com.aliasi.corpus.XMLParser;
import com.aliasi.medline.Abstract;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import org.xml.sax.helpers.DefaultHandler;

public class MedlineTextParser
extends XMLParser {
    public MedlineTextParser() {
    }

    public MedlineTextParser(TextHandler handler) {
        super(handler);
    }

    public TextHandler getTextHandler() {
        return (TextHandler)this.getHandler();
    }

    public void setHandler(Handler handler) {
        if (!(handler instanceof TextHandler)) {
            String msg = "Handler must implement the TextHandler interface. Found class=" + handler.getClass();
            throw new IllegalArgumentException(msg);
        }
        super.setHandler(handler);
    }

    public DefaultHandler getXMLHandler() {
        return new XMLHandler((TextHandler)this.getHandler());
    }

    private static class AbstractHandler
    extends DelegatingHandler {
        TextAccumulatorHandler mTextAccumulator = new TextAccumulatorHandler();

        public AbstractHandler() {
            this.setDelegate("AbstractText", this.mTextAccumulator);
        }

        public void startDocument() {
            this.mTextAccumulator.reset();
        }

        String getText() {
            return this.mTextAccumulator.getText();
        }
    }

    private static class XMLHandler
    extends DelegatingHandler {
        TextHandler mTextHandler;
        AbstractHandler mAbstractHandler = new AbstractHandler();

        XMLHandler(TextHandler textHandler) {
            this.mTextHandler = textHandler;
            this.setDelegate("Abstract", this.mAbstractHandler);
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("Abstract")) {
                String text = this.mAbstractHandler.getText();
                String strippedText = Abstract.textWithoutTruncationMarker(text);
                char[] cs = strippedText.toCharArray();
                this.mTextHandler.handle(cs, 0, cs.length);
            }
        }
    }
}

