/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus.parsers;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.corpus.ChunkHandler;
import com.aliasi.corpus.Handler;
import com.aliasi.corpus.XMLParser;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeniaSentenceParser
extends XMLParser {
    public static final String GENIA_SENTENCE_ELT = "sentence";
    public static final String GENIA_ABSTRACT_ELT = "abstract";

    public GeniaSentenceParser() throws SAXException {
    }

    public GeniaSentenceParser(ChunkHandler handler) throws SAXException {
        super(handler);
    }

    protected DefaultHandler getXMLHandler() {
        return new SetHandler(this.getChunkHandler());
    }

    public void setHandler(Handler handler) {
        if (!(handler instanceof ChunkHandler)) {
            String msg = "Handler must be a chunk handler. Found handler with class=" + handler.getClass();
            throw new IllegalArgumentException(msg);
        }
        super.setHandler(handler);
    }

    public ChunkHandler getChunkHandler() {
        return (ChunkHandler)this.getHandler();
    }

    private static class AbstractHandler
    extends DelegateHandler {
        final ArrayList mSentTexts = new ArrayList();
        final TextAccumulatorHandler mSentenceHandler = new TextAccumulatorHandler();

        public AbstractHandler(DelegatingHandler parent) {
            super(parent);
            this.setDelegate(GeniaSentenceParser.GENIA_SENTENCE_ELT, this.mSentenceHandler);
        }

        public void startDocument() {
            this.mSentTexts.clear();
        }

        public void finishDelegate(String qName, DefaultHandler delegate) {
            String text;
            if (qName.equals(GeniaSentenceParser.GENIA_SENTENCE_ELT) && (text = this.mSentenceHandler.getText().trim()).length() > 0) {
                this.mSentTexts.add(text);
            }
        }

        List getSentenceTexts() {
            return this.mSentTexts;
        }
    }

    private static class SetHandler
    extends DelegatingHandler {
        final ChunkHandler mChunkHandler;
        final AbstractHandler mAbstractHandler;

        SetHandler(ChunkHandler chunkHandler) {
            this.mChunkHandler = chunkHandler;
            this.mAbstractHandler = new AbstractHandler(this);
            this.setDelegate(GeniaSentenceParser.GENIA_ABSTRACT_ELT, this.mAbstractHandler);
        }

        public void finishDelegate(String qName, DefaultHandler delegate) {
            if (qName.equals(GeniaSentenceParser.GENIA_ABSTRACT_ELT)) {
                this.handleSentenceTexts(this.mAbstractHandler.getSentenceTexts());
            }
        }

        void handleSentenceTexts(List texts) {
            StringBuffer sb = new StringBuffer();
            int numChunks = texts.size();
            int[] lengths = new int[numChunks];
            for (int i = 0; i < numChunks; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                String text = (String)texts.get(i);
                sb.append(text);
                lengths[i] = text.length();
            }
            char[] cs = sb.toString().toCharArray();
            int offset = 0;
            ChunkingImpl chunking = new ChunkingImpl(cs, 0, cs.length);
            for (int i = 0; i < numChunks; ++i) {
                Chunk chunk = ChunkFactory.createChunk(offset, offset + lengths[i], "S");
                chunking.add(chunk);
                offset += lengths[i] + 1;
            }
            this.mChunkHandler.handle(chunking);
        }
    }
}

