/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus.parsers;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.corpus.ChunkHandler;
import com.aliasi.corpus.Handler;
import com.aliasi.corpus.XMLParser;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeniaEntityChunkParser
extends XMLParser {
    private static final int SIMPLIFY_TYPE_GROUP = 1;
    private static final Pattern SIMPLIFY_TYPE_PATTERN = Pattern.compile("G#([a-zA-Z_]+)");
    public static final String GENIA_SENTENCE_ELT = "sentence";
    public static final String GENIA_ENTITY_ELT = "cons";
    public static final String GENIA_ENTITY_TYPE_ATT = "sem";

    public GeniaEntityChunkParser() throws SAXException {
    }

    public GeniaEntityChunkParser(ChunkHandler handler) throws SAXException {
        super(handler);
    }

    public void setHandler(Handler handler) {
        if (handler != null && !(handler instanceof ChunkHandler)) {
            String msg = "Handler must be a chunk handler. Found handler with class=" + handler.getClass();
            throw new IllegalArgumentException(msg);
        }
        super.setHandler(handler);
    }

    public ChunkHandler getChunkHandler() {
        return (ChunkHandler)this.getHandler();
    }

    protected DefaultHandler getXMLHandler() {
        return new SetHandler(this, this.getChunkHandler());
    }

    public String simplifyType(String originalGeniaType) {
        Matcher matcher = SIMPLIFY_TYPE_PATTERN.matcher(originalGeniaType);
        matcher.find();
        return matcher.group(1);
    }

    private static class SentenceHandler
    extends DelegateHandler {
        StringBuffer mBuf;
        ArrayList mChunkList;
        int mChunkDepth;
        int mChunkStart;
        String mChunkType;
        final GeniaEntityChunkParser mGECP;

        public SentenceHandler(GeniaEntityChunkParser gecp, DelegatingHandler parent) {
            super(parent);
            this.mGECP = gecp;
        }

        public void startDocument() {
            this.mBuf = new StringBuffer();
            this.mChunkList = new ArrayList();
            this.mChunkDepth = 0;
        }

        public void startElement(String namespace, String localName, String qName, Attributes atts) {
            if (qName.equals(GeniaEntityChunkParser.GENIA_ENTITY_ELT) && this.mChunkDepth++ == 0) {
                this.mChunkStart = this.mBuf.length();
                String origType = atts.getValue(GeniaEntityChunkParser.GENIA_ENTITY_TYPE_ATT);
                this.mChunkType = this.mGECP.simplifyType(origType);
            }
        }

        public void characters(char[] cs, int start, int length) {
            this.mBuf.append(cs, start, length);
        }

        public void endElement(String namespace, String localName, String qName) {
            if (qName.equals(GeniaEntityChunkParser.GENIA_ENTITY_ELT) && --this.mChunkDepth == 0) {
                int chunkEnd = this.mBuf.length();
                Chunk chunk = ChunkFactory.createChunk(this.mChunkStart, chunkEnd, this.mChunkType);
                this.mChunkList.add(chunk);
            }
        }

        Chunking getChunking() {
            ChunkingImpl chunking = new ChunkingImpl(this.mBuf);
            for (Chunk chunk : this.mChunkList) {
                chunking.add(chunk);
            }
            return chunking;
        }
    }

    private static class SetHandler
    extends DelegatingHandler {
        final ChunkHandler mChunkHandler;
        final SentenceHandler mSentenceHandler;
        final GeniaEntityChunkParser mGECP;

        SetHandler(GeniaEntityChunkParser gecp, ChunkHandler chunkHandler) {
            this.mGECP = gecp;
            this.mChunkHandler = chunkHandler;
            this.mSentenceHandler = new SentenceHandler(gecp, this);
            this.setDelegate(GeniaEntityChunkParser.GENIA_SENTENCE_ELT, this.mSentenceHandler);
        }

        public void finishDelegate(String qName, DefaultHandler delegate) {
            if (qName.equals(GeniaEntityChunkParser.GENIA_SENTENCE_ELT)) {
                this.mChunkHandler.handle(this.mSentenceHandler.getChunking());
            }
        }
    }
}

